/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.odukspring;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ngwdm.odukspring.TEODUkSPRingUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEQuerySwitchStatusBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String ODUK_SPRING_RES = "ngwdm" + File.separator + "res" + File.separator + "odukspring" + File.separator + "odukspringres_" + LANGUAGE + ".ini";
    private TEResourceUtil res = null;

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            this.res = TEGetFilePath.getResource((int)neid, (String)ODUK_SPRING_RES);
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            String operateObject = "";
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            operateObject = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            if (errorCode == 0 || errorCode == 2 || errorCode == 1) {
                RowParams rowParams = outputData.getBussinessParams().getRowParams(0);
                this.setSwitchStatusLogInfo(rowParams, ipAddress, userID, operateObject, loginfoList);
            } else {
                int count = inputData.getBussinessParams().getRowParamsCount();
                for (int j = 0; j < count; ++j) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.res.getString("protection_group_id"));
                    String groupId = inputData.getBussinessParams().getRowParams(j).getParam("groupId").getValue();
                    TELogInfo logInfo = new TELogInfo();
                    sb.append(groupId);
                    logInfo.setOperateDesc(sb.toString());
                    logInfo.setErrCode(errorCode);
                    logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                    logInfo.setResult(2);
                    logInfo.setCmdID(subfunc.getCode());
                    logInfo.setLocation(ipAddress);
                    logInfo.setUserID(userID);
                    logInfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                    logInfo.setOperateObject(operateObject);
                    logInfo.setOperateName(subfunc.getSubFuncDes(neid));
                    loginfoList.add(logInfo);
                }
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private void setSwitchStatusLogInfo(RowParams rowParams, String ipAddress, int userID, String operateObject, List loginfoList) {
        int errorCount = rowParams.getRowErrorsCount();
        boolean failFlag = false;
        for (int i = 0; i < errorCount; ++i) {
            RowErrors rowErrors = rowParams.getRowErrors(i);
            int errorCode = Integer.parseInt(rowErrors.getErrorMessage().getErrorcode());
            if (0 == errorCode) continue;
            TELogInfo logInfo = new TELogInfo();
            logInfo.setCmdID(this.subfunc.getCode());
            logInfo.setLocation(ipAddress);
            logInfo.setUserID(userID);
            logInfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            logInfo.setOperateObject(operateObject);
            logInfo.setOperateName(this.subfunc.getSubFuncDes(this.neid));
            StringBuffer sb = new StringBuffer();
            String groupId = rowErrors.getParam("groupId").getValue();
            sb.append(this.res.getString("protection_group_id")).append(groupId);
            logInfo.setOperateDesc(sb.toString());
            logInfo.setErrCode(errorCode);
            logInfo.setErrInfo(rowErrors.getErrorMessage().getErrorinfo());
            logInfo.setResult(2);
            loginfoList.add(logInfo);
            failFlag = true;
        }
        if (!failFlag) {
            TELogInfo logInfo = new TELogInfo();
            logInfo.setCmdID(this.subfunc.getCode());
            logInfo.setLocation(ipAddress);
            logInfo.setUserID(userID);
            logInfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            logInfo.setOperateObject(operateObject);
            logInfo.setOperateName(this.subfunc.getSubFuncDes(this.neid));
            StringBuffer sb = new StringBuffer();
            String groupId = rowParams.getParam("groupId").getValue();
            sb.append(this.res.getString("protection_group_id")).append(groupId).append(",");
            int pageStatus = Integer.parseInt(rowParams.getParam("pageStatus").getValue());
            sb.append(this.res.getString("page_status")).append(TEODUkSPRingUtil.getCurrentPageStatus(pageStatus, this.res)).append(",");
            int switchStatus = Integer.parseInt(rowParams.getParam("westSwitchRequest").getValue());
            String switchStatusStr = TEODUkSPRingUtil.getSwitchRequestStr(switchStatus, this.res);
            sb.append(this.res.getString("west_path_switch_request")).append(switchStatusStr).append(",");
            switchStatus = Integer.parseInt(rowParams.getParam("eastSwitchRequest").getValue());
            switchStatusStr = TEODUkSPRingUtil.getSwitchRequestStr(switchStatus, this.res);
            sb.append(this.res.getString("east_path_switch_request")).append(switchStatusStr).append(",");
            int pathStatus = Integer.parseInt(rowParams.getParam("westWorkStatus").getValue());
            String pathStatusStr = TEODUkSPRingUtil.getPathStatus(pathStatus, this.res);
            sb.append(this.res.getString("west_work_path_status")).append(pathStatusStr).append(",");
            pathStatus = Integer.parseInt(rowParams.getParam("westProtectionStatus").getValue());
            pathStatusStr = TEODUkSPRingUtil.getPathStatus(pathStatus, this.res);
            sb.append(this.res.getString("west_protection_path_status")).append(pathStatusStr).append(",");
            pathStatus = Integer.parseInt(rowParams.getParam("eastWorkStatus").getValue());
            pathStatusStr = TEODUkSPRingUtil.getPathStatus(pathStatus, this.res);
            sb.append(this.res.getString("east_work_path_status")).append(pathStatusStr).append(",");
            pathStatus = Integer.parseInt(rowParams.getParam("eastProtectionStatus").getValue());
            pathStatusStr = TEODUkSPRingUtil.getPathStatus(pathStatus, this.res);
            sb.append(this.res.getString("east_protection_path_status")).append(pathStatusStr);
            logInfo.setOperateDesc(sb.toString());
            logInfo.setResult(0);
            logInfo.setErrCode(0);
            logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)0));
            loginfoList.add(logInfo);
        }
    }
}

