/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.odukspring;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;

public abstract class TEQueryMappedPathSuperBean
extends TENEExplorerBean {
    protected static final int VOID_VALUE = 255;
    protected static final int errorCode0 = 38662;
    protected static final int errorCode1 = 39326;
    protected static final String DEFAULT_ZERO = "0";
    protected static final String NE_NOT_LOGIN = "37926";
    protected static final int WTR_TIME_MIN = 0;
    protected static final int WTR_TIME_MAX = 100;
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final int LAYER_ODU = 1;
    private static final String ODUK_SPRING_RES = "ngwdm" + File.separator + "res" + File.separator + "odukspring" + File.separator + "odukspringres_" + LANGUAGE + ".ini";

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>();
        filterErrorCodeList.add(38662);
        filterErrorCodeList.add(39326);
        return filterErrorCodeList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        if (!operationList.isEmpty()) {
            int m = operationList.size();
            for (int i = 0; i < m; ++i) {
                Operation operation = (Operation)operationList.get(i);
                String operName = operation.getName();
                if (operName.equalsIgnoreCase("NSCMD_OPS_GET_ODUSP_PROTUNIT")) {
                    this.handleProtecionPairOperation(operation);
                    continue;
                }
                if (operName.equalsIgnoreCase("NSCMD_OPS_GET_ODUSP_DELAYTIME")) {
                    this.handlerDelayTimeOperation(operation);
                    continue;
                }
                if (operName.equalsIgnoreCase("NSCMD_OPS_GET_ODUSP_BANDID") || operName.equalsIgnoreCase("NSCMD_OPS_GET_ITGODUSP_BANDID")) {
                    this.handleSectionIDOperation(operation);
                    continue;
                }
                if (!operName.equalsIgnoreCase("NSCMD_OPS_GET_ODUSP_SWSTATE")) continue;
                this.handleSwitchStatusOperation(operation);
            }
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        RowParams[] rowParams = bussinessParams.getRowParams();
        if (!this.outputData.getErrorMessage().getErrorcode().equals(DEFAULT_ZERO)) {
            RowParams rowparam = null;
            RowErrors rowErrors = null;
            int len = rowParams.length;
            for (int i = 0; i < len; ++i) {
                rowparam = rowParams[i];
                if (0 == rowparam.getRowErrorsCount() || !(rowErrors = rowparam.getRowErrors(0)).getErrorMessage().getErrorcode().equals(NE_NOT_LOGIN)) continue;
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_LOGIN)));
                for (int j = rowparam.getRowErrorsCount() - 1; j >= 0; --j) {
                    rowparam.removeRowErrors(rowparam.getRowErrors(j));
                }
                return;
            }
        }
        for (int k = rowParams.length - 1; k >= 0; --k) {
            boolean isSuccess = true;
            int errorCount = rowParams[k].getRowErrorsCount();
            for (int kk = 0; kk < errorCount; ++kk) {
                RowErrors rowErrors = rowParams[k].getRowErrors(kk);
                if (DEFAULT_ZERO.equals(rowErrors.getErrorMessage().getErrorcode())) continue;
                isSuccess = false;
                break;
            }
            if (!isSuccess) continue;
            Param param = rowParams[k].getParam("pathMapped");
            if (null != param && !"".equals(param.getValue())) {
                int proUnit = Integer.parseInt(rowParams[k].getParam("protectionUnit").getValue());
                param = rowParams[k].getParam("sectionId");
                if ((1 == proUnit || 3 == proUnit) && "".equals(param.getValue())) {
                    param.setValue(DEFAULT_ZERO);
                }
                if ("".equals((param = rowParams[k].getParam("delayTime")).getValue())) {
                    param.setValue(DEFAULT_ZERO);
                }
                if (!"".equals((param = rowParams[k].getParam("pathStatus")).getValue())) continue;
                param.setValue(String.valueOf(255));
                continue;
            }
            this.outputData.getBussinessParams().removeRowParams(k);
        }
    }

    private void handlerDelayTimeOperation(Operation operation) {
        Output[] outputes = operation.getOutput();
        for (int i = outputes.length - 1; i >= 0; --i) {
            Output output = outputes[i];
            boolean isSuccess = true;
            int n = output.getFaultCount();
            for (int j = 0; j < n; ++j) {
                if (output.getFault(0).getCode().equals(DEFAULT_ZERO)) continue;
                isSuccess = false;
                break;
            }
            if (!isSuccess) continue;
            if (null != output.getPartValue("groupId")) {
                int delayTime = Integer.parseInt(output.getPartValue("delayTime"));
                if (delayTime >= 0 && delayTime <= 100) {
                    output.setPartValue("delayTime", String.valueOf((float)delayTime / 10.0f));
                    continue;
                }
                output.setPartValue("delayTime", DEFAULT_ZERO);
                continue;
            }
            operation.removeOutput(i);
        }
    }

    private void handleProtecionPairOperation(Operation operation) {
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        String proType = this.inputData.getBussinessParams().getRowParams(0).getParam("protectionType").getValue();
        Output[] outputes = operation.getOutput();
        for (int i = outputes.length - 1; i >= 0; --i) {
            Output output = outputes[i];
            boolean isSuccess = true;
            int n = output.getFaultCount();
            for (int j = 0; j < n; ++j) {
                if (output.getFault(0).getCode().equals(DEFAULT_ZERO)) continue;
                isSuccess = false;
                break;
            }
            if (!isSuccess) continue;
            if (null != output.getPartValue("groupId")) {
                int slotId = Integer.parseInt(output.getPartValue("slotId"));
                int boardType = mgr.getBoardType(this.neid, slotId);
                String boardTypeName = mgr.getBoardTypeName(this.neid, boardType);
                int portId = Integer.parseInt(output.getPartValue("portId"));
                String portName = mgr.getPortName(this.neid, slotId, boardType, portId);
                int pathId = Integer.parseInt(output.getPartValue("pathId"));
                String showPath = String.valueOf(pathId);
                TEOTNModelDataMgr otnModelInstance = TEOTNModelDataMgr.getInstance();
                int grade = otnModelInstance.getGradeFromBoard(boardType);
                if (grade != -1) {
                    int convertPathId = otnModelInstance.getNmPath(1, grade, pathId, boardType);
                    convertPathId = convertPathId == -1 ? pathId : convertPathId;
                    showPath = TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(convertPathId);
                }
                StringBuffer pathMapped = new StringBuffer();
                String srName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotId);
                if (!"".equals(srName)) {
                    pathMapped.append(srName).append('-').append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotId)).append('-');
                } else {
                    pathMapped.append(slotId).append('-');
                }
                pathMapped.append(boardTypeName).append('-');
                if (grade != -1) {
                    pathMapped.append(portName).append(':');
                    pathMapped.append(showPath);
                } else {
                    pathMapped.append(portName).append('-');
                    pathMapped.append(proType).append(':').append(showPath);
                }
                Part part = new Part();
                part.setName("pathMapped");
                part.setValue(pathMapped.toString());
                output.addPart(part);
                continue;
            }
            operation.removeOutput(i);
        }
    }

    private void handleSwitchStatusOperation(Operation operation) {
        Output[] outputes = operation.getOutput();
        for (int i = outputes.length - 1; i >= 0; --i) {
            Output output = outputes[i];
            boolean isSuccess = true;
            int n = output.getFaultCount();
            for (int j = 0; j < n; ++j) {
                if (output.getFault(0).getCode().equals(DEFAULT_ZERO)) continue;
                isSuccess = false;
                break;
            }
            if (!isSuccess) continue;
            if (null != output.getPartValue("groupId")) {
                int epState;
                int ewState;
                int wpState;
                Output tmp = new Output();
                int m = output.getFaultCount();
                for (int k = 0; k < m; ++k) {
                    tmp.addFault((Fault)output.getFault(k).clone());
                }
                Part part = output.getPart("groupId");
                tmp.addPart(part);
                part = new Part();
                part.setName("protectionUnit");
                part.setValue("");
                tmp.addPart(part);
                part = new Part();
                part.setName("pathStatus");
                part.setValue("");
                tmp.addPart(part);
                int wwState = Integer.parseInt(output.getPartValue("westWorkStatus"));
                if (255 != wwState) {
                    tmp.setPartValue("protectionUnit", String.valueOf(1));
                    tmp.setPartValue("pathStatus", String.valueOf(wwState));
                    operation.addOutput((Output)tmp.clone());
                }
                if (255 != (wpState = Integer.parseInt(output.getPartValue("westProtectionStatus")))) {
                    tmp.setPartValue("protectionUnit", String.valueOf(2));
                    tmp.setPartValue("pathStatus", String.valueOf(wpState));
                    operation.addOutput((Output)tmp.clone());
                }
                if (255 != (ewState = Integer.parseInt(output.getPartValue("eastWorkStatus")))) {
                    tmp.setPartValue("protectionUnit", String.valueOf(3));
                    tmp.setPartValue("pathStatus", String.valueOf(ewState));
                    operation.addOutput((Output)tmp.clone());
                }
                if (255 != (epState = Integer.parseInt(output.getPartValue("eastProtectionStatus")))) {
                    tmp.setPartValue("protectionUnit", String.valueOf(4));
                    tmp.setPartValue("pathStatus", String.valueOf(epState));
                    operation.addOutput((Output)tmp.clone());
                }
            }
            operation.removeOutput(i);
        }
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            TEResourceUtil res = TEGetFilePath.getResource((int)neid, (String)ODUK_SPRING_RES);
            String desc = subfunc.getSubFuncDes(neid);
            String userName = TESysManagerBean.getInstance().getSysUser();
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(subfunc.getCode());
            loginfo.setLocation(ipAddress);
            loginfo.setOperateName(desc);
            loginfo.setUserName(userName);
            loginfo.setOperateObject("");
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (null == neObj) {
                loginfo.setOperateObject(String.valueOf(neid));
            } else {
                loginfo.setOperateObject(neObj.getNEName());
            }
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            loginfo.setUserID(userID);
            StringBuffer detail = new StringBuffer();
            detail.append(res.getString("protection_group_id")).append(inputData.getBussinessParams().getRowParams(0).getParam("groupId").getValue()).append(',');
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1 || errorCode == 0) {
                int rowCount = outputData.getBussinessParams().getRowParamsCount();
                ErrorMessage errorMessage = null;
                for (int i = 0; i < rowCount; ++i) {
                    RowParams rowParams = outputData.getBussinessParams().getRowParams(i);
                    int errorCount = rowParams.getRowErrorsCount();
                    if (errorCount > 0) {
                        errorMessage = rowParams.getRowErrors(0).getErrorMessage();
                        continue;
                    }
                    int protectionUnit = Integer.parseInt(rowParams.getParam("protectionUnit").getValue());
                    String protectionTypeStr = "";
                    switch (protectionUnit) {
                        case 1: {
                            protectionTypeStr = protectionTypeStr + res.getString("west_work_unit");
                            break;
                        }
                        case 2: {
                            protectionTypeStr = protectionTypeStr + res.getString("west_protection_unit");
                            break;
                        }
                        case 3: {
                            protectionTypeStr = protectionTypeStr + res.getString("east_work_unit");
                            break;
                        }
                        case 4: {
                            protectionTypeStr = protectionTypeStr + res.getString("east_protection_unit");
                            break;
                        }
                    }
                    detail.append(protectionTypeStr).append(rowParams.getParam("pathMapped").getValue()).append(',');
                }
                loginfo.setOperateDesc(detail.toString().substring(0, detail.toString().length() - 1));
                loginfo.setResult(errorCode);
                if (null != errorMessage) {
                    loginfo.setErrCode(Integer.parseInt(errorMessage.getErrorcode()));
                    loginfo.setErrInfo(errorMessage.getErrorinfo());
                } else {
                    loginfo.setErrCode(errorCode);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                }
            } else if (2 == errorCode) {
                loginfo.setOperateDesc(detail.toString().substring(0, detail.toString().length() - 1));
                loginfo.setResult(2);
                int rowCount = outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < rowCount; ++i) {
                    RowParams rowParams = outputData.getBussinessParams().getRowParams(i);
                    ErrorMessage errorMessage = rowParams.getRowErrors(0).getErrorMessage();
                    loginfo.setErrCode(Integer.parseInt(errorMessage.getErrorcode()));
                    loginfo.setErrInfo(errorMessage.getErrorinfo());
                }
            } else {
                loginfo.setOperateDesc(detail.toString().substring(0, detail.toString().length() - 1));
                loginfo.setResult(2);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            }
            TELogMgr.writeLog((TELogInfo)loginfo);
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
        }
    }

    protected abstract void handleSectionIDOperation(Operation var1);
}

