/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.odukspring;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.circuitpack.TESupportODUkSPRingBoardTypeBean;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEParseXMLSingletonBean {
    private HashMap odukSPRingBoardType = new HashMap();
    private static TEParseXMLSingletonBean m_instance = null;
    private static final String FILE_PATH = "nemgr" + File.separator + "ngwdm" + File.separator + "conf" + File.separator + "odukspring" + File.separator + "odukspringboardtype.xml";

    public static synchronized TEParseXMLSingletonBean getInstance() {
        if (m_instance == null) {
            m_instance = new TEParseXMLSingletonBean();
        }
        return m_instance;
    }

    public List getBoardType(int neid, int level) {
        Map boardMap;
        Integer levelInteger;
        ArrayList boardTypeList = new ArrayList();
        if (this.odukSPRingBoardType.isEmpty()) {
            this.loadBoardTypeData(neid);
        }
        if (this.odukSPRingBoardType.containsKey(levelInteger = new Integer(level))) {
            boardTypeList.addAll((List)this.odukSPRingBoardType.get(levelInteger));
        }
        if ((boardMap = TECircuitPackDescription.getInstance().getOdukSpringMap()).containsKey(levelInteger)) {
            boardTypeList.addAll((Collection)boardMap.get(levelInteger));
        }
        return boardTypeList;
    }

    private TEParseXMLSingletonBean() {
    }

    private void loadBoardTypeData(int neid) {
        Bundle bundle = FrameworkUtil.getBundle(TEParseXMLSingletonBean.class);
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile((Bundle)bundle, (String)FILE_PATH);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse XML File fail!", (Throwable)e);
            return;
        }
        NodeList firstNodeList = doc.getChildNodes();
        Node firstNode = firstNodeList.item(0);
        NodeList secondNodeList = firstNode.getChildNodes();
        int m = secondNodeList.getLength();
        for (int i = 0; i < m; ++i) {
            Node secondNode = secondNodeList.item(i);
            if (!secondNode.getNodeName().equalsIgnoreCase("level")) continue;
            Integer level = Integer.valueOf(secondNode.getAttributes().getNamedItem("value").getNodeValue());
            ArrayList<TESupportODUkSPRingBoardTypeBean> boardTypeList = new ArrayList<TESupportODUkSPRingBoardTypeBean>();
            NodeList thirdNodeList = secondNode.getChildNodes();
            int n = thirdNodeList.getLength();
            for (int j = 0; j < n; ++j) {
                Node thirdNode = thirdNodeList.item(j);
                if (!thirdNode.getNodeName().equalsIgnoreCase("boardtype")) continue;
                NamedNodeMap namedNodeMap = thirdNode.getAttributes();
                String boardTypeName = namedNodeMap.getNamedItem("name").getNodeValue();
                int boardType = Integer.parseInt(namedNodeMap.getNamedItem("value").getNodeValue());
                String portStr = namedNodeMap.getNamedItem("portlist").getNodeValue();
                int pathNum = Integer.parseInt(namedNodeMap.getNamedItem("pathnum").getNodeValue());
                int pathBegin = 0;
                if (namedNodeMap.getNamedItem("pathbegin") != null) {
                    pathBegin = Integer.valueOf(namedNodeMap.getNamedItem("pathbegin").getNodeValue());
                }
                ArrayList<Integer> portList = new ArrayList<Integer>();
                StringTokenizer token = new StringTokenizer(portStr, ",");
                while (token.hasMoreTokens()) {
                    String subStr = token.nextToken();
                    int index = subStr.indexOf("-");
                    if (index > 0) {
                        int max = Integer.parseInt(subStr.substring(index + 1));
                        for (int min = Integer.parseInt(subStr.substring(0, index)); min <= max; ++min) {
                            portList.add(new Integer(min));
                        }
                        continue;
                    }
                    portList.add(Integer.valueOf(subStr));
                }
                TESupportODUkSPRingBoardTypeBean boardTypeBean = new TESupportODUkSPRingBoardTypeBean(boardType, boardTypeName, portList, pathNum, pathBegin);
                boardTypeList.add(boardTypeBean);
            }
            this.odukSPRingBoardType.put(level, boardTypeList);
        }
    }
}

