/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.odukspring;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TEODUkSPRingApplyBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String ODUK_SPRING_RES = "ngwdm" + File.separator + "res" + File.separator + "odukspring" + File.separator + "odukspringres_" + LANGUAGE + ".ini";
    private TEResourceUtil res = null;

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            String operateObject = "";
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            operateObject = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            String operateName = subfunc.getSubFuncDes(neid);
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            Map detailMap = this.getOperationInfo();
            Set entrySet = detailMap.entrySet();
            Iterator iter = entrySet.iterator();
            while (iter.hasNext()) {
                TELogInfo logInfo = new TELogInfo();
                logInfo.setCmdID(subfunc.getCode());
                logInfo.setLocation(ipAddress);
                logInfo.setUserID(userID);
                logInfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                logInfo.setOperateObject(operateObject);
                logInfo.setOperateName(operateName);
                Map.Entry e = iter.next();
                String desc = ((StringBuffer)e.getValue()).toString();
                logInfo.setOperateDesc(desc.substring(0, desc.length() - 1));
                int groupId = Integer.parseInt((String)e.getKey());
                int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
                if (0 == errorCode || 1 == errorCode || 2 == errorCode) {
                    boolean flag = true;
                    RowParams[] rowParams = outputData.getBussinessParams().getRowParams();
                    int m = rowParams.length;
                    for (int i = 0; i < m; ++i) {
                        int errorCount = rowParams[i].getRowErrorsCount();
                        for (int j = 0; j < errorCount; ++j) {
                            RowErrors rowErrors = rowParams[i].getRowErrors(j);
                            int key = Integer.parseInt(rowErrors.getParam("groupId").getValue());
                            if (key != groupId) continue;
                            logInfo.setResult(2);
                            logInfo.setErrCode(Integer.parseInt(rowErrors.getErrorMessage().getErrorcode()));
                            logInfo.setErrInfo(rowErrors.getErrorMessage().getErrorinfo());
                            flag = false;
                            break;
                        }
                        if (!flag) break;
                    }
                    if (flag) {
                        logInfo.setResult(0);
                        logInfo.setErrCode(0);
                        logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)0));
                    }
                } else {
                    logInfo.setResult(2);
                    logInfo.setErrCode(errorCode);
                    logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                }
                loginfoList.add(logInfo);
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private Map getOperationInfo() {
        this.res = TEGetFilePath.getResource((int)this.neid, (String)ODUK_SPRING_RES);
        HashMap<String, StringBuffer> descMap = new HashMap<String, StringBuffer>();
        StringBuffer desc = null;
        RowParams[] rowParams = this.inputData.getBussinessParams().getRowParams();
        int len = rowParams.length;
        for (int i = 0; i < len; ++i) {
            Param param = rowParams[i].getParam("groupId");
            String groupId = param.getValue();
            if (descMap.containsKey(groupId)) {
                desc = (StringBuffer)descMap.get(groupId);
            } else {
                desc = new StringBuffer();
                descMap.put(groupId, desc);
                desc.append(this.res.getString("protection_group_id")).append(groupId).append(",");
            }
            param = rowParams[i].getParam("protectionUnit");
            if (null != param) {
                if (!rowParams[i].getParam("delayTime").getModifyFlag()) continue;
                int proUnit = Integer.parseInt(param.getValue());
                String direction = "";
                switch (proUnit) {
                    case 1: {
                        direction = this.res.getString("west_work_unit");
                        break;
                    }
                    case 2: {
                        direction = this.res.getString("west_protection_unit");
                        break;
                    }
                    case 3: {
                        direction = this.res.getString("east_work_unit");
                        break;
                    }
                    case 4: {
                        direction = this.res.getString("east_protection_unit");
                        break;
                    }
                }
                String pathMapped = rowParams[i].getParam("pathMapped").getValue();
                desc.append(direction).append(pathMapped).append(",");
                int delayTime = Integer.parseInt(rowParams[i].getParam("delayTime").getValue());
                desc.append(this.res.getString("delay_time")).append((float)delayTime / 10.0f).append("s,");
                continue;
            }
            if (rowParams[i].getParam("wtrTime").getModifyFlag()) {
                param = rowParams[i].getParam("wtrTime");
                desc.append(this.res.getString("wrt_time")).append(param.getValue()).append("s,");
            }
            if (rowParams[i].getParam("sdEnable").getModifyFlag()) {
                int sdFlag = Integer.parseInt(rowParams[i].getParam("sdEnable").getValue());
                String sdFlagStr = this.res.getString("disable");
                if (1 == sdFlag) {
                    sdFlagStr = this.res.getString("enable");
                }
                desc.append(this.res.getString("sd_enable_flag")).append(sdFlagStr).append(",");
            }
            if (!rowParams[i].getParam("mainNode").getModifyFlag()) continue;
            int mainNode = Integer.parseInt(rowParams[i].getParam("mainNode").getValue());
            String mainNodeStr = this.res.getString("no");
            if (1 == mainNode) {
                mainNodeStr = this.res.getString("yes");
            }
            desc.append(this.res.getString("main_node")).append(mainNodeStr).append(",");
        }
        return descMap;
    }
}

