/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.odukspring;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ngwdm.odukspring.TEODUkSPRingUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;

public class TECreateODUkSPRingBean
extends TENEExplorerBean {
    private static final int PROTECTION_GROUPID_MIN = 1;
    private static final int PROTECTION_GROUPID_MAX = 65535;
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String ODUK_SPRING_RES = "ngwdm" + File.separator + "res" + File.separator + "odukspring" + File.separator + "odukspringres_" + LANGUAGE + ".ini";
    private TEResourceUtil res = null;
    private int groupId = 0;

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            this.groupId = Integer.valueOf(inputData.getBussinessParams().getRowParams()[0].getParam("groupId").getValue());
            this.operationList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid);
            this.operationList.add(TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_VERIFY"));
            return this.operationList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        try {
            int retCode;
            int result = 0;
            for (int i = operationList.size() - 1; i >= 0; --i) {
                Output output;
                int errorCode;
                Operation operation = (Operation)operationList.get(i);
                if (!operation.getName().equals("NSCMD_CFG_VERIFY") || (errorCode = Integer.parseInt((output = operation.getOutput(0)).getFault(0).getCode())) == 0) continue;
                operationList.remove(i);
                result = errorCode;
                break;
            }
            this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
            if (result != 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (0 == (retCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) || 1 == retCode) {
                RowParams rowParams = new RowParams();
                rowParams.addParam(new Param("groupId", String.valueOf(this.groupId)));
                this.outputData.getBussinessParams().addRowParams(rowParams);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Exception in calling sendVerify method:", (Throwable)e);
        }
    }

    private int getProtectionGroupID() {
        int protectionGroupID = 1;
        ArrayList<Integer> usedGroupIdList = new ArrayList<Integer>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_OPS_GET_ODUSP_PROTPARA");
        Input input = operation.getInput();
        input.setPartValue("groupId", "0");
        this.operationList = new ArrayList();
        this.operationList.add(operation);
        int result = this.sendMessage(this.neid);
        if (0 == result) {
            operation = (Operation)this.operationList.get(0);
            int m = operation.getOutputCount();
            for (int i = 0; i < m; ++i) {
                Output output = operation.getOutput(i);
                if (!output.getFault(0).getCode().equals("0")) continue;
                Integer groupId = Integer.valueOf(output.getPartValue("groupId"));
                usedGroupIdList.add(groupId);
            }
        }
        if (usedGroupIdList.size() > 0) {
            while (protectionGroupID <= 65535 && usedGroupIdList.contains(new Integer(protectionGroupID))) {
                ++protectionGroupID;
            }
        }
        return protectionGroupID;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            this.res = TEGetFilePath.getResource((int)neid, (String)ODUK_SPRING_RES);
            TELogInfo logDetail = new TELogInfo();
            int userid = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userid = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userid = 0;
                }
            }
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            logDetail.setCmdID(subfunc.getCode());
            logDetail.setLocation(ipAddress);
            logDetail.setUserID(userid);
            logDetail.setUserName(TESysManagerBean.getInstance().getSysUser());
            String operateName = subfunc.getSubFuncDes(neid);
            logDetail.setOperateName(operateName);
            logDetail.setOperateObject(operObj);
            StringBuffer sb = new StringBuffer();
            sb.append(this.res.getString("protection_group_id")).append(this.groupId).append(",");
            RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
            int level = Integer.parseInt(rowParams.getParam("protectionType").getValue());
            sb.append(this.res.getString("protection_group_level")).append(TEODUkSPRingUtil.getProtectionType(level, this.res)).append(",");
            int rowCount = inputData.getBussinessParams().getRowParamsCount();
            for (int i = 1; i < rowCount; ++i) {
                rowParams = inputData.getBussinessParams().getRowParams(i);
                String pathMapped = rowParams.getParam("pathMapped").getValue();
                int proUnit = Integer.parseInt(rowParams.getParam("protectionUnit").getValue());
                String unit = "";
                switch (proUnit) {
                    case 1: {
                        unit = this.res.getString("west_work_unit");
                        break;
                    }
                    case 2: {
                        unit = this.res.getString("west_protection_unit");
                        break;
                    }
                    case 3: {
                        unit = this.res.getString("east_work_unit");
                        break;
                    }
                    case 4: {
                        unit = this.res.getString("east_protection_unit");
                        break;
                    }
                }
                sb.append(unit).append(pathMapped).append(",");
            }
            logDetail.setOperateDesc(sb.substring(0, sb.length() - 1));
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (0 == errorCode) {
                logDetail.setResult(0);
                logDetail.setErrCode(0);
                logDetail.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            } else {
                logDetail.setResult(2);
                if (1 == errorCode || 2 == errorCode) {
                    rowParams = outputData.getBussinessParams().getRowParams(0);
                    int errorCount = rowParams.getRowErrorsCount();
                    for (int j = 0; j < errorCount; ++j) {
                        RowErrors rowErrors = rowParams.getRowErrors(j);
                        logDetail.setErrCode(Integer.parseInt(rowErrors.getErrorMessage().getErrorcode()));
                        logDetail.setErrInfo(rowErrors.getErrorMessage().getErrorinfo());
                    }
                } else {
                    logDetail.setResult(2);
                    logDetail.setErrCode(errorCode);
                    logDetail.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                }
            }
            TELogMgr.writeLog((TELogInfo)logDetail);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }
}

