/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.neattribute;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;

public class TENEAttribute
extends TECommonWriteLogBean {
    private static final String GNG_TYPE_PARAM = "gnetype";
    private static final String GNG_ADDRESS_PARAM = "gneAddress";
    private static final String GNG_PORT_PARAM = "gnePort";
    private static final String BAUD_RATE_PARAM = "baudRate";

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList operationList = new ArrayList();
        try {
            operationList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENEAttribute.getOperation fail!", (Throwable)e);
            return null;
        }
        if (TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_CFG_NE_ATTRIBUTE", "OTN_ATTR_SUPPORT_DPSDETACHSWITCH")) {
            Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_DPSDETACHSWITCH_EN");
            operationList.add(operation);
        }
        return operationList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        BussinessParams bussinessParams;
        RowParams rowparams;
        RowErrors rowErrors;
        TENEListMgr.getInstance().getNE(neid).queryNEAttribute();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        Operation operation = new Operation();
        operation.setInput(new Input());
        Output output = new Output();
        Part part = new Part();
        Fault fault = new Fault();
        fault.setCode("0");
        part.setName(GNG_ADDRESS_PARAM);
        part.setValue(neObj.getNEGWAddress());
        output.addPart(part);
        operation.addOutput(output);
        output.addFault(fault);
        operationList.add(operation);
        operation = new Operation();
        operation.setInput(new Input());
        output = new Output();
        part = new Part();
        part.setName(GNG_TYPE_PARAM);
        part.setValue(String.valueOf(neObj.getNEGWType()));
        output.addPart(part);
        output.addFault(fault);
        operation.addOutput(output);
        operationList.add(operation);
        operation = new Operation();
        operation.setInput(new Input());
        output = new Output();
        part = new Part();
        part.setName(GNG_PORT_PARAM);
        part.setValue(neObj.getPort());
        output.addPart(part);
        operation.addOutput(output);
        output.addFault(fault);
        operationList.add(operation);
        operation = new Operation();
        operation.setInput(new Input());
        output = new Output();
        part = new Part();
        part.setName(BAUD_RATE_PARAM);
        part.setValue(neObj.getBaudRate());
        output.addPart(part);
        operation.addOutput(output);
        output.addFault(fault);
        operationList.add(operation);
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)this.getFilterErrorCodeList());
        this.handleDpsSwitchStatus(operationList, this.outputData);
        if (!this.outputData.getErrorMessage().getErrorcode().equals("0") && (rowErrors = (rowparams = (bussinessParams = this.outputData.getBussinessParams()).getRowParams(1)).getRowErrors(0)).getErrorMessage().getErrorcode().equals(String.valueOf(37926))) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)37926));
            for (int i = rowparams.getRowErrorsCount() - 1; i >= 0; --i) {
                rowparams.removeRowErrors(rowparams.getRowErrors(i));
            }
        }
        this.removeInvalidXMLCharForNeName();
    }

    private void handleDpsSwitchStatus(ArrayList operationList, Datainterface outputData) {
        Operation oper;
        if (TESpecialAttrMgr.getInstance().isNESupport(this.neid, "TE_FUNC_CFG_NE_ATTRIBUTE", "OTN_ATTR_SUPPORT_DPSDETACHSWITCH") && operationList.size() > 0 && (oper = (Operation)operationList.get(0)).getOutputCount() > 0 && null != oper.getOutput(0).getPart("dpsSwitchStatus")) {
            outputData.getBussinessParams().getRowParams(0).addParam("dpsSwitchStatus", oper.getOutput(0).getPart("dpsSwitchStatus").getValue());
        }
    }

    private void removeInvalidXMLCharForNeName() {
        for (int i = 0; i < this.outputData.getBussinessParams().getRowParamsCount(); ++i) {
            RowParams rowParams = this.outputData.getBussinessParams().getRowParams(i);
            Param neNameParam = rowParams.getParam("neName");
            if (neNameParam.getValue() != null && !neNameParam.getValue().equals("")) {
                neNameParam.setValue(TEStringUtils.removeInvalidXMLChar((String)neNameParam.getValue()));
            } else {
                TENE ne = TENEListMgr.getInstance().getNE(this.neid);
                neNameParam.setValue(ne.getNEName());
            }
            Param deviceTypeParam = rowParams.getParam("deviceType");
            if (deviceTypeParam == null || deviceTypeParam.getValue() == null || deviceTypeParam.getValue().equals("")) continue;
            int devType = TEGetNEDomainVersion.getInstance().getDevType(Integer.parseInt(deviceTypeParam.getValue()));
            String typeName = TEEquipmentDescription.getInstance().getTypeName(devType);
            if (typeName == null || typeName.equals("")) continue;
            rowParams.addParam(new Param("deviceTypeName", typeName));
        }
    }

    protected boolean isSingletonLog() {
        return true;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errList = new ArrayList<Integer>();
        errList.add(37898);
        errList.add(38737);
        return errList;
    }

    public String getSinleDetailInfo(RowParams[] rParamsArr) {
        StringBuffer strBuf = new StringBuffer();
        StringBuffer filePath = new StringBuffer();
        int logicNeId = TEConfigurationDataMgr.getInstance().getNEID(this.neid);
        String neidShow = (logicNeId - logicNeId % 65536) / 65536 + "-" + logicNeId % 65536;
        filePath.append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("neattribute").append(File.separator).append("neattrres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        strBuf.append(res.getString("NEID")).append(":").append(neidShow).append(";");
        RowParams rowparm = this.outputData.getBussinessParams().getRowParams(0);
        StringBuffer devtpFilePath = new StringBuffer();
        devtpFilePath.append(TEPathManager.RESOURCE_PROFILE_PATH).append(File.separator).append("devicetype.ini");
        TEResourceUtil devptRes = TEResourceUtil.getInstance((String)devtpFilePath.toString());
        String devicetype = devptRes.getString(rowparm.getParam("deviceType").getValue());
        strBuf.append(res.getString("deviceType")).append(":").append(devicetype).append(";");
        strBuf.append(res.getString("baseid")).append(":").append(logicNeId % 65536).append(";");
        strBuf.append(res.getString("eid")).append(":").append((logicNeId - logicNeId % 65536) / 65536).append(";");
        strBuf.append(res.getString("neName")).append(":");
        if (!rowparm.getParam("neName").getValue().trim().equals("")) {
            strBuf.append(rowparm.getParam("neName").getValue().trim()).append(";");
        } else {
            strBuf.append("NE(").append(logicNeId / 65536).append("-").append(logicNeId % 65536).append(");");
        }
        strBuf.append(res.getString("neMeno")).append(":");
        if (!rowparm.getParam("neMeno").getValue().trim().equals("")) {
            strBuf.append(rowparm.getParam("neMeno").getValue().trim()).append(";");
        } else {
            strBuf.append("-").append(";");
        }
        strBuf.append(res.getString("shelfType")).append(":");
        StringBuffer shelfTypeStr = new StringBuffer();
        shelfTypeStr.append("shelftype[").append(rowparm.getParam("shelfType").getValue()).append("]");
        strBuf.append(res.getString(shelfTypeStr.toString())).append(";");
        strBuf.append(res.getString(GNG_TYPE_PARAM)).append(":");
        String gnetypeStr = "-";
        switch (Integer.parseInt(rowparm.getParam(GNG_TYPE_PARAM).getValue())) {
            case 1: {
                gnetypeStr = res.getString("ipGate");
                break;
            }
            case 2: {
                gnetypeStr = res.getString("isoGate");
                break;
            }
            case 3: {
                gnetypeStr = res.getString("serialGate");
                break;
            }
            default: {
                gnetypeStr = "-";
            }
        }
        strBuf.append(gnetypeStr).append(";");
        strBuf.append(res.getString(GNG_ADDRESS_PARAM)).append(":").append(rowparm.getParam(GNG_ADDRESS_PARAM).getValue()).append(";");
        strBuf.append(res.getString(GNG_PORT_PARAM)).append(":").append(rowparm.getParam(GNG_PORT_PARAM).getValue());
        if (null != rowparm.getParam("dpsSwitchStatus")) {
            strBuf.append(";").append(res.getString("dpsSwitchStatus")).append(":").append(res.getString("dpsSwitch_" + rowparm.getParam("dpsSwitchStatus").getValue()));
        }
        return strBuf.toString();
    }
}

