/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.ipa;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ngwdm.ipa.TEIPADelBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class TEIPASetBean
extends TEIPADelBean {
    private TEResourceUtil res = null;
    private static final String IPADISABLE_STATUS = "0";

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            Map rtnMap = this.handleRamanLaserStatus(inputData);
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            ArrayList ipaEnableOpers = this.handleOperation(this.operationList, rtnMap);
            if (null == this.operationList || this.operationList.isEmpty()) {
                this.handleMessage(neid, ipaEnableOpers, subFunc);
            } else {
                int result = this.sendMessage(neid);
                if (result == 0) {
                    this.operationList.addAll(ipaEnableOpers);
                    this.handleMessage(neid, this.operationList, subFunc);
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                }
            }
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals(IPADISABLE_STATUS)) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    @Override
    protected ArrayList handleOperation(ArrayList operationList, Map<String, String> rtnMap) {
        ArrayList<Operation> ipaEnableOpers = new ArrayList<Operation>();
        Iterator iter = operationList.iterator();
        while (iter.hasNext()) {
            Operation operTemp = (Operation)iter.next();
            String ipaID = operTemp.getInput().getPartValue("ipaID");
            if (rtnMap.get(ipaID) == null || !operTemp.getName().equals("NSCMD_APR_SET_CTRLPARA")) continue;
            operTemp.getOutput(0).getFault(0).setCode(String.valueOf(1090593017));
            ipaEnableOpers.add(operTemp);
            iter.remove();
        }
        return ipaEnableOpers;
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        this.operationList = super.getOperation(neid, subFunc, inputData, memeryData);
        Operation operation = null;
        int len = this.operationList.size();
        for (int i = 0; i < len; ++i) {
            operation = (Operation)this.operationList.get(i);
            if (!operation.getName().equals("NSCMD_CFG_SET_RAMAN_ALM_TH")) continue;
            int slotid = Integer.parseInt(operation.getInput().getPartValue("ramonSlotid"));
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            if (boardType != 2318 && boardType != 2335 && !TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_CFG_APSD", "OTN_ATTR_SUPPORT_RMAN_ALMTH")) continue;
            operation.getInput().getPart("reptype").setValue("148");
        }
        return this.operationList;
    }

    @Override
    protected boolean isNeedQueryLaserStatus(RowParams rowParams) {
        return rowParams.getParam("ramonSlotid") != null && rowParams.getParam("ipaEnable") != null && rowParams.getParam("ipaEnable").getValue().equals(IPADISABLE_STATUS);
    }

    @Override
    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        final Datainterface selfInputDataTmp = inputData;
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEIPASetBean.this.ipaToString(selfInputDataTmp);
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String ipaToString(Datainterface inputData) {
        StringBuffer filePathTmp = new StringBuffer(30);
        filePathTmp.append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("ipa").append(File.separator).append("ipamgrres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePathTmp);
        StringBuffer strBuf = new StringBuffer();
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        String pgid = Datainterface.getParam((Param[])params, (String)"ipaID").getValue();
        int ramonSlotid = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"ramonSlotid").getValue());
        String ramanLosTH = "-";
        String ramanAlarmTH = "-";
        String ramanAlarmEnable = "-";
        strBuf.append(this.res.getString("PGID_RES")).append(":").append(pgid).append(",");
        strBuf.append(this.res.getString("ID_Enable_Flag")).append(":");
        if (Datainterface.getParam((Param[])params, (String)"ipaEnable").getValue().equals(IPADISABLE_STATUS)) {
            strBuf.append(this.res.getString("ID_Disable")).append(",");
        } else {
            strBuf.append(this.res.getString("ID_Enable")).append(",");
        }
        strBuf.append(this.res.getString("ID_Restart_Mode")).append(":");
        if (Datainterface.getParam((Param[])params, (String)"reBootType").getValue().equals(IPADISABLE_STATUS)) {
            strBuf.append(this.res.getString("ID_Auto")).append(",");
        } else {
            strBuf.append(this.res.getString("ID_Manual")).append(",");
        }
        strBuf.append(this.res.getString("ID_Off_Period")).append(":").append(Datainterface.getParam((Param[])params, (String)"offTimes").getValue()).append(",");
        strBuf.append(this.res.getString("ID_On_Period")).append(":").append(Datainterface.getParam((Param[])params, (String)"onTimes").getValue()).append(",");
        strBuf.append(this.res.getString("ID_Testing_Period")).append(":").append(Datainterface.getParam((Param[])params, (String)"testTimes").getValue()).append(",");
        strBuf.append(this.res.getString("ID_Security_Switch")).append(":");
        if (Datainterface.getParam((Param[])params, (String)"securityEnable").getValue().equals(IPADISABLE_STATUS)) {
            strBuf.append(this.res.getString("ID_Close")).append(",");
        } else {
            strBuf.append(this.res.getString("ID_Open")).append(",");
        }
        strBuf.append(this.res.getString("ID_Restart_Switch")).append(":");
        if (Datainterface.getParam((Param[])params, (String)"reBootEnable").getValue().equals(IPADISABLE_STATUS)) {
            strBuf.append(this.res.getString("ID_Close")).append(",");
        } else {
            strBuf.append(this.res.getString("ID_Open")).append(",");
        }
        if (ramonSlotid != 0) {
            ramanLosTH = "" + (float)Integer.parseInt(Datainterface.getParam((Param[])params, (String)"ramanLosTH").getValue()) / 10.0f;
            ramanAlarmTH = "" + (float)Integer.parseInt(Datainterface.getParam((Param[])params, (String)"ramanAlarmTH").getValue()) / 10.0f;
            ramanAlarmEnable = this.res.getString("ALARM_ENABLE" + Datainterface.getParam((Param[])params, (String)"ramanAlarmEnable").getValue());
        }
        strBuf.append(this.res.getString("ID_Raman_LOS_TH")).append(":");
        strBuf.append(ramanLosTH).append(",");
        strBuf.append(this.res.getString("ID_Raman_Alarm_TH")).append(":");
        strBuf.append(ramanAlarmTH).append(",");
        strBuf.append(this.res.getString("ID_Raman_Alarm_Enable")).append(":");
        strBuf.append(ramanAlarmEnable);
        return strBuf.toString();
    }
}

