/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.ipa;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ngwdm.ipa.TEIPAOperationBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TEIPADelBean
extends TEIPAOperationBean {
    private static final int IPA_NOT_EXIST = 39386;
    private static final String LASERSTATUS_OPEN = "1";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            Map rtnMap = this.handleRamanLaserStatus(inputData);
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            ArrayList laserCfgOpers = this.handleOperation(this.operationList, rtnMap);
            if (null == this.operationList || this.operationList.isEmpty()) {
                this.handleMessage(neid, laserCfgOpers, subFunc);
            } else {
                int result = this.sendMessage(neid);
                if (result == 0) {
                    this.operationList.addAll(laserCfgOpers);
                    this.handleMessage(neid, this.operationList, subFunc);
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                }
            }
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    protected ArrayList handleOperation(ArrayList operationList, Map<String, String> rtnMap) {
        ArrayList<Operation> laserCfgOpers = new ArrayList<Operation>();
        Iterator iter = operationList.iterator();
        while (iter.hasNext()) {
            Operation operTemp = (Operation)iter.next();
            String ipaID = operTemp.getInput().getPartValue("ipaID");
            if (rtnMap.get(ipaID) == null) continue;
            operTemp.getOutput(0).getFault(0).setCode(String.valueOf(1090593017));
            laserCfgOpers.add(operTemp);
            iter.remove();
        }
        return laserCfgOpers;
    }

    protected Map handleRamanLaserStatus(Datainterface inputData) {
        ArrayList<Operation> laserOperationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_LASER_STATUS");
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        HashMap<String, String> ipaIDMap = new HashMap<String, String>();
        int len = rowParams.length;
        for (int i = 0; i < len; ++i) {
            if (!this.isNeedQueryLaserStatus(rowParams[i])) continue;
            Operation operClone = (Operation)oper.clone();
            String ramonSlotid = rowParams[i].getParam("ramonSlotid").getValue();
            String ipaID = rowParams[i].getParam("ipaID").getValue();
            ipaIDMap.put(ramonSlotid, ipaID);
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, Integer.parseInt(ramonSlotid));
            operClone.getInput().getPart("slotid").setValue(ramonSlotid);
            if (boardType == 2318 || boardType == 2335) {
                operClone.getInput().getPart("port").setValue("9");
                operClone.getInput().getPart("path").setValue(LASERSTATUS_OPEN);
                laserOperationList.add(operClone);
                continue;
            }
            operClone.getInput().getPart("port").setValue(LASERSTATUS_OPEN);
            operClone.getInput().getPart("path").setValue(LASERSTATUS_OPEN);
            laserOperationList.add(operClone);
            operClone = (Operation)operClone.clone();
            operClone.getInput().getPart("path").setValue("2");
            laserOperationList.add(operClone);
        }
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        if (laserOperationList.size() > 0) {
            TENECommMgr.getInstance().sendCommand(this.neid, laserOperationList, this.TIME_OUT);
            Operation tmpOper = null;
            int len2 = laserOperationList.size();
            for (int i = 0; i < len2; ++i) {
                tmpOper = (Operation)laserOperationList.get(i);
                if (tmpOper.getOutputCount() <= 0 || Integer.parseInt(tmpOper.getOutput(0).getFault(0).getCode()) != 0 || !tmpOper.getOutput(0).getPartValue("W32PORT_ATTR_LSTATE").equals(LASERSTATUS_OPEN)) continue;
                String ipaID = (String)ipaIDMap.get(tmpOper.getInput().getPartValue("slotid"));
                rtnMap.put(ipaID, LASERSTATUS_OPEN);
            }
        }
        return rtnMap;
    }

    protected boolean isNeedQueryLaserStatus(RowParams rowParams) {
        return rowParams.getParam("ramonSlotid") != null;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(new Integer(39386));
        return errorCodeList;
    }
}

