/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.ipa;

import com.huawei.nglct.bscfg.installcp.TECPUtil;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEIPAAvailabeResQueryBean
implements TENEMgrInterface {
    private static final String W32PORT_ATTR_IPA_ALM = "W32PORT_ATTR_IPA_ALM";
    private static final String W32PORT_ATTR_IPA_CTRL = "W32PORT_ATTR_IPA_CTRL";
    private static final String W32PORT_ATTR_IPA_RAMAN = "W32PORT_ATTR_IPA_RAMAN";
    private int neid;
    private Datainterface output;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = new Datainterface();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        try {
            if (null != neObj) {
                this.getAvaliableIPABoard();
            } else {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            }
        }
        catch (Exception e) {
            this.log.error("Get Avaliable IPA Board Fail!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    private void getAvaliableIPABoard() {
        this.output.setBussinessParams(new BussinessParams());
        List almBoardList = TECPUtil.getAttrSupportCPs((int)this.neid, (String)W32PORT_ATTR_IPA_ALM);
        this.convertToDatainterface(this.neid, W32PORT_ATTR_IPA_ALM, almBoardList, "alarm");
        List ctrlBoardList = TECPUtil.getAttrSupportCPs((int)this.neid, (String)W32PORT_ATTR_IPA_CTRL);
        this.convertToDatainterface(this.neid, W32PORT_ATTR_IPA_CTRL, ctrlBoardList, "control");
        int ramanNeId = this.neid;
        List ramanBoardList = TECPUtil.getAttrSupportCPs((int)ramanNeId, (String)W32PORT_ATTR_IPA_RAMAN);
        this.convertToDatainterface(ramanNeId, W32PORT_ATTR_IPA_RAMAN, ramanBoardList, "ramon");
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    private void convertToDatainterface(int neid, String attrId, List boardList, String type) {
        if (null == boardList) {
            return;
        }
        String nename = TENEListMgr.getInstance().getNE(neid).getNEName();
        TEBoard board = null;
        RowParams rowparams = null;
        RowParams newrowparams = null;
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            rowparams = new RowParams();
            board = (TEBoard)boardList.get(i);
            rowparams.addParam("type", type);
            rowparams.addParam("neid", String.valueOf(neid));
            rowparams.addParam("nename", nename);
            rowparams.addParam("shelfname", TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)board.getSlotID()));
            rowparams.addParam("slotid", String.valueOf(board.getSlotID()));
            rowparams.addParam("boardid", String.valueOf(board.getBoardType()));
            rowparams.addParam("boardname", board.getBoardName());
            if (!"ramon".equals(type)) {
                ArrayList portList = TEGenCfgDataMgr.getGenCfgMode((int)board.getBoardType()).getAttrFromId(attrId).getPortList();
                if (null == portList) continue;
                int size = portList.size();
                for (int j = 0; j < size; ++j) {
                    newrowparams = new RowParams();
                    TEGenCfgPortAttribute portObj = (TEGenCfgPortAttribute)portList.get(j);
                    newrowparams.setParam(rowparams.getParam());
                    newrowparams.addParam("port", String.valueOf(portObj.getPort()));
                    newrowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, board.getSlotID(), board.getBoardType(), portObj.getPort()));
                    this.output.getBussinessParams().addRowParams(newrowparams);
                }
                continue;
            }
            this.output.getBussinessParams().addRowParams(rowparams);
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

