/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.ipa;

import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ngwdm.ipa.TEIPASetBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class TEIPAAddSuperBean
extends TEIPASetBean {
    protected static final String NSCMD_APR_SET_ROPPARA = "NSCMD_APR_SET_ROPPARA";
    private TEResourceUtil res = null;
    private boolean blModifyFlag = false;
    private String ipaID = "";

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        Param modifyFlag = inputData.getBussinessParams().getRowParams(0).getParam("modifyFlag");
        this.ipaID = inputData.getBussinessParams().getRowParams(0).getParam("ipaID").getValue();
        if (modifyFlag != null && modifyFlag.getValue().equals("true")) {
            this.blModifyFlag = true;
            return this.performModifyOperation(user, ipAddress);
        }
        return this.performAddOperation(user, ipAddress);
    }

    private Datainterface performAddOperation(String user, String ipAddress) {
        Datainterface data = new Datainterface();
        this.operationList = super.getOperation(this.neid, this.subfunc, this.inputData, this.memeryData);
        Operation operation = null;
        if (null == this.operationList || this.operationList.isEmpty()) {
            data.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return data;
        }
        int len = this.operationList.size();
        for (int i = 0; i < len; ++i) {
            operation = (Operation)this.operationList.get(i);
            if (!operation.getName().equals("NSCMD_CFG_SET_RAMAN_ALM_TH")) continue;
            int slotid = Integer.parseInt(operation.getInput().getPartValue("ramonSlotid"));
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
            if (boardType != 2318 && boardType != 2335) continue;
            operation.getInput().getPart("reptype").setValue("148");
        }
        int result = this.sendMessage(this.neid);
        if (result == 0) {
            data = TEDataConverter.convertToDatainterface((int)this.neid, (SubFunc)this.subfunc, (ArrayList)this.operationList, (ArrayList)this.getFilterErrorCodeList());
        } else {
            data.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        int len2 = data.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len2; ++i) {
            if (data.getBussinessParams().getRowParams(i).getRowErrorsCount() <= 0) continue;
            RowErrors rowErrors = data.getBussinessParams().getRowParams(i).getRowErrors(0);
            rowErrors.addParam(new Param("ipaID", this.ipaID));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(this.neid, this.subfunc, this.inputData, user, ipAddress, data);
        }
        return data;
    }

    private Datainterface performModifyOperation(String user, String ipAddress) {
        this.clearCRPCAndROPBoard();
        Datainterface data = new Datainterface();
        ArrayList list = (ArrayList)this.getModifyOperation();
        if (null == list || list.isEmpty()) {
            data.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return data;
        }
        Map rtnMap = this.handleRamanLaserStatus(this.inputData);
        ArrayList ipaEnableOpers = this.handleOperation(list, rtnMap);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            list.addAll(ipaEnableOpers);
            data = TEDataConverter.convertToDatainterface((int)this.neid, (SubFunc)this.subfunc, (ArrayList)list, (ArrayList)this.getFilterErrorCodeList());
        } else {
            data.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        int len = data.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            if (data.getBussinessParams().getRowParams(i).getRowErrorsCount() <= 0) continue;
            RowErrors rowErrors = data.getBussinessParams().getRowParams(i).getRowErrors(0);
            rowErrors.addParam(new Param("ipaID", this.ipaID));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(this.neid, this.subfunc, this.inputData, user, ipAddress, data);
        }
        return data;
    }

    @Override
    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterList = new ArrayList<Integer>();
        filterList.add(38669);
        filterList.add(38737);
        filterList.add(38674);
        return filterList;
    }

    private List getModifyOperation() {
        String slotid;
        ArrayList<Object> list = new ArrayList<Object>();
        Operation oper = null;
        Param ipaParam = this.inputData.getBussinessParams().getRowParams(0).getParam("ipaID");
        Param ramonSlotid = this.inputData.getBussinessParams().getRowParams(0).getParam("ramonSlotid");
        Param auxRamanParam = this.inputData.getBussinessParams().getRowParams(0).getParam("auxRamanSlotid");
        Param pumpParam = this.inputData.getBussinessParams().getRowParams(0).getParam("pumpSlotid");
        Param ipaEnable = this.inputData.getBussinessParams().getRowParams(0).getParam("ipaEnable");
        Param reBootType = this.inputData.getBussinessParams().getRowParams(0).getParam("reBootType");
        Param offTimes = this.inputData.getBussinessParams().getRowParams(0).getParam("offTimes");
        Param onTimes = this.inputData.getBussinessParams().getRowParams(0).getParam("onTimes");
        Param testTimes = this.inputData.getBussinessParams().getRowParams(0).getParam("testTimes");
        Param reBootEnable = this.inputData.getBussinessParams().getRowParams(0).getParam("reBootEnable");
        Param securityEnable = this.inputData.getBussinessParams().getRowParams(0).getParam("securityEnable");
        Param ramanLosTH = this.inputData.getBussinessParams().getRowParams(0).getParam("ramanLosTH");
        Param ramanAlarmTH = this.inputData.getBussinessParams().getRowParams(0).getParam("ramanAlarmTH");
        Param ramanAlarmEnable = this.inputData.getBussinessParams().getRowParams(0).getParam("ramanAlarmEnable");
        Param delDetectBoard = this.inputData.getBussinessParams().getRowParams(0).getParam("delDetectBoard");
        Param addDetectBoard = this.inputData.getBussinessParams().getRowParams(0).getParam("addDetectBoard");
        if (auxRamanParam != null && !auxRamanParam.getValue().equals("") && null != (oper = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_APR_SET_ROPPARA))) {
            oper.getInput().getPart("ipaID").setValue(ipaParam.getValue());
            oper.getInput().getPart("boardType").setValue("1");
            oper.getInput().getPart("slotid").setValue(auxRamanParam.getValue());
            list.add(oper);
        }
        if (pumpParam != null && !pumpParam.getValue().equals("") && null != (oper = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_APR_SET_ROPPARA))) {
            oper.getInput().getPart("ipaID").setValue(ipaParam.getValue());
            oper.getInput().getPart("boardType").setValue("0");
            oper.getInput().getPart("slotid").setValue(pumpParam.getValue());
            list.add(oper);
        }
        if (ipaEnable != null && !ipaEnable.getValue().equals("")) {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_APR_SET_CTRLPARA");
            oper.getInput().getPart("ipaID").setValue(ipaParam.getValue());
            oper.getInput().getPart("ipaEnable").setValue(ipaEnable.getValue());
            oper.getInput().getPart("reBootType").setValue(reBootType.getValue());
            oper.getInput().getPart("offTimes").setValue(offTimes.getValue());
            oper.getInput().getPart("onTimes").setValue(onTimes.getValue());
            oper.getInput().getPart("testTimes").setValue(testTimes.getValue());
            list.add(oper);
        }
        if (reBootEnable != null && !reBootEnable.getValue().equals("")) {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_APR_SET_PULSESWITCH");
            oper.getInput().getPart("ipaID").setValue(ipaParam.getValue());
            oper.getInput().getPart("reBootEnable").setValue(reBootEnable.getValue());
            list.add(oper);
        }
        if (securityEnable != null && !securityEnable.getValue().equals("")) {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_APR_SET_SAFESWITCH");
            oper.getInput().getPart("ipaID").setValue(ipaParam.getValue());
            oper.getInput().getPart("securityEnable").setValue(securityEnable.getValue());
            list.add(oper);
        }
        if (ramonSlotid != null && !ramonSlotid.getValue().equals("")) {
            if (ramanLosTH != null && !ramanLosTH.getValue().equals("")) {
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_APR_SET_RXLOSTH");
                oper.getInput().getPart("ipaID").setValue(ipaParam.getValue());
                oper.getInput().getPart("ramanLosTH").setValue(ramanLosTH.getValue());
                list.add(oper);
            }
            if (ramanAlarmTH != null && !ramanAlarmTH.getValue().equals("")) {
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_RAMAN_ALM_TH");
                oper.getInput().getPart("ramonSlotid").setValue(ramonSlotid.getValue());
                oper.getInput().getPart("ramanAlarmTH").setValue(ramanAlarmTH.getValue());
                int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, Integer.parseInt(ramonSlotid.getValue()));
                if (boardType == 2318 || boardType == 2335) {
                    oper.getInput().getPart("reptype").setValue(String.valueOf(148));
                }
                list.add(oper);
            }
            if (ramanAlarmEnable != null && !ramanAlarmEnable.getValue().equals("")) {
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_APR_SET_RAMAN_ALMFLAG");
                oper.getInput().getPart("ipaID").setValue(ipaParam.getValue());
                oper.getInput().getPart("ramanAlarmEnable").setValue(ramanAlarmEnable.getValue());
                list.add(oper);
            }
        }
        if (delDetectBoard != null && !delDetectBoard.getValue().equals("")) {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_APR_DEL_MONPARA");
            oper.getInput().setPartValue("ipaID", ipaParam.getValue());
            String[] slotports = delDetectBoard.getValue().split(",");
            slotid = "";
            for (int i = 0; i < slotports.length; ++i) {
                slotid = slotports[i].split("-")[0];
                oper.getInput().setPartValue("slotid", slotid);
                list.add(oper.clone());
            }
        }
        if (addDetectBoard != null && !addDetectBoard.getValue().equals("")) {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_APR_SET_MONPARA");
            oper.getInput().setPartValue("ipaID", ipaParam.getValue());
            String[] slotports = addDetectBoard.getValue().split(",");
            slotid = "";
            String portid = "";
            for (int i = 0; i < slotports.length; ++i) {
                String[] temp = slotports[i].split("-");
                slotid = temp[0];
                portid = temp[2].substring(0, temp[2].indexOf("("));
                oper.getInput().setPartValue("slotid", slotid);
                oper.getInput().setPartValue("port", portid);
                list.add(oper.clone());
            }
        }
        return list;
    }

    @Override
    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        final Datainterface selfInputData = inputData;
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEIPAAddSuperBean.this.ipaToString(selfInputData);
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String ipaToString(Datainterface inputData) {
        StringBuffer filePath = new StringBuffer(30);
        filePath.append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("ipa").append(File.separator).append("ipamgrres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        StringBuffer strBuf = new StringBuffer(30);
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        String pgid = Datainterface.getParam((Param[])params, (String)"ipaID").getValue();
        strBuf.append(this.res.getString("PGID_RES")).append(':').append(pgid).append(',');
        String ramanLosTH = "-";
        String ramanAlarmTH = "-";
        String ramanAlarmEnable = "-";
        String subrackname = "";
        int boardtype = 0;
        if (this.blModifyFlag) {
            if (null != Datainterface.getParam((Param[])params, (String)"ramonSlotid") && !"".equals(Datainterface.getParam((Param[])params, (String)"ramonSlotid").getValue())) {
                ramanAlarmEnable = this.res.getString("ALARM_ENABLE" + Datainterface.getParam((Param[])params, (String)"ramanAlarmEnable").getValue());
            }
            if (null != Datainterface.getParam((Param[])params, (String)"ramanLosTH")) {
                ramanLosTH = Datainterface.getParam((Param[])params, (String)"ramanLosTH").getValue();
            }
            if (null != Datainterface.getParam((Param[])params, (String)"ramanAlarmTH")) {
                ramanAlarmTH = Datainterface.getParam((Param[])params, (String)"ramanAlarmTH").getValue();
            }
        } else {
            int alarmSlotid = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"alarmSlotid").getValue());
            int alarmPort = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"alarmPort").getValue());
            int ctlSlotid = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"ctlSlotid").getValue());
            int ctlPort = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"ctlPort").getValue());
            int ramonNeid = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"ramonNeid").getValue());
            int ramonSlotid = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"ramonSlotid").getValue());
            String ramonBoard = "";
            String alarmBoard = this.getAlarmBoard(alarmSlotid, alarmPort);
            String ctlBoard = this.getCtlBoard(ctlSlotid, ctlPort);
            if (ramonNeid == 0) {
                ramonBoard = this.res.getString("BLANK_RES");
            } else {
                boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, ramonSlotid);
                subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)ramonSlotid);
                if (!"".equals(subrackname)) {
                    ramonBoard = subrackname + "-";
                }
                ramonBoard = ramonBoard + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)ramonSlotid) + "-" + TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
                if (null != Datainterface.getParam((Param[])params, (String)"ramanLosTH")) {
                    ramanLosTH = Datainterface.getParam((Param[])params, (String)"ramanLosTH").getValue();
                }
                if (null != Datainterface.getParam((Param[])params, (String)"ramanAlarmTH")) {
                    ramanAlarmTH = Datainterface.getParam((Param[])params, (String)"ramanAlarmTH").getValue();
                }
                if (null != Datainterface.getParam((Param[])params, (String)"ramanAlarmEnable")) {
                    ramanAlarmEnable = this.res.getString("ALARM_ENABLE" + Datainterface.getParam((Param[])params, (String)"ramanAlarmEnable").getValue());
                }
            }
            strBuf.append(this.res.getString("BAND_RES")).append(":CBand,");
            strBuf.append(this.res.getString("ALARM_BOARD_RES")).append(':').append(alarmBoard).append(',');
            strBuf.append(this.res.getString("CHECK_BOARD_RES")).append(':').append(ctlBoard).append(',');
            strBuf.append(this.res.getString("RAMAN_BOARD_RES")).append(':').append(ramonBoard).append(',');
        }
        this.processAuxRamanSlotid(strBuf, params);
        this.processPumpSlotidLog(strBuf, params);
        this.processIPAParamLog(strBuf, params, ramanLosTH, ramanAlarmTH, ramanAlarmEnable);
        if (null != Datainterface.getParam((Param[])params, (String)"addDetectBoardStr") && !"".equals(Datainterface.getParam((Param[])params, (String)"addDetectBoardStr").getValue())) {
            strBuf.append(" ").append(this.res.getString("ID_ADD_FUZHUJIANCEBAN")).append(":").append(Datainterface.getParam((Param[])params, (String)"addDetectBoardStr").getValue());
        }
        if (null != Datainterface.getParam((Param[])params, (String)"delDetectBoardStr") && !"".equals(Datainterface.getParam((Param[])params, (String)"delDetectBoardStr").getValue())) {
            strBuf.append(" ").append(this.res.getString("ID_DEL_FUZHUJIANCEBAN")).append(":").append(Datainterface.getParam((Param[])params, (String)"delDetectBoardStr").getValue());
        }
        return strBuf.toString();
    }

    private String getCtlBoard(int ctlSlotid, int ctlPort) {
        String ctlBoard = "";
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, ctlSlotid);
        String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)ctlSlotid);
        if (!"".equals(subrackname)) {
            ctlBoard = subrackname + "-";
        }
        ctlBoard = ctlBoard + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)ctlSlotid) + "-" + TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype) + "-" + TEConfigurationDataMgr.getInstance().getPortName(this.neid, ctlSlotid, boardtype, ctlPort);
        return ctlBoard;
    }

    private String getAlarmBoard(int alarmSlotid, int alarmPort) {
        String alarmBoard = "";
        alarmBoard = alarmSlotid == 0 ? this.res.getString("BLANK_RES") : this.getCtlBoard(alarmSlotid, alarmPort);
        return alarmBoard;
    }

    private void processIPAParamLog(StringBuffer strBuf, Param[] params, String ramanLosTH, String ramanAlarmTH, String ramanAlarmEnable) {
        strBuf.append(this.res.getString("ID_Enable_Flag")).append(':');
        if (Datainterface.getParam((Param[])params, (String)"ipaEnable").getValue().equals("0")) {
            strBuf.append(this.res.getString("ID_Disable")).append(',');
        } else {
            strBuf.append(this.res.getString("ID_Enable")).append(',');
        }
        strBuf.append(this.res.getString("ID_Restart_Mode")).append(':');
        if (Datainterface.getParam((Param[])params, (String)"reBootType").getValue().equals("0")) {
            strBuf.append(this.res.getString("ID_Auto")).append(',');
        } else {
            strBuf.append(this.res.getString("ID_Manual")).append(',');
        }
        strBuf.append(this.res.getString("ID_Off_Period")).append(':').append(Datainterface.getParam((Param[])params, (String)"offTimes").getValue()).append(',');
        strBuf.append(this.res.getString("ID_On_Period")).append(':').append(Datainterface.getParam((Param[])params, (String)"onTimes").getValue()).append(',');
        strBuf.append(this.res.getString("ID_Testing_Period")).append(':').append(Datainterface.getParam((Param[])params, (String)"testTimes").getValue()).append(',');
        strBuf.append(this.res.getString("ID_Security_Switch")).append(':');
        if (Datainterface.getParam((Param[])params, (String)"securityEnable").getValue().equals("0")) {
            strBuf.append(this.res.getString("ID_Close")).append(',');
        } else {
            strBuf.append(this.res.getString("ID_Open")).append(',');
        }
        strBuf.append(this.res.getString("ID_Restart_Switch")).append(':');
        if (Datainterface.getParam((Param[])params, (String)"reBootEnable").getValue().equals("0")) {
            strBuf.append(this.res.getString("ID_Close")).append(',');
        } else {
            strBuf.append(this.res.getString("ID_Open")).append(',');
        }
        strBuf.append(this.res.getString("ID_Raman_LOS_TH")).append(':');
        if (!"".equals(ramanLosTH) && !"-".equals(ramanLosTH)) {
            strBuf.append((float)Integer.parseInt(ramanLosTH) / 10.0f).append(',');
        } else {
            strBuf.append(ramanLosTH).append(',');
        }
        strBuf.append(this.res.getString("ID_Raman_Alarm_TH")).append(':');
        if (!"".equals(ramanAlarmTH) && !"-".equals(ramanAlarmTH)) {
            strBuf.append((float)Integer.parseInt(ramanAlarmTH) / 10.0f).append(',');
        } else {
            strBuf.append(ramanAlarmTH).append(',');
        }
        strBuf.append(this.res.getString("ID_Raman_Alarm_Enable")).append(':');
        strBuf.append(ramanAlarmEnable);
    }

    private void processAuxRamanSlotid(StringBuffer strBuf, Param[] params) {
        if (null != Datainterface.getParam((Param[])params, (String)"auxRamanSlotid") && !"".equals(Datainterface.getParam((Param[])params, (String)"auxRamanSlotid").getValue())) {
            int auxRamanSlotid = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"auxRamanSlotid").getValue());
            int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, auxRamanSlotid);
            String auxRamanBoard = "";
            String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)auxRamanSlotid);
            if (!"".equals(subrackname)) {
                auxRamanBoard = subrackname + "-";
            }
            auxRamanBoard = auxRamanSlotid == 0 ? this.res.getString("BLANK_RES") : auxRamanBoard + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)auxRamanSlotid) + "-" + TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
            strBuf.append(this.res.getString("AUX_RAMAN_BOARD")).append(':').append(auxRamanBoard).append(',');
        }
    }

    private void processPumpSlotidLog(StringBuffer strBuf, Param[] params) {
        if (null != Datainterface.getParam((Param[])params, (String)"pumpSlotid") && !"".equals(Datainterface.getParam((Param[])params, (String)"pumpSlotid").getValue())) {
            int pumpSlotid = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"pumpSlotid").getValue());
            int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, pumpSlotid);
            String pumpBoard = "";
            String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)pumpSlotid);
            if (!"".equals(subrackname)) {
                pumpBoard = subrackname + "-";
            }
            pumpBoard = pumpSlotid == 0 ? this.res.getString("BLANK_RES") : TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)pumpSlotid) + "-" + TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
            strBuf.append(this.res.getString("PUMP_BOARD")).append(':').append(pumpBoard).append(',');
        }
    }

    protected abstract boolean clearCRPCAndROPBoard();
}

