/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.ipa;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TESDCircuitPackRecord;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.ngwdm.ipa.TEIPAOperationBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.Vector;
import org.slf4j.Logger;

public class TEAssistantCheckBoardQueryBean
extends TEIPAOperationBean {
    private static final String W32PORT_ATTR_STDOUTPOW = "W32PORT_ATTR_STDOUTPOW";
    private int neid;
    private Datainterface output;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = super.performBussinessProcess(neid, subFunc, inputData, null, user, ipAddress);
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        try {
            if (null != neObj) {
                this.getAvaliableIPABoard();
            } else {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            }
        }
        catch (Exception e) {
            this.log.error("Get Avaliable IPA Board Fail!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Operation operation = (Operation)operationList.get(0);
        int errorCode = Integer.parseInt(operation.getOutput(0).getFault(0).getCode());
        if (0 != errorCode) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)errorCode));
            return;
        }
        this.outputData.setBussinessParams(new BussinessParams());
        int slotid = 0;
        int boardid = 0;
        int port = 0;
        TEBoard board = null;
        int size = operation.getOutputCount();
        for (int i = 0; i < size; ++i) {
            slotid = Integer.parseInt(operation.getOutput(i).getPart("slotid").getValue());
            port = Integer.parseInt(operation.getOutput(i).getPart("port").getValue());
            board = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
            boardid = board.getBoardType();
            RowParams rowparams = new RowParams();
            rowparams.addParam("type", "selected");
            rowparams.addParam("neid", String.valueOf(neid));
            rowparams.addParam("nename", TENEListMgr.getInstance().getNE(neid).getNEName());
            rowparams.addParam("shelfname", TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid));
            rowparams.addParam("slotid", slotid + "");
            rowparams.addParam("boardid", boardid + "");
            rowparams.addParam("boardname", board.getBoardName());
            rowparams.addParam("port", port + "");
            rowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardid, port));
            TESDCircuitPackRecord boardTypePro = TEConfigurationDataMgr.getInstance().getBoardTypeProperty(neid, board.getBoardType());
            rowparams.addParam("wdmcptype", String.valueOf(boardTypePro.wdmType));
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
    }

    private void getAvaliableIPABoard() {
        if (null == this.output.getBussinessParams()) {
            this.output.setBussinessParams(new BussinessParams());
        }
        ArrayList almBoardList = this.getAttrSupportCPs(this.neid, W32PORT_ATTR_STDOUTPOW);
        this.convertToDatainterface(this.neid, W32PORT_ATTR_STDOUTPOW, almBoardList, "avaliable");
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    private void convertToDatainterface(int neid, String attrId, ArrayList boardList, String type) {
        if (null == boardList) {
            return;
        }
        String nename = TENEListMgr.getInstance().getNE(neid).getNEName();
        TEBoard board = null;
        RowParams rowparams = null;
        RowParams newrowparams = null;
        ArrayList<String> duplicateLs = new ArrayList<String>();
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            rowparams = new RowParams();
            board = (TEBoard)boardList.get(i);
            rowparams.addParam("type", type);
            rowparams.addParam("neid", String.valueOf(neid));
            rowparams.addParam("nename", nename);
            rowparams.addParam("shelfname", TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)board.getSlotID()));
            rowparams.addParam("slotid", String.valueOf(board.getSlotID()));
            rowparams.addParam("boardid", String.valueOf(board.getBoardType()));
            rowparams.addParam("boardname", board.getBoardName());
            TESDCircuitPackRecord boardTypePro = TEConfigurationDataMgr.getInstance().getBoardTypeProperty(neid, board.getBoardType());
            rowparams.addParam("wdmcptype", String.valueOf(boardTypePro.wdmType));
            ArrayList portList = TEGenCfgDataMgr.getGenCfgMode((int)board.getBoardType()).getAttrFromId(attrId).getPortList();
            if (null == portList) continue;
            int size = portList.size();
            for (int j = 0; j < size; ++j) {
                TEGenCfgPortAttribute portObj = (TEGenCfgPortAttribute)portList.get(j);
                String slotAndPort = board.getSlotID() + "-" + portObj.getPort();
                if (duplicateLs.contains(slotAndPort)) continue;
                newrowparams = new RowParams();
                newrowparams.setParam(rowparams.getParam());
                newrowparams.addParam("port", String.valueOf(portObj.getPort()));
                newrowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, board.getSlotID(), board.getBoardType(), portObj.getPort()));
                this.output.getBussinessParams().addRowParams(newrowparams);
                duplicateLs.add(slotAndPort);
            }
        }
    }

    private ArrayList getAttrSupportCPs(int neid, String attrId) {
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        ArrayList<TEBoard> supportCPs = new ArrayList<TEBoard>();
        if (null == neObj) {
            return null;
        }
        Vector boardList = neObj.getBoardList();
        if (null == boardList) {
            return null;
        }
        TEBoard board = null;
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            board = (TEBoard)boardList.get(i);
            if (null == TEGenCfgDataMgr.getGenCfgMode((int)board.getBoardType()) || null == TEGenCfgDataMgr.getGenCfgMode((int)board.getBoardType()).getAttrFromId(attrId)) continue;
            supportCPs.add(board);
        }
        return supportCPs;
    }
}

