/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.inversemultifexing.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEBoundPathMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEBoundPathDbMgr {
    public static final String UNKNOWN = "UNKNOWN";
    private static final Logger logger = TELogFactory.getNormalLogger();
    public static final String DB_COL_SLOT = "SlotID";
    public static final String DB_COL_PORT = "PortID";
    public static final String DB_COL_SUBCARD = "SubCardID";
    public static final String DB_COL_PATH = "PathID";
    public static final String DB_COL_DIRECTION = "Tsdirection";

    private TEBoundPathDbMgr() {
    }

    public static List<TEBoundPathMOPO> getBoundPathMOFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEBoundPathDbMgr.getBoundPathMOFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TEBoundPathDbMgr.getBoundPathMOFromDB");
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        ArrayList<TEBoundPathMOPO> moList = new ArrayList<TEBoundPathMOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEBoundPathDbMgr.logNullNEError(neID);
                TEBoundPathDbMgr.setOperFail(neID, errRet, 1090596385);
                TEBeanPluginLog.logFuncEnd((String)"TEBoundPathDbMgr.getBoundPathMOFromDB");
                return moList;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEBoundPathMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEBoundPathMOPO.class);
        }
        catch (Exception e) {
            TEBoundPathDbMgr.logExceptionOnGet(neID, e);
            TEBoundPathDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEBoundPathDbMgr.getBoundPathMOFromDB");
            return moList;
        }
        if (null == dbResult) {
            TEBoundPathDbMgr.logNullErrorOnGet(neID);
            TEBoundPathDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEBoundPathDbMgr.getBoundPathMOFromDB");
            return moList;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    moList.add((TEBoundPathMOPO)obj);
                }
            }
        } else {
            TEBoundPathDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TEBoundPathDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEBoundPathDbMgr.getBoundPathMOFromDB");
        return moList;
    }

    public static TEBoundPathMOPO getBoundPathFromDB(int neID, int slotid, int port, int pathid, int direction) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair(DB_COL_SLOT, String.valueOf(slotid));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair(DB_COL_PORT, String.valueOf(port));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair(DB_COL_PATH, String.valueOf(pathid));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair(DB_COL_DIRECTION, String.valueOf(direction));
        criteria.add(aPair);
        TEBoundPathMOPO mopo = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findByID((int[])new int[]{neID}, TEBoundPathMOPO.class, criteria) : TECommonDaoService.findByID_NonLock((int[])new int[]{neID}, TEBoundPathMOPO.class, criteria);
            if (null == dbResult) {
                String tipStr = "Get TEBoundPathMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                logger.error(tipStr);
                return mopo;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEBoundPathMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            logger.error(tipStr, (Throwable)e);
            return mopo;
        }
        if (0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            mopo = (TEBoundPathMOPO)dbResult.getData().get(0);
        }
        return mopo;
    }

    public static void updateBoundPathMOToDB(int neID, TEBoundPathMOPO bPathMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEBoundPathDbMgr.updateTPIDMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEBoundPathDbMgr.updateTPIDMOToDB");
        if (null == bPathMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)bPathMO) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)bPathMO);
        }
        catch (Exception e) {
            TEBoundPathDbMgr.logExceptionErrorOnUpdate(neID, e);
            TEBoundPathDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEBoundPathDbMgr.updateTPIDMOToDB");
            return;
        }
        if (null == dbResult) {
            TEBoundPathDbMgr.logNullErrorOnUpdate(neID);
            TEBoundPathDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEBoundPathDbMgr.updateTPIDMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEBoundPathDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TEBoundPathDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEBoundPathDbMgr.updateTPIDMOToDB");
    }

    public static void delAllBoundPathFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEStgfreqsrcDBMgr.delAllStgfreqsrcFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TEStgfreqsrcDBMgr.delAllStgfreqsrcFromDB");
        List<TEBoundPathMOPO> boundPathList = TEBoundPathDbMgr.getBoundPathMOFromDB(neID, errRet);
        int retCode = errRet.getResult();
        if (0 != retCode) {
            TEBoundPathDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            errRet.setResult(retCode);
        }
        for (TEBoundPathMOPO boundPath : boundPathList) {
            TEBoundPathDbMgr.delBoundPathMOToDB(neID, boundPath, errRet);
        }
        TEBeanPluginLog.logFuncBegin((String)"TEStgfreqsrcDBMgr.delAllStgfreqsrcFromDB");
    }

    public static void createBoundPathMOToDB(int neID, TEBoundPathMOPO bPathMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETPIDDbMgr.createTPIDMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TETPIDDbMgr.createTPIDMOToDB");
        if (null == bPathMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)bPathMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)bPathMO);
        }
        catch (Exception e) {
            TEBoundPathDbMgr.logExceptionErrorOnCreate(neID, e);
            TEBoundPathDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.createTPIDMOToDB");
            return;
        }
        if (null == dbResult) {
            TEBoundPathDbMgr.logNullErrorOnCreate(neID);
            TEBoundPathDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.createTPIDMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEBoundPathDbMgr.logRetCodeErrorOnCreate(neID, retCode);
            TEBoundPathDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.createTPIDMOToDB");
    }

    public static void delBoundPathMOToDB(int neID, TEBoundPathMOPO bPathMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETPIDDbMgr.delTPIDMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TETPIDDbMgr.delTPIDMOToDB");
        if (null == bPathMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)bPathMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)bPathMO);
        }
        catch (Exception e) {
            TEBoundPathDbMgr.logExceptionErrorOnDel(neID, e);
            TEBoundPathDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.delTPIDMOToDB");
            return;
        }
        if (null == dbResult) {
            TEBoundPathDbMgr.logNullErrorOnDel(neID);
            TEBoundPathDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.delTPIDMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEBoundPathDbMgr.logRetCodeErrorOnDel(neID, retCode);
            TEBoundPathDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.delTPIDMOToDB");
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TEBoundPathDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCode).getErrList());
    }

    public static TEErrInfoReturn constructErrInfoReturn(int neID, int errorCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = UNKNOWN;
        if (null != ne) {
            neName = ne.getNEName();
        }
        return TEBoundPathDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, errorCode);
    }

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TEBoundPathDbMgr.getObjName(objName));
        errInfo.setErrorCode(retCode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    public static String getObjName(String[] objName) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objName.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objName[i]);
        }
        return objNameBuffer.toString();
    }

    private static void logNullNEError(int neID) {
        logger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get mo from db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnGet(int neID) {
        logger.error("get mo from db fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionOnGet(int neID, Exception e) {
        logger.error("get mo from db fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnUpdate(int neID, int retCode) {
        String tipStr = String.format("update mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnUpdate(int neID) {
        logger.error("update mo to db device fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionErrorOnUpdate(int neID, Exception e) {
        logger.error("update mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logNullErrorOnCreate(int neID) {
        logger.error("create mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnCreate(int neID, Exception e) {
        logger.error("create mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnCreate(int neID, int retCode) {
        String tipStr = String.format("create mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnDel(int neID) {
        logger.error("delete mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnDel(int neID, Exception e) {
        logger.error("delete mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnDel(int neID, int retCode) {
        String tipStr = String.format("delete mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }
}

