/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.graphexc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.explorer.integrateexplorer.TEInterNEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TEPortModelConfigurationDataMgr;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnIntList;
import com.huawei.nglct.nemgr.f_interface.smtti.AsnDirInfo;
import com.huawei.nglct.nemgr.f_interface.smtti.AsnDirInfoList;
import com.huawei.nglct.nemgr.f_interface.smtti.AsnGetDirInfoReq;
import com.huawei.nglct.nemgr.f_interface.smtti.AsnGetDirInfoRsp;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.AsnGetOTNPortModeReq;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.AsnGetOTNPortModeRsp;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.infconfig.AsnPortWorkMode;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.payload.asnngwdmpayload.AsnGetWDMEXCReq;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.payload.asnngwdmpayload.AsnGetWDMEXCRsp;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.payload.asnngwdmpayload.AsnWDMEXC;
import com.huawei.nglct.nemgr.necommon.workmode.TEWorkModeMgr;
import com.huawei.nglct.nemgr.ngwdm.graphexc.TEGraphExcUtil;
import com.huawei.nglct.nemgr.ngwdm.graphexc.TEGraphexcCache;
import com.huawei.nglct.nemgr.ngwdm.graphexc.TEGraphexcConstants;
import com.huawei.nglct.nemgr.ngwdm.graphexc.bean.TEGraphexcDirectionBean;
import com.huawei.nglct.nemgr.ngwdm.graphexc.bean.TEGraphexcPortBean;
import com.huawei.nglct.nemgr.ngwdm.graphexc.bean.TEGraphexcTsBean;
import com.huawei.nglct.nemgr.ngwdm.graphexc.bean.TENGWDMSingleXCBean;
import com.huawei.nglct.ngwdm_pub.serv.cpadpt.TEOpticalPortModelAdpt;
import com.huawei.nglct.ngwdm_pub.serv.cpadpt.TEPortKey;
import com.huawei.nglct.ngwdm_pub.serv.cpadpt.TETimeSlotModel;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEGraphexcGetResourceBean
extends TEInterNEExplorerBean {
    private Set<TEGraphexcDirectionBean> directionSet = new LinkedHashSet<TEGraphexcDirectionBean>();
    private Map<TEGraphexcPortBean, List<TEGraphexcTsBean>> ttiPortMap = new HashMap<TEGraphexcPortBean, List<TEGraphexcTsBean>>();
    private Datainterface output = new Datainterface();
    private Map<TEPort, Integer> portworkModeMap = new HashMap<TEPort, Integer>();
    private static final Logger logger = TELogFactory.getNormalLogger();
    private int portCount = 0;
    private int shelfID = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.user = user;
        this.ipAddress = ipAddress;
        this.shelfID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("shelfID").getValue());
        BussinessParams bussiness = new BussinessParams();
        this.output.setBussinessParams(bussiness);
        this.getTTIDirectionData();
        this.getLocalDirectionData();
        int result = this.getXC();
        if (result != 0) {
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return this.output;
        }
        if (this.directionSet.size() < 2) {
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090615291));
            return this.output;
        }
        this.produceDirectionData();
        this.produceDirOutData();
        this.producePortOutData();
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return this.output;
    }

    private int getTTIDirectionData() {
        AsnGetDirInfoReq req = new AsnGetDirInfoReq();
        req.missionID = BigInteger.ZERO;
        req.userID = BigInteger.valueOf(Long.parseLong(this.user));
        req.neID = BigInteger.valueOf(this.neid);
        req.shelfID = BigInteger.valueOf(this.shelfID);
        AsnGetDirInfoRsp rsp = new AsnGetDirInfoRsp();
        int result = super.sendCommand(TEASN1CommMgr.WDMCSMGR_SERVER_PROC_ID, (FStruct)req, (FStruct)rsp, 2180093);
        if (result == 0) {
            if (rsp.result.isSuccess) {
                AsnDirInfoList dirInfoList = rsp.dirInfoList;
                for (AsnDirInfo dirInfo : dirInfoList) {
                    TEGraphexcDirectionBean direction = new TEGraphexcDirectionBean(this.directionSet.size(), TEGraphexcConstants.SHAPE_TYPE.direction);
                    direction.setToNEID(dirInfo.toNEID.intValue());
                    if (dirInfo.toONEID != null) {
                        direction.setToONEID(dirInfo.toONEID.intValue());
                    }
                    if (dirInfo.oneName != null) {
                        direction.setOneName(new String(dirInfo.oneName));
                    }
                    TEGraphexcPortBean portBean = new TEGraphexcPortBean();
                    portBean.setId(this.portCount++);
                    portBean.setSlotId(dirInfo.pathInx.slotID.intValue());
                    portBean.setPortId(dirInfo.pathInx.portID.intValue());
                    int relativePortid = TEConfigurationDataMgr.getPortRelativeID((int)portBean.getPortId());
                    TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, portBean.getSlotId());
                    if (board == null) {
                        logger.info("neid:" + this.neid + ",slotid:" + portBean.getSlotId() + "is not found!");
                        continue;
                    }
                    portBean.setBdtype(board.getBoardType());
                    HashMap<Integer, Integer> porttypes = new HashMap<Integer, Integer>();
                    porttypes.put(portBean.getPortId(), TEPortModelConfigurationDataMgr.getInstance().getPortType(this.neid, board.getBoardType(), portBean.getPortId()));
                    List portList = TEQueryPortForDataMgr.getPortListOnInter((int)this.neid, (int)portBean.getSlotId(), (int)board.getBoardType(), porttypes);
                    if (portList.isEmpty()) {
                        logger.info("neid:" + this.neid + ",slotid:" + portBean.getSlotId() + ",portid:" + portBean.getPortId() + "is not in position!");
                        continue;
                    }
                    int tsMode = TEGraphExcUtil.getTimeslotMode(this.neid, portBean.getSlotId(), portBean.getPortId());
                    portBean.setTsMode(tsMode);
                    List tsList = TEOpticalPortModelAdpt.getInstance().getMappedTimeSlotModelList(new TEPortKey(portBean.getBdtype(), relativePortid, -1, tsMode));
                    portBean.getTsList().addAll(tsList);
                    portBean.setLevelList(TEGraphExcUtil.getSupportLevel(board.getBoardType(), portBean.getPortId(), 1));
                    this.ttiPortMap.put(portBean, new ArrayList());
                    if (!this.directionSet.contains(direction)) {
                        direction.addPort(portBean);
                        this.directionSet.add(direction);
                        continue;
                    }
                    for (TEGraphexcDirectionBean exsitDirection : this.directionSet) {
                        if (!exsitDirection.equals(direction)) continue;
                        exsitDirection.addPort(portBean);
                    }
                }
            } else if (rsp.result.retCode != null) {
                result = rsp.result.retCode.intValue();
            }
        }
        return result;
    }

    private void getLocalDirectionData() {
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        Vector boardList = ne.getBoardList();
        if (boardList == null || boardList.size() == 0) {
            return;
        }
        Collections.sort(boardList);
        TEGraphexcDirectionBean local = new TEGraphexcDirectionBean(this.directionSet.size(), TEGraphexcConstants.SHAPE_TYPE.direction);
        local.setOneName("Local");
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int boardType = board.getBoardType();
            if (TEBoardUtil.getSubrackIDFromSlot((int)this.neid, (int)board.getSlotID()) != this.shelfID || !TEGraphExcUtil.isBranchBoard(boardType)) continue;
            if (TEWorkModeMgr.getInstance().isSupportPortMode(boardType, -1)) {
                this.getPortModeFromNM(board.getSlotID());
            }
            List portList = TEOpticalPortModelAdpt.getInstance().getAllPortList(boardType);
            int jSize = portList.size();
            for (int j = 0; j < jSize; ++j) {
                Integer portid = (Integer)portList.get(j);
                TEGraphexcPortBean portBean = new TEGraphexcPortBean();
                portBean.setSlotId(board.getSlotID());
                portBean.setBdtype(board.getBoardType());
                portBean.setPortId(portid);
                if (this.ttiPortMap.containsKey(portBean)) continue;
                portBean.setId(this.portCount++);
                TEPort port = new TEPort(this.neid, board.getSlotID(), -1, portid.intValue());
                List tsList = new ArrayList();
                if (TEWorkModeMgr.getInstance().isSupportPortMode(boardType, -1)) {
                    if (this.portworkModeMap.get(port) != null) {
                        TEPortKey key = new TEPortKey(board.getBoardType(), portid.intValue(), this.portworkModeMap.get(port).intValue(), -1);
                        tsList = TEOpticalPortModelAdpt.getInstance().getMappedTimeSlotModelList(key);
                    }
                } else {
                    tsList = TEOpticalPortModelAdpt.getInstance().getAllTimeSlotModelList(boardType, portid.intValue());
                }
                portBean.getTsList().addAll(tsList);
                if (portBean.getTsList().isEmpty()) continue;
                local.addPort(portBean);
            }
        }
        if (!local.getPortList().isEmpty()) {
            this.directionSet.add(local);
        }
    }

    private int getXC() {
        AsnGetWDMEXCReq req = new AsnGetWDMEXCReq();
        AsnGetWDMEXCRsp rsp = new AsnGetWDMEXCRsp();
        req.userID = BigInteger.valueOf(Long.parseLong(this.user));
        req.missionID = BigInteger.valueOf(0L);
        req.shelfID = BigInteger.valueOf(this.neid);
        req.subrackIDList = new AsnIntList();
        req.subrackIDList.add(this.shelfID);
        int cmdcode = 2105990;
        TESubrack subrack = new TESubrack(this.neid, String.valueOf(req.shelfID.intValue()));
        int result = super.sendCommand(this.neid, (FStruct)req, (FStruct)rsp, cmdcode);
        if (result == 0) {
            TENGWDMSingleXCBean singleXC;
            AsnWDMEXC asnSingleXC;
            int i;
            if (!rsp.result.isSuccess) {
                return rsp.result.getRetCode();
            }
            TEGraphexcCache.getInstance().clearAll();
            int size = rsp.workXCList.size();
            for (i = 0; i < size; ++i) {
                asnSingleXC = (AsnWDMEXC)rsp.workXCList.get(i);
                singleXC = new TENGWDMSingleXCBean(asnSingleXC, this.neid);
                TEGraphexcCache.getInstance().addPortXCMap(2, subrack, singleXC);
            }
            size = rsp.singleXCList.size();
            for (i = 0; i < size; ++i) {
                asnSingleXC = (AsnWDMEXC)rsp.singleXCList.get(i);
                singleXC = new TENGWDMSingleXCBean(asnSingleXC, this.neid);
                TEGraphexcCache.getInstance().addPortXCMap(0, subrack, singleXC);
            }
            size = rsp.protectXCList.size();
            for (i = 0; i < size; ++i) {
                asnSingleXC = (AsnWDMEXC)rsp.protectXCList.get(i);
                singleXC = new TENGWDMSingleXCBean(asnSingleXC, this.neid);
                TEGraphexcCache.getInstance().addPortXCMap(1, subrack, singleXC);
            }
        }
        return result;
    }

    private void produceDirectionData() {
        int directionNum = this.directionSet.size();
        int directionAngle = (360 - 10 * directionNum) / directionNum;
        int startAngle = 0;
        for (TEGraphexcDirectionBean direction : this.directionSet) {
            int endAngle = startAngle + directionAngle;
            direction.setStartAngle(startAngle);
            direction.setEndAngle(endAngle);
            startAngle = endAngle + 10;
        }
    }

    private void produceDirOutData() {
        Iterator<TEGraphexcDirectionBean> itor = this.directionSet.iterator();
        while (itor.hasNext()) {
            RowParams row = new RowParams();
            TEGraphexcDirectionBean directonBean = itor.next();
            row.addParam(new Param("type", String.valueOf(TEGraphexcConstants.SHAPE_TYPE.direction.ordinal())));
            row.addParam(new Param("nodetype", String.valueOf(0)));
            row.addParam(new Param("id", String.valueOf(directonBean.getId())));
            row.addParam(new Param("startAngle", String.valueOf(directonBean.getStartAngle())));
            row.addParam(new Param("endAngle", String.valueOf(directonBean.getEndAngle())));
            if (!directonBean.getOneName().isEmpty()) {
                row.addParam(new Param("name", directonBean.getOneName()));
            } else {
                TENE oppositeNE = TEConfigurationDataMgr.getInstance().getNE(directonBean.getToNEID());
                String nename = "";
                nename = oppositeNE != null ? oppositeNE.getNEName() : TEGraphExcUtil.getNENameFromOtherMgr(directonBean.getToNEID());
                row.addParam(new Param("name", nename));
            }
            this.output.getBussinessParams().addRowParams(row);
        }
    }

    private void producePortOutData() {
        for (TEGraphexcDirectionBean directonBean : this.directionSet) {
            List<TEGraphexcPortBean> portList = directonBean.getPortList();
            Collections.sort(portList);
            for (TEGraphexcPortBean portBean : portList) {
                int path;
                StringBuilder signalSb;
                StringBuilder pathSb;
                StringBuilder tsSb;
                List<TETimeSlotModel> tsList;
                RowParams row = new RowParams();
                String boardName = TEConfigurationDataMgr.getInstance().getBoardName(this.neid, portBean.getSlotId());
                row.addParam(new Param("type", String.valueOf(TEGraphexcConstants.SHAPE_TYPE.port.ordinal())));
                row.addParam(new Param("id", String.valueOf(portBean.getId())));
                row.addParam(new Param("slotId", String.valueOf(portBean.getSlotId())));
                row.addParam(new Param("ss", String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)portBean.getSlotId()))));
                row.addParam(new Param("portId", String.valueOf(TEConfigurationDataMgr.getPortRelativeID((int)portBean.getPortId()))));
                row.addParam(new Param("pID", String.valueOf(directonBean.getId())));
                row.addParam(new Param("bN", boardName));
                row.addParam(new Param("tm", String.valueOf(portBean.getTsMode())));
                if (portBean.getLevelList().isEmpty()) {
                    tsList = portBean.getTsList();
                    tsSb = new StringBuilder();
                    pathSb = new StringBuilder();
                    signalSb = new StringBuilder();
                    for (TETimeSlotModel ts : tsList) {
                        if (ts.getcSignal().indexOf("ODU") < 0 || "NONE".equals(ts.getcUsage())) continue;
                        path = TEOpticalPortModelAdpt.getInstance().getPathByTimeslot(portBean.getBdtype(), portBean.getPortId(), ts);
                        tsSb.append(ts.getcTs());
                        tsSb.append(",");
                        pathSb.append(String.valueOf(path));
                        pathSb.append(",");
                        signalSb.append(ts.getcSignal());
                        signalSb.append(",");
                    }
                    row.addParam(new Param("p", String.valueOf(TEQueryPortForDataMgr.getAbstractPortID((int)this.neid, (int)portBean.getPortId()))));
                    row.addParam(new Param("acc", tsSb.toString()));
                    row.addParam(new Param("ap", pathSb.toString()));
                    row.addParam(new Param("pn", TEConfigurationDataMgr.getInstance().getPortName(this.neid, portBean.getSlotId(), portBean.getPortId())));
                    row.addParam(new Param("sg", signalSb.toString()));
                } else {
                    row.addParam(new Param("ll", portBean.getLevelList()));
                    tsList = portBean.getTsList();
                    tsSb = new StringBuilder();
                    pathSb = new StringBuilder();
                    signalSb = new StringBuilder();
                    for (TETimeSlotModel ts : tsList) {
                        if (ts.getcSignal().indexOf("ODU") < 0) continue;
                        path = TEOpticalPortModelAdpt.getInstance().getLineBoardPathByTimeslot(portBean.getBdtype(), TEConfigurationDataMgr.getPortRelativeID((int)portBean.getPortId()), ts);
                        tsSb.append(ts.getcTs());
                        tsSb.append(",");
                        pathSb.append(String.valueOf(path));
                        pathSb.append(",");
                        signalSb.append(ts.getcSignal());
                        signalSb.append(",");
                    }
                    row.addParam(new Param("p", String.valueOf(portBean.getPortId())));
                    row.addParam(new Param("acc", tsSb.toString()));
                    row.addParam(new Param("ap", pathSb.toString()));
                    row.addParam(new Param("sg", signalSb.toString()));
                }
                this.output.getBussinessParams().addRowParams(row);
            }
        }
    }

    public Datainterface sendAsnMsg() {
        return null;
    }

    public void getPortModeFromNM(int slotID) {
        AsnGetOTNPortModeReq req = new AsnGetOTNPortModeReq();
        req.userID = BigInteger.valueOf(Long.parseLong(this.user));
        req.neID = BigInteger.valueOf(this.neid);
        req.slotID = BigInteger.valueOf(slotID);
        AsnGetOTNPortModeRsp rsp = new AsnGetOTNPortModeRsp();
        int cmdcode = 2172749;
        int result = super.sendCommand(this.neid, (FStruct)req, (FStruct)rsp, cmdcode);
        if (result == 0) {
            for (AsnPortWorkMode portMode : rsp.cpPortMode.portModeList) {
                int portid = TEConfigurationDataMgr.getPortRelativeID((int)portMode.portID.intValue());
                TEPort port = new TEPort(this.neid, slotID, -1, portid);
                this.portworkModeMap.put(port, portMode.portMode.intValue());
            }
        }
    }
}

