/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.graphexc;

import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.payload.asnngwdmpayload.AsnWDMEXC;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.payload.asnngwdmpayload.AsnWDMEXCList;
import com.huawei.nglct.nemgr.ngwdm.graphexc.bean.TENGWDMSingleXCBean;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TEGraphexcCache {
    private Map<TEPort, Set<TENGWDMSingleXCBean>> portXCMap = new HashMap<TEPort, Set<TENGWDMSingleXCBean>>();
    private Map<TEPort, Set<TENGWDMSingleXCBean>> portWorkXCMap = new HashMap<TEPort, Set<TENGWDMSingleXCBean>>();
    private Map<TEPort, Set<TENGWDMSingleXCBean>> portProtectXCMap = new HashMap<TEPort, Set<TENGWDMSingleXCBean>>();
    private static TEGraphexcCache instance = null;

    private TEGraphexcCache() {
    }

    public static synchronized TEGraphexcCache getInstance() {
        if (instance == null) {
            instance = new TEGraphexcCache();
        }
        return instance;
    }

    public synchronized void addPortXCMap(int xcType, TESubrack subrack, TENGWDMSingleXCBean singlexc) {
        Set<Object> snkXCList;
        Set<Object> srcXCList;
        Map<TEPort, Set<TENGWDMSingleXCBean>> tempMap = this.getPortXCMapByType(xcType);
        TEPort srcport = new TEPort(subrack.getNeid(), singlexc.getSrcSlotID(), 0, singlexc.getSrcPortID());
        TEPort snkport = new TEPort(subrack.getNeid(), singlexc.getSnkSlotID(), 0, singlexc.getSnkPortID());
        if (tempMap.containsKey(srcport)) {
            srcXCList = tempMap.get(srcport);
            srcXCList.add(singlexc);
        } else {
            srcXCList = new HashSet();
            srcXCList.add(singlexc);
            tempMap.put(srcport, srcXCList);
        }
        if (tempMap.containsKey(snkport)) {
            snkXCList = tempMap.get(snkport);
            snkXCList.add(singlexc);
        } else {
            snkXCList = new HashSet();
            snkXCList.add(singlexc);
            tempMap.put(snkport, snkXCList);
        }
    }

    public Map<TEPort, Set<TENGWDMSingleXCBean>> getPortXCMapByType(int xcType) {
        if (xcType == 2) {
            return this.portWorkXCMap;
        }
        if (xcType == 1) {
            return this.portProtectXCMap;
        }
        return this.portXCMap;
    }

    public synchronized void removeXC(int xcType, int neid, AsnWDMEXCList xcList) {
        Map<TEPort, Set<TENGWDMSingleXCBean>> tempMap = this.getPortXCMapByType(xcType);
        for (AsnWDMEXC xc : xcList) {
            Set<TENGWDMSingleXCBean> xcSet;
            TENGWDMSingleXCBean singleXC = new TENGWDMSingleXCBean(xc, neid);
            TEPort srcPort = new TEPort(neid, xc.srcSlotID, 0, xc.srcPortID);
            TEPort snkPort = new TEPort(neid, xc.snkSlotID, 0, xc.snkPortID);
            if (tempMap.containsKey(srcPort) && (xcSet = tempMap.get(srcPort)).contains(singleXC)) {
                xcSet.remove(singleXC);
            }
            if (!tempMap.containsKey(snkPort) || !(xcSet = tempMap.get(snkPort)).contains(singleXC)) continue;
            xcSet.remove(singleXC);
        }
    }

    public synchronized void removeXC(int xcType, int neid, AsnWDMEXC xc) {
        AsnWDMEXCList xcList = new AsnWDMEXCList();
        xcList.add((Object)xc);
        this.removeXC(xcType, neid, xcList);
    }

    public synchronized void removeXC(int xcType, int neid, TENGWDMSingleXCBean xc) {
        Set<TENGWDMSingleXCBean> xcSet;
        Map<TEPort, Set<TENGWDMSingleXCBean>> tempMap = this.getPortXCMapByType(xcType);
        TEPort srcPort = new TEPort(neid, xc.getSrcSlotID(), 0, xc.getSrcPortID());
        TEPort snkPort = new TEPort(neid, xc.getSnkSlotID(), 0, xc.getSnkPortID());
        if (tempMap.containsKey(srcPort) && (xcSet = tempMap.get(srcPort)).contains(xc)) {
            xcSet.remove(xc);
        }
        if (tempMap.containsKey(snkPort) && (xcSet = tempMap.get(snkPort)).contains(xc)) {
            xcSet.remove(xc);
        }
    }

    public synchronized void updateActiveState(int xcType, int neid, AsnWDMEXCList xcList, int activeState) {
        Map<TEPort, Set<TENGWDMSingleXCBean>> tempMap = this.getPortXCMapByType(xcType);
        for (AsnWDMEXC xc : xcList) {
            Set<TENGWDMSingleXCBean> xcSet;
            TENGWDMSingleXCBean singleXC = new TENGWDMSingleXCBean(xc, neid);
            TEPort srcPort = new TEPort(neid, xc.srcSlotID, 0, xc.srcPortID);
            TEPort snkPort = new TEPort(neid, xc.snkSlotID, 0, xc.snkPortID);
            if (tempMap.containsKey(srcPort)) {
                xcSet = tempMap.get(srcPort);
                for (TENGWDMSingleXCBean inXC : xcSet) {
                    if (!inXC.equals(singleXC)) continue;
                    inXC.setActiveState(activeState);
                }
            }
            if (!tempMap.containsKey(snkPort)) continue;
            xcSet = tempMap.get(snkPort);
            for (TENGWDMSingleXCBean inXC : xcSet) {
                if (!inXC.equals(singleXC)) continue;
                inXC.setActiveState(activeState);
            }
        }
    }

    public synchronized void clearAll() {
        this.portXCMap.clear();
        this.portWorkXCMap.clear();
        this.portProtectXCMap.clear();
    }
}

