/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.graphexc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.jni.TEJNIFacadeUtil;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnPortIndex;
import com.huawei.nglct.nemgr.f_interface.fiber.AsnJNIBasicNameInfo;
import com.huawei.nglct.nemgr.f_interface.fiber.AsnJNIGetBasicNameInfoReq;
import com.huawei.nglct.nemgr.f_interface.fiber.AsnJNIGetBasicNameInfoRsp;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.payload.asnngwdmpayload.AsnSWSNCPResult;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.payload.asnngwdmpayload.AsnSWSNCPResultList;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.payload.asnngwdmpayload.AsnWDMEXCResult;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.payload.asnngwdmpayload.AsnWDMEXCResultList;
import com.huawei.nglct.nemgr.ngwdm.graphexc.bean.TENGWDMSingleXCBean;
import com.huawei.nglct.ngwdm_pub.serv.cpadpt.TEChannelKey;
import com.huawei.nglct.ngwdm_pub.serv.cpadpt.TEOpticalPortModelAdpt;
import com.huawei.nglct.ngwdm_pub.serv.cpadpt.TETimeSlotModel;
import com.huawei.nglct.ngwdm_pub.serv.cpadpt.TETimeslot;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;

public class TEGraphExcUtil {
    private static final int NE_SHELF_SLOT_PORT_NAME = 15;

    public static int getSignalODU0Num(String signal) {
        if ("ODU0".equals(signal)) {
            return 1;
        }
        if ("ODU1".equals(signal)) {
            return 2;
        }
        if ("ODU2".equals(signal)) {
            return 8;
        }
        if ("ODU3".equals(signal)) {
            return 32;
        }
        if ("ODU4".equals(signal)) {
            return 80;
        }
        return 0;
    }

    public static int countODU0Num(int bdType, int opticalPortNum, int index) {
        int count = 0;
        List tsList = TEOpticalPortModelAdpt.getInstance().getMappedTimeSlotModelList(bdType, TEConfigurationDataMgr.getPortRelativeID((int)opticalPortNum), index);
        for (TETimeSlotModel ts : tsList) {
            if (!"ODU0".equals(ts.getcSignal())) continue;
            ++count;
        }
        return count;
    }

    public static boolean isBranchBoard(int bdType) {
        return bdType == 2359 || bdType == 2361 || bdType == 2357 || bdType == 2816 || bdType == 2817 || bdType == 2382 || bdType == 2373 || bdType == 2842 || TESpecialAttrMgr.getInstance().isCPSupportByType(bdType, "TE_FUNC_CFG_SERVICE_VIEW", "OTN_ATTR_OTU_BRANCH_BOARD");
    }

    public static String getSupportLevel(int bdType, int opticalPortNum, int index) {
        StringBuilder supportLevel = new StringBuilder();
        List tsList = TEOpticalPortModelAdpt.getInstance().getMappedTimeSlotModelList(bdType, TEConfigurationDataMgr.getPortRelativeID((int)opticalPortNum), index);
        for (TETimeSlotModel ts : tsList) {
            String signal = ts.getcSignal();
            if (signal.indexOf("ODU") < 0 || supportLevel.indexOf(signal) >= 0) continue;
            supportLevel.append(signal).append(",");
        }
        return supportLevel.toString();
    }

    public static void addSNCPParams(RowParams row, TENGWDMSingleXCBean singleXC) {
        int sncpType = 3;
        int revertiveMode = 0;
        int sdTriggerFlag = 0;
        int delayTime = 0;
        int protectDelayTime = 0;
        int wtrTime = 0;
        int otnLevel = 255;
        Param sncpTypeParam = row.getParam("sncpType");
        Param revertiveModeParam = row.getParam("revertiveMode");
        Param sdTriggerFlagParam = row.getParam("sdTriggerFlag");
        Param delayTimeParam = row.getParam("delayTime");
        Param protectDelayTimeParam = row.getParam("protectDelayTime");
        Param wtrTimeParam = row.getParam("wtrTime");
        Param otnLevelParam = row.getParam("otnLevel");
        if (sncpTypeParam != null && sncpTypeParam.getValue() != null) {
            sncpType = Integer.parseInt(sncpTypeParam.getValue());
        }
        if (revertiveModeParam != null && revertiveModeParam.getValue() != null) {
            revertiveMode = Integer.parseInt(revertiveModeParam.getValue());
        }
        if (sdTriggerFlagParam != null && sdTriggerFlagParam.getValue() != null) {
            sdTriggerFlag = Integer.parseInt(sdTriggerFlagParam.getValue());
        }
        if (delayTimeParam != null && delayTimeParam.getValue() != null) {
            delayTime = Integer.parseInt(delayTimeParam.getValue());
        }
        if (wtrTimeParam != null && wtrTimeParam.getValue() != null) {
            wtrTime = Integer.parseInt(wtrTimeParam.getValue());
        }
        if (protectDelayTimeParam != null && protectDelayTimeParam.getValue() != null) {
            protectDelayTime = Integer.parseInt(protectDelayTimeParam.getValue());
        }
        if (otnLevelParam != null && otnLevelParam.getValue() != null) {
            otnLevel = Integer.parseInt(otnLevelParam.getValue());
        }
        singleXC.setPgType(sncpType);
        singleXC.setRevertMode(revertiveMode);
        singleXC.setSdFlag(sdTriggerFlag);
        singleXC.setWtrTime(wtrTime);
        singleXC.setOtnLevel(otnLevel);
        if (singleXC.getXcType() == 1) {
            singleXC.setDelayTime(protectDelayTime);
        } else {
            singleXC.setDelayTime(delayTime);
        }
    }

    public static List<TENGWDMSingleXCBean> getWorkXCListFromInput(int neid, Datainterface inputData) {
        RowParams[] rows = inputData.getBussinessParams().getRowParams();
        ArrayList<TENGWDMSingleXCBean> xcList = new ArrayList<TENGWDMSingleXCBean>();
        for (RowParams row : rows) {
            int srcSlotID = Integer.parseInt(row.getParam("srcSlotID").getValue());
            int srcPortID = Integer.parseInt(row.getParam("srcPortID").getValue());
            int snkSlotID = Integer.parseInt(row.getParam("snkSlotID").getValue());
            int snkPortID = Integer.parseInt(row.getParam("snkPortID").getValue());
            int serviceLevel = Integer.parseInt(row.getParam("serviceLevel").getValue());
            int activeState = Integer.parseInt(row.getParam("activeState").getValue());
            int direction = Integer.parseInt(row.getParam("direction").getValue());
            Param xcidParam = row.getParam("xcid");
            Param biXCIDParam = row.getParam("biXCID");
            Param pgidParam = row.getParam("pgid");
            Param workXCIDParam = row.getParam("workXCID");
            int reverseXCID = 0;
            int xcid = 0;
            int pgid = 0;
            int workXCID = 0;
            if (xcidParam != null) {
                xcid = Integer.parseInt(xcidParam.getValue());
            }
            if (biXCIDParam != null) {
                reverseXCID = Integer.parseInt(biXCIDParam.getValue());
            }
            if (pgidParam != null) {
                pgid = Integer.parseInt(pgidParam.getValue());
            }
            if (workXCIDParam != null) {
                workXCID = Integer.parseInt(workXCIDParam.getValue());
            }
            String serviceType = row.getParam("serviceType").getValue();
            String timeslot = row.getParam("timeslot").getValue();
            String svcRate = row.getParam("svcRate").getValue();
            String srcPath = row.getParam("srcPath").getValue();
            ArrayList srcPathList = new ArrayList();
            TEStringUtils.str2Vec((String)srcPath, srcPathList);
            String snkPath = row.getParam("snkPath").getValue();
            ArrayList snkPathList = new ArrayList();
            TEStringUtils.str2Vec((String)snkPath, snkPathList);
            int iLength = srcPathList.size();
            for (int i = 0; i < iLength; ++i) {
                Integer srcPathID = (Integer)srcPathList.get(i);
                Integer snkPathID = (Integer)snkPathList.get(i);
                TENGWDMSingleXCBean singleXC = new TENGWDMSingleXCBean(neid);
                singleXC.setXcID(xcid);
                singleXC.setSrcSlotID(srcSlotID);
                singleXC.setSrcPortID(srcPortID);
                singleXC.setSrcPathID(srcPathID);
                singleXC.setSnkSlotID(snkSlotID);
                singleXC.setSnkPortID(snkPortID);
                singleXC.setSnkPathID(snkPathID);
                singleXC.setActiveState(activeState);
                singleXC.setDelayTime(0);
                singleXC.setPgID(pgid);
                singleXC.setPgType(0);
                singleXC.setOtnLevel(255);
                singleXC.setRevertMode(0);
                singleXC.setSdFlag(0);
                singleXC.setAttrList(new ArrayList());
                singleXC.setBelongToCircuit(0);
                singleXC.setWtrTime(0);
                singleXC.setIslock(0);
                if (serviceLevel == 12544) {
                    singleXC.setServiceLevel(Integer.parseInt(serviceType));
                } else {
                    singleXC.setServiceLevel(serviceLevel);
                    if (serviceLevel == 12336) {
                        singleXC.setSvcType(Integer.parseInt(serviceType));
                    }
                }
                if ("-".equals(timeslot)) {
                    singleXC.setTimeSlots(0);
                    singleXC.setOduflexSvcRate(0L);
                } else {
                    singleXC.setTimeSlots(Integer.parseInt(timeslot));
                    singleXC.setOduflexSvcRate(Long.parseLong(svcRate));
                }
                xcList.add(singleXC);
                if (0 == direction) {
                    TENGWDMSingleXCBean reverseXC = singleXC.makeReverseXC(singleXC);
                    reverseXC.setXcID(reverseXCID);
                    reverseXC.setXcType(0);
                    reverseXC.setPgID(0);
                    xcList.add(reverseXC);
                }
                if (workXCID != 0 && workXCID == xcid) {
                    singleXC.setXcType(2);
                    TEGraphExcUtil.addSNCPParams(row, singleXC);
                    continue;
                }
                singleXC.setXcType(0);
            }
        }
        return xcList;
    }

    public static List<TENGWDMSingleXCBean> getProtectXCListFromInput(int neid, Datainterface inputData, List<TENGWDMSingleXCBean> workList) {
        RowParams[] rows = inputData.getBussinessParams().getRowParams();
        ArrayList<TENGWDMSingleXCBean> xcList = new ArrayList<TENGWDMSingleXCBean>();
        for (RowParams row : rows) {
            Param protectXCIDParam;
            if (row.getParam("protectSlotID") == null) continue;
            int srcSlotID = Integer.parseInt(row.getParam("protectSlotID").getValue());
            int srcPortID = Integer.parseInt(row.getParam("protectPortID").getValue());
            int snkSlotID = Integer.parseInt(row.getParam("snkSlotID").getValue());
            int snkPortID = Integer.parseInt(row.getParam("snkPortID").getValue());
            int serviceLevel = Integer.parseInt(row.getParam("serviceLevel").getValue());
            int activeState = Integer.parseInt(row.getParam("activeState").getValue());
            int direction = Integer.parseInt(row.getParam("direction").getValue());
            int pgid = 0;
            int protectXCID = 0;
            Param pgidParam = row.getParam("pgid");
            if (pgidParam != null) {
                pgid = Integer.parseInt(pgidParam.getValue());
            }
            if ((protectXCIDParam = row.getParam("protectXCID")) != null) {
                protectXCID = Integer.parseInt(protectXCIDParam.getValue());
            }
            String serviceType = row.getParam("serviceType").getValue();
            String timeslot = row.getParam("timeslot").getValue();
            String svcRate = row.getParam("svcRate").getValue();
            String srcPath = row.getParam("protectPath").getValue();
            ArrayList srcPathList = new ArrayList();
            TEStringUtils.str2Vec((String)srcPath, srcPathList);
            String snkPath = row.getParam("snkPath").getValue();
            ArrayList snkPathList = new ArrayList();
            TEStringUtils.str2Vec((String)snkPath, snkPathList);
            int iLength = srcPathList.size();
            for (int i = 0; i < iLength; ++i) {
                Integer srcPathID = (Integer)srcPathList.get(i);
                Integer snkPathID = (Integer)snkPathList.get(i);
                TENGWDMSingleXCBean singleXC = new TENGWDMSingleXCBean(neid);
                singleXC.setXcID(protectXCID);
                singleXC.setSrcSlotID(srcSlotID);
                singleXC.setSrcPortID(srcPortID);
                singleXC.setSrcPathID(srcPathID);
                singleXC.setSnkSlotID(snkSlotID);
                singleXC.setSnkPortID(snkPortID);
                singleXC.setSnkPathID(snkPathID);
                singleXC.setActiveState(activeState);
                singleXC.setDelayTime(0);
                singleXC.setPgID(pgid);
                singleXC.setPgType(0);
                singleXC.setOtnLevel(255);
                singleXC.setRevertMode(0);
                singleXC.setSdFlag(0);
                singleXC.setXcType(1);
                singleXC.setAttrList(new ArrayList());
                singleXC.setBelongToCircuit(0);
                singleXC.setWtrTime(0);
                singleXC.setIslock(0);
                if (serviceLevel == 12544) {
                    singleXC.setServiceLevel(Integer.parseInt(serviceType));
                } else {
                    singleXC.setServiceLevel(serviceLevel);
                    if (serviceLevel == 12336) {
                        singleXC.setSvcType(Integer.parseInt(serviceType));
                    }
                }
                if ("-".equals(timeslot)) {
                    singleXC.setTimeSlots(0);
                    singleXC.setOduflexSvcRate(0L);
                } else {
                    singleXC.setTimeSlots(Integer.parseInt(timeslot));
                    singleXC.setOduflexSvcRate(Long.parseLong(svcRate));
                }
                xcList.add(singleXC);
                if (0 == direction) {
                    TENGWDMSingleXCBean reverseXC = singleXC.makeReverseXC(singleXC);
                    reverseXC.setXcType(0);
                    workList.add(reverseXC);
                }
                TEGraphExcUtil.addSNCPParams(row, singleXC);
            }
        }
        return xcList;
    }

    public static RowParams getXCRowParams(TENGWDMSingleXCBean xc) {
        RowParams row = new RowParams();
        row.addParam(new Param("srcSlot", String.valueOf(xc.getSrcSlotID())));
        row.addParam(new Param("showSrcSlot", String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)xc.getNEID(), (int)xc.getSrcSlotID()))));
        row.addParam(new Param("srcBoardName", TEConfigurationDataMgr.getInstance().getBoardName(xc.getNEID(), xc.getSrcSlotID())));
        row.addParam(new Param("srcPort", String.valueOf(xc.getSrcPortID())));
        row.addParam(new Param("showSrcPort", String.valueOf(TEConfigurationDataMgr.getPortRelativeID((int)xc.getSrcPortID()))));
        row.addParam(new Param("srcPath", String.valueOf(xc.getSrcPathID())));
        TEBoard srcBoard = TEConfigurationDataMgr.getInstance().getBoard(xc.getNEID(), xc.getSrcSlotID());
        if (!TEGraphExcUtil.isBranchBoard(srcBoard.getBoardType())) {
            List tsList = TEOpticalPortModelAdpt.getInstance().getTimeslotByChannel(new TEChannelKey(srcBoard.getBoardType(), TEConfigurationDataMgr.getPortRelativeID((int)xc.getSrcPortID()), xc.getSrcPathID()));
            int iLength = tsList.size();
            for (int i = 0; i < iLength; ++i) {
                if (((TETimeslot)tsList.get(i)).getSignal().indexOf("ODU") < 0) continue;
                row.addParam(new Param("srcTs", ((TETimeslot)tsList.get(i)).getValue()));
            }
        }
        row.addParam(new Param("snkSlot", String.valueOf(xc.getSnkSlotID())));
        row.addParam(new Param("showSnkSlot", String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)xc.getNEID(), (int)xc.getSnkSlotID()))));
        row.addParam(new Param("snkBoardName", TEConfigurationDataMgr.getInstance().getBoardName(xc.getNEID(), xc.getSnkSlotID())));
        row.addParam(new Param("snkPort", String.valueOf(xc.getSnkPortID())));
        row.addParam(new Param("showSnkPort", String.valueOf(TEConfigurationDataMgr.getPortRelativeID((int)xc.getSnkPortID()))));
        row.addParam(new Param("snkPath", String.valueOf(xc.getSnkPathID())));
        TEBoard snkBoard = TEConfigurationDataMgr.getInstance().getBoard(xc.getNEID(), xc.getSnkSlotID());
        if (!TEGraphExcUtil.isBranchBoard(snkBoard.getBoardType())) {
            List tsList = TEOpticalPortModelAdpt.getInstance().getTimeslotByChannel(new TEChannelKey(snkBoard.getBoardType(), TEConfigurationDataMgr.getPortRelativeID((int)xc.getSnkPortID()), xc.getSnkPathID()));
            int iLength = tsList.size();
            for (int i = 0; i < iLength; ++i) {
                if (((TETimeslot)tsList.get(i)).getSignal().indexOf("ODU") < 0) continue;
                row.addParam(new Param("snkTs", ((TETimeslot)tsList.get(i)).getValue()));
            }
        }
        row.addParam(new Param("svcType", String.valueOf(xc.getSvcType())));
        row.addParam(new Param("activeState", String.valueOf(xc.getActiveState())));
        row.addParam(new Param("otnLevel", String.valueOf(xc.getOtnLevel())));
        row.addParam(new Param("serviceLevel", String.valueOf(xc.getServiceLevel())));
        row.addParam(new Param("xcid", String.valueOf(xc.getXcID())));
        row.addParam(new Param("xcType", String.valueOf(xc.getXcType())));
        row.addParam(new Param("pgid", String.valueOf(xc.getPgID())));
        row.addParam(new Param("sncpType", String.valueOf(xc.getPgType())));
        row.addParam(new Param("protectType", String.valueOf(xc.getPgType())));
        row.addParam(new Param("revertiveMode", String.valueOf(xc.getRevertMode())));
        row.addParam(new Param("wtrTime", String.valueOf(xc.getWtrTime())));
        row.addParam(new Param("sdTriggerFlag", String.valueOf(xc.getSdFlag())));
        row.addParam(new Param("delayTime", String.valueOf(xc.getDelayTime())));
        row.addParam(new Param("oduFlexTimeSlots", String.valueOf(xc.getTimeSlots())));
        row.addParam(new Param("oduflexRateSlot", String.valueOf(xc.getOduflexSvcRate())));
        return row;
    }

    public static int getTimeslotMode(int neid, int slotid, int portid) {
        TEGeneralKeyValue key = new TEGeneralKeyValue();
        key.setAttrID(272420);
        int[] tEOBJECTID = new int[]{61509, neid, slotid, portid, 1};
        key.setTEOBJECTID(tEOBJECTID);
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>();
        TEGnlValueElement element = new TEGnlValueElement();
        element.setGnlKeyValue(key);
        elementList.add(element);
        StringBuffer buffer = new StringBuffer(0);
        buffer.append("find gnl value. req->").append('\n');
        for (TEGnlValueElement ele : elementList) {
            buffer.append(ele.toString()).append('\n');
        }
        TELogFactory.getNormalLogger().info("find gnl value. req->" + buffer.toString());
        TEDaoOperationResult result = TECommonDaoService.findGnlValue_NoLock(elementList);
        TELogFactory.getNormalLogger().info("find gnl value. rsp->" + result.getResult());
        List data = result.getData();
        TEGnlValueElement ele = (TEGnlValueElement)data.get(0);
        return ele.getGnlValue().getiValue();
    }

    public static boolean isBiDirection(TENGWDMSingleXCBean xc, Set<TENGWDMSingleXCBean> xcSet) {
        for (TENGWDMSingleXCBean outxc : xcSet) {
            if (outxc.getSrcSlotID() != xc.getSnkSlotID() || outxc.getSrcPortID() != xc.getSnkPortID() || outxc.getSrcPathID() != xc.getSnkPathID() || outxc.getSnkSlotID() != xc.getSrcSlotID() || outxc.getSnkPortID() != xc.getSrcPortID() || outxc.getSnkPathID() != xc.getSrcPathID()) continue;
            return true;
        }
        return false;
    }

    public static void addXCErrors(int neid, Datainterface outputData, AsnWDMEXCResultList failXCList) {
        RowParams rowparams = new RowParams();
        int size = failXCList.size();
        for (int i = 0; i < size; ++i) {
            AsnWDMEXCResult errXC = (AsnWDMEXCResult)failXCList.get(i);
            RowErrors rowErr = new RowErrors();
            int showSrcSlotID = TEBoardUtil.getSlotIDFromSlot((int)neid, (int)errXC.xc.srcSlotID);
            int srcSubrack = TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)errXC.xc.srcSlotID);
            int srcPortid = TEConfigurationDataMgr.getPortRelativeID((int)errXC.xc.srcPortID);
            int showSnkSlotID = TEBoardUtil.getSlotIDFromSlot((int)neid, (int)errXC.xc.snkSlotID);
            int snkSubrack = TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)errXC.xc.snkSlotID);
            int snkPortid = TEConfigurationDataMgr.getPortRelativeID((int)errXC.xc.snkPortID);
            rowErr.addParam(new Param("srcSubrack", String.valueOf(srcSubrack)));
            rowErr.addParam(new Param("srcSlotID", String.valueOf(showSrcSlotID)));
            rowErr.addParam(new Param("srcPort", String.valueOf(srcPortid)));
            rowErr.addParam(new Param("srcPath", String.valueOf(errXC.xc.srcPathID)));
            rowErr.addParam(new Param("snkSubrack", String.valueOf(snkSubrack)));
            rowErr.addParam(new Param("snkSlotID", String.valueOf(showSnkSlotID)));
            rowErr.addParam(new Param("snkPort", String.valueOf(snkPortid)));
            rowErr.addParam(new Param("snkPath", String.valueOf(errXC.xc.snkPathID)));
            rowErr.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errXC.errCode.getRetCode()));
            rowparams.addRowErrors(rowErr);
        }
        outputData.getBussinessParams().addRowParams(rowparams);
    }

    public static void addXCErrors(int neid, Datainterface outputData, AsnSWSNCPResultList failList) {
        RowParams rowparams = new RowParams();
        int size = failList.size();
        for (int i = 0; i < size; ++i) {
            AsnSWSNCPResult result = (AsnSWSNCPResult)failList.get(i);
            RowErrors rowErr = new RowErrors();
            int showSrcSlotID = TEBoardUtil.getSlotIDFromSlot((int)neid, (int)result.workXC.srcSlotID);
            int srcSubrack = TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)result.workXC.srcSlotID);
            int srcPortid = TEConfigurationDataMgr.getPortRelativeID((int)result.workXC.srcPortID);
            int showSnkSlotID = TEBoardUtil.getSlotIDFromSlot((int)neid, (int)result.workXC.snkSlotID);
            int snkSubrack = TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)result.workXC.snkSlotID);
            int snkPortid = TEConfigurationDataMgr.getPortRelativeID((int)result.workXC.snkPortID);
            int showProtectSlotID = TEBoardUtil.getSlotIDFromSlot((int)neid, (int)result.protectXC.srcSlotID);
            int protectSubrack = TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)result.protectXC.srcSlotID);
            int protectPortid = TEConfigurationDataMgr.getPortRelativeID((int)result.protectXC.srcPortID);
            rowErr.addParam(new Param("srcSubrack", String.valueOf(srcSubrack)));
            rowErr.addParam(new Param("srcSlotID", String.valueOf(showSrcSlotID)));
            rowErr.addParam(new Param("srcPort", String.valueOf(srcPortid)));
            rowErr.addParam(new Param("srcPath", String.valueOf(result.workXC.srcPathID)));
            rowErr.addParam(new Param("snkSubrack", String.valueOf(snkSubrack)));
            rowErr.addParam(new Param("snkSlotID", String.valueOf(showSnkSlotID)));
            rowErr.addParam(new Param("snkPort", String.valueOf(snkPortid)));
            rowErr.addParam(new Param("snkPath", String.valueOf(result.workXC.snkPathID)));
            rowErr.addParam(new Param("protectSubrack", String.valueOf(protectSubrack)));
            rowErr.addParam(new Param("protectSlotID", String.valueOf(showProtectSlotID)));
            rowErr.addParam(new Param("protectionPort", String.valueOf(protectPortid)));
            rowErr.addParam(new Param("protectionPath", String.valueOf(result.protectXC.srcPathID)));
            rowErr.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result.errCode.intValue()));
            rowparams.addRowErrors(rowErr);
        }
        outputData.getBussinessParams().addRowParams(rowparams);
    }

    public static String getNENameFromOtherMgr(int neid) {
        AsnJNIGetBasicNameInfoReq aReq = new AsnJNIGetBasicNameInfoReq();
        AsnJNIGetBasicNameInfoRsp aRsp = new AsnJNIGetBasicNameInfoRsp();
        String neName = "Unknown";
        AsnPortIndex portIndex = new AsnPortIndex();
        portIndex.neID = neid;
        portIndex.slotID = 0;
        portIndex.portID = 0;
        aReq.flag = 15;
        aReq.portIndexList.add((Object)portIndex);
        int retCode = (int)TEJNIFacadeUtil.sendJNIMessage((int)201, (FStruct)aReq, (FStruct)aRsp);
        if (0 != retCode) {
            return neName;
        }
        if (aRsp.nameInfoList != null && !aRsp.nameInfoList.isEmpty()) {
            AsnJNIBasicNameInfo nameInfo = (AsnJNIBasicNameInfo)aRsp.nameInfoList.get(0);
            if (nameInfo.neName != null) {
                neName = new String(nameInfo.neName);
            }
        }
        return neName;
    }
}

