/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.gencfg;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.gencfg.TEGenCfgFunAttr;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenAttrObjectValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenObjectID;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenOperationResult;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValueResult;
import com.huawei.nglct.nemgr.ngwdm.gencfg.TENGWDMGencfgAttrDataBuildFactory;
import com.huawei.nglct.nemgr.ngwdm.gencfg.TENGWDMGencfgAttrDataBuildSuperBean;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.TEWDMInfStaticData;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.TEWDMInfUtil;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.objtypeid.TEPartSource;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TENGWDMGenAttrObjectValue {
    private static final int QEURY_OPER = 1;
    private static final int SET_OPER = 2;
    public static final int W32PORT_ATTR_LINE_CAPACITY = 10001012;
    private static final int CMDNOTSUPPORT = 38737;
    private final Map<Integer, String> errorCodeMessageMap = new HashMap<Integer, String>();
    protected int TIME_OUT = 20;
    private TEGenAttrObjectValue genAttrValue;

    public TENGWDMGenAttrObjectValue(TEGenAttrObjectValue attrValue) {
        this.genAttrValue = attrValue;
    }

    public Datainterface getAttrDatainterface(int attrID, TEGenAttrObjectValue genAttrValue) {
        TENGWDMGencfgAttrDataBuildSuperBean attrDataBuilder = TENGWDMGencfgAttrDataBuildFactory.getInstance().buildTENGWDMGencfgAttrDataBean(attrID, genAttrValue);
        return attrDataBuilder.getAttrDatainterface(attrID);
    }

    public Datainterface getAttrDatainterface(int attrID, ArrayList groupAttrList, TEGenAttrObjectValue genAttrValue) {
        TENGWDMGencfgAttrDataBuildSuperBean attrDataBuilder = TENGWDMGencfgAttrDataBuildFactory.getInstance().buildTENGWDMGencfgGroupAttrDataBean(groupAttrList, genAttrValue);
        return attrDataBuilder.getAttrDatainterface(attrID);
    }

    private TEGenOperationResult senGenOperation(TEGenCfgFunCmd funCmd, int operType, byte mitLockType) {
        HashMap<Integer, Operation> attrOperMap = new HashMap<Integer, Operation>();
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (int i = 0; i < this.genAttrValue.getAttrIDList().size(); ++i) {
            String attrType;
            TEGenValue tempGenValue = (TEGenValue)this.genAttrValue.getAttrIDList().get(i);
            switch (operType) {
                case 1: {
                    attrType = "query";
                    break;
                }
                case 2: {
                    attrType = "SET";
                    break;
                }
                default: {
                    TELogFactory.getNormalLogger().error("Unknow attr type!");
                    return null;
                }
            }
            List<Operation> tempOper = null;
            tempOper = 1 == mitLockType ? this.getAttrOperationList(this.genAttrValue, attrType, funCmd, tempGenValue) : this.getAttrOperationList_NoLock(this.genAttrValue, attrType, funCmd, tempGenValue);
            if (tempOper == null || tempOper.isEmpty()) continue;
            operations.addAll(tempOper);
            attrOperMap.put(tempGenValue.getAttrID(), tempOper.get(0));
        }
        if (operations.isEmpty()) {
            return new TEGenOperationResult(0, "");
        }
        TELogFactory.getNormalLogger().info("begin to SendCommand.");
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.genAttrValue.getNEID(), operations, this.TIME_OUT);
        TELogFactory.getNormalLogger().info("end to SendCommand. result->" + result.retCode);
        return this.getResultFormOperations(funCmd, operType, attrOperMap, result);
    }

    public TEGenOperationResult sendSetGenOperation(TEGenCfgFunCmd funCmd, byte mitLockType) {
        return this.senGenOperation(funCmd, 2, mitLockType);
    }

    public List<TEGenOperationResult> sendSetGenOperation(List<TEGenAttrObjectValue> attrList, TEGenCfgFunCmd funCmd) {
        return this.senGenOperationList(attrList, funCmd);
    }

    private List<TEGenOperationResult> senGenOperationList(List<TEGenAttrObjectValue> attrList, TEGenCfgFunCmd funCmd) {
        TEGenOperationResult result;
        ArrayList<TEGenOperationResult> operResultList = new ArrayList<TEGenOperationResult>();
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (TEGenAttrObjectValue attrValue : attrList) {
            if (!attrValue.isNeedSetToNE()) continue;
            HashMap<Integer, Operation> attrOperMap = new HashMap<Integer, Operation>();
            TEGenAttrObjectValue tempAttrValue = attrValue;
            for (int i = 0; i < attrValue.getAttrIDList().size(); ++i) {
                TEGenValue tempGenValue = (TEGenValue)attrValue.getAttrIDList().get(i);
                String attrType = "SET";
                TEGenCfgFunAttr funAttr = funCmd.getGenCfgFunAttr(tempGenValue.getAttrName(), attrType);
                if (funAttr.getGroupAttrList().size() > 0) {
                    tempAttrValue = this.getGenGroupAttrObjValue(attrValue, attrList, funAttr.getGroupAttrList());
                }
                List<Operation> tempOper = null;
                tempOper = 1 == tempAttrValue.getMitLockType() ? this.getAttrOperationList(tempAttrValue, attrType, funCmd, tempGenValue) : this.getAttrOperationList_NoLock(tempAttrValue, attrType, funCmd, tempGenValue);
                if (tempOper == null || tempOper.isEmpty()) continue;
                operations.addAll(tempOper);
                attrOperMap.put(tempGenValue.getAttrID(), tempOper.get(0));
            }
        }
        if (operations.isEmpty()) {
            result = new TEGenOperationResult(0, "");
            operResultList.add(result);
            return operResultList;
        }
        TELogFactory.getNormalLogger().info("begin to SendCommand.");
        TELogFactory.getNormalLogger().info("NE:" + this.genAttrValue.getNEID() + " send commond.oper size is " + operations.size());
        result = this.sendBatCommand(this.genAttrValue.getNEID(), operations);
        TELogFactory.getNormalLogger().info("end to SendCommand. result->" + result.retCode);
        TEGenOperationResult genResult = new TEGenOperationResult();
        TEGenValueResult attrResult = new TEGenValueResult();
        attrResult.errorCode = result.retCode;
        genResult.getGenResultList().add(attrResult);
        operResultList.add(genResult);
        return operResultList;
    }

    protected OperationResult sendBatCommand(int neID, List<Operation> allOperList) {
        OperationResult result = null;
        ArrayList<Operation> operList = null;
        int m = 50;
        int n = allOperList.size();
        for (int i = 0; i < n; i += m) {
            operList = new ArrayList<Operation>();
            if (i + m > n) {
                operList.addAll(allOperList.subList(i, n));
            } else {
                operList.addAll(allOperList.subList(i, i + m));
            }
            result = TENECommMgr.getInstance().sendCommand(neID, operList, this.TIME_OUT);
            if (0 != result.retCode) {
                TELogFactory.getNormalLogger().info("NE:" + neID + " send commond fail. Errorcode is " + result.retCode);
                break;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                TELogFactory.getNormalLogger().error("TENGWDMGenAttrObjectValue thread sleep error! ", (Throwable)e);
            }
        }
        return result;
    }

    public TEGenOperationResult sendQueryGenOperation(TEGenCfgFunCmd funCmd, byte mitLockType) {
        return this.senGenOperation(funCmd, 1, mitLockType);
    }

    private TEGenOperationResult getResultFormOperations(TEGenCfgFunCmd funCmd, int operType, Map<Integer, Operation> attrOperMap, OperationResult result) {
        TEGenOperationResult genResult = new TEGenOperationResult();
        boolean hasSucess = false;
        boolean hasFailed = false;
        if (result.retCode == 0) {
            for (TEGenValue attrValue : this.genAttrValue.getAttrIDList()) {
                Output output;
                String attrQueryValue;
                Operation temOper = attrOperMap.get(attrValue.getAttrID());
                TEGenValueResult attrResult = new TEGenValueResult();
                attrResult.attrID = attrValue.getAttrID();
                if (temOper == null || temOper.getOutput().length == 0) {
                    TELogFactory.getNormalLogger().warn("The result of " + operType + " attr(" + attrValue.getAttrName() + ") is unknown!");
                    continue;
                }
                if (operType == 1 && (attrQueryValue = this.getAttrValueFromOperationOutput(temOper.getOutput(), TEGenValue.convertAttrNameToQxName((String)attrValue.getAttrName()))) != null) {
                    attrResult.attrValue = attrQueryValue;
                }
                if ((output = temOper.getOutput()[0]).getFault(0) == null || output.getFault(0).getCode().isEmpty()) {
                    TELogFactory.getNormalLogger().warn("The result of " + operType + " attr(" + attrValue.getAttrName() + ") is unknown!");
                    continue;
                }
                int errorCodeInt = Integer.parseInt(output.getFault(0).getCode());
                attrResult.errorCode = attrResult.attrID == 10001012 && errorCodeInt == 38737 ? 0 : errorCodeInt;
                attrResult.errorInfo = this.getErrorMessage(attrResult.errorCode);
                genResult.getGenResultList().add(attrResult);
                if (attrResult.errorCode == 0) {
                    hasSucess = true;
                    if (operType != 2 || errorCodeInt == 38737) continue;
                    this.saveAttrInfoToDB(funCmd, this.genAttrValue);
                    continue;
                }
                hasFailed = true;
            }
        } else {
            hasFailed = true;
            String errorInfo = this.getErrorMessage(result.retCode);
            for (TEGenValue attrValue : this.genAttrValue.getAttrIDList()) {
                TEGenValueResult attrResult = new TEGenValueResult();
                attrResult.attrID = attrValue.getAttrID();
                attrResult.errorCode = result.retCode;
                attrResult.errorInfo = errorInfo;
                genResult.getGenResultList().add(attrResult);
            }
        }
        if (hasSucess && !hasFailed) {
            genResult.setWholeErrorCode(0);
        } else if (hasSucess && hasFailed) {
            genResult.setWholeErrorCode(1);
        } else if (hasFailed && !hasSucess) {
            genResult.setWholeErrorCode(2);
        }
        genResult.setErrorInfo(this.getErrorMessage(genResult.getWholeErrorCode()));
        return genResult;
    }

    private String getErrorMessage(int errorCode) {
        if (this.errorCodeMessageMap.containsKey(errorCode)) {
            return this.errorCodeMessageMap.get(errorCode);
        }
        String errorMessage = TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode);
        this.errorCodeMessageMap.put(errorCode, errorMessage);
        return errorMessage;
    }

    private void saveAttrInfoToDB(TEGenCfgFunCmd funCmd, TEGenAttrObjectValue genAttrObj) {
        if (!genAttrObj.isNeedSaveDB()) {
            return;
        }
        List<TEGnlValueElement> elementList = this.constructTEGlnValueElementList(funCmd, genAttrObj);
        if (elementList == null || elementList.isEmpty()) {
            return;
        }
        TEWDMInfUtil.saveAttrInfoToDB(elementList, true);
    }

    private List<TEGnlValueElement> constructTEGlnValueElementList(TEGenCfgFunCmd funCmd, TEGenAttrObjectValue genAttrObj) {
        ArrayList<TEGnlValueElement> glnElementList = new ArrayList<TEGnlValueElement>();
        if (genAttrObj != null) {
            boolean needConvert = TESpecialAttrMgr.getInstance().isNESupport(genAttrObj.getNEID(), "TE_FUNC_CFG_WDM_UNIT", "W32PORT_ATTR_OTN_BANDTYPE_SUPPORT_CONVERT");
            for (int i = 0; i < genAttrObj.getAttrIDList().size(); ++i) {
                TEGenValue genValue = (TEGenValue)genAttrObj.getAttrIDList().get(i);
                if (!this.isNeedSaveDB(genValue.getAttrName())) continue;
                TEPartSource partSource = this.constructPartSource(genAttrObj.getObjectID(), genValue);
                partSource.setNeedConvertAttrName(needConvert);
                TEGnlValueElement glnElement = TEWDMInfUtil.constructElement(genAttrObj.getNEID(), funCmd, partSource, genValue.getAttrName(), genValue.getValue());
                glnElementList.add(glnElement);
            }
        }
        return glnElementList;
    }

    private TEPartSource constructPartSource(TEGenObjectID objectID, TEGenValue genValue) {
        int slotID = objectID.getSlotIDInInt();
        int portID = objectID.getPortIDInInt();
        int nmPath = objectID.getPathIDInInt();
        int pathID = TENGWDMGenAttrObjectValue.getNePath(objectID.getNEID(), slotID, nmPath);
        return this.constructPartSource(slotID, portID, pathID, genValue.getAttrName(), genValue.getValue());
    }

    private TEPartSource constructPartSource(int slotID, int portID, int pathID, String attrName, String attrValue) {
        Input input = new Input();
        Part part = new Part();
        part.setName("slotid");
        part.setValue(String.valueOf(slotID));
        input.addPart(part);
        part = new Part();
        part.setName("port");
        part.setValue(String.valueOf(portID));
        input.addPart(part);
        part = new Part();
        part.setName("path");
        part.setValue(String.valueOf(pathID));
        input.addPart(part);
        part = new Part();
        part.setName(attrName);
        part.setValue(attrValue);
        input.addPart(part);
        TEPartSource partSource = new TEPartSource(input);
        return partSource;
    }

    private boolean isNeedSaveDB(String attrName) {
        String objTypeStr = TEWDMInfStaticData.getAttrNameObjTypeNameMap().get(attrName);
        return null != objTypeStr;
    }

    private String getAttrValueFromOperationOutput(Output[] output, String attrName) {
        int i$ = 0;
        Output[] arr$ = output;
        int len$ = arr$.length;
        if (i$ < len$) {
            Output element = arr$[i$];
            Part part = element.getPart(attrName);
            if (part != null) {
                return part.getValue();
            }
            return null;
        }
        return null;
    }

    public static Output getOutputByName(List<Operation> operations, String attrName) {
        for (int i = 0; i < operations.size(); ++i) {
            Output[] outputs = operations.get(i).getOutput();
            for (int j = 0; j < outputs.length; ++j) {
                Part part = outputs[j].getPart(attrName);
                if (part == null) continue;
                return outputs[j];
            }
        }
        return null;
    }

    private List<Operation> getAttrOperationList(TEGenAttrObjectValue genAttrValue, String operationType, TEGenCfgFunCmd funCmd, TEGenValue genValue) {
        TEGenCfgFunAttr funAttr = funCmd.getGenCfgFunAttr(genValue.getAttrName(), operationType);
        if (funAttr == null) {
            TELogFactory.getNormalLogger().info("Get attr(" + genValue.getAttrName() + ") for" + operationType + " TEGenCfgFunAttr failed!");
            return null;
        }
        ArrayList<String> operationNameList = new ArrayList<String>();
        String operationName = funAttr.getPtcode();
        operationNameList.add(operationName);
        String additioncmd = funAttr.getAdditionCmd();
        if (null != additioncmd && !"".equals(additioncmd.trim())) {
            operationNameList.add(additioncmd);
        }
        Datainterface inputData = new Datainterface();
        ArrayList groupAttrList = funAttr.getGroupAttrList();
        inputData = groupAttrList.size() > 0 ? this.getAttrDatainterface(genValue.getAttrID(), groupAttrList, genAttrValue) : this.getAttrDatainterface(genValue.getAttrID(), genAttrValue);
        this.handleNewOTNPath(genAttrValue.getNEID(), operationName, inputData);
        return TEGenCfgDataConvertor.convertToOperation((TEGenCfgFunAttr)funAttr, (Datainterface)inputData, (int)genAttrValue.getNEID(), operationNameList);
    }

    private void handleNewOTNPath(int neID, String operName, Datainterface inputData) {
        int nePath;
        int slotID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        TEOTNModelDataMgr otnModelInstance = TEOTNModelDataMgr.getInstance();
        int grade = otnModelInstance.getGradeFromBoard(boardType);
        RowParams rowparams = inputData.getBussinessParams().getRowParams(0);
        int portID = -1;
        if (rowparams.getParam("port") != null && rowparams.getParam("port").getValue() != null) {
            portID = Integer.parseInt(rowparams.getParam("port").getValue());
        }
        if (!otnModelInstance.isSupportSimpleModePort(boardType, portID)) {
            return;
        }
        int nmPath = 1;
        if (rowparams.getParam("path") != null && rowparams.getParam("path").getValue() != null && (nmPath = Integer.parseInt(rowparams.getParam("path").getValue())) == 65537) {
            rowparams.getParam("path").setValue(String.valueOf("1"));
        }
        int layer = otnModelInstance.getLayerFromAttrID(operName);
        if (grade != -1 && layer != -1 && (nePath = otnModelInstance.getNePath(layer, grade, nmPath, boardType)) != -1) {
            rowparams.getParam("path").setValue(String.valueOf(nePath));
        }
    }

    public static int getNePath(int neID, int slotID, int nmPath) {
        int boardType;
        TEOTNModelDataMgr otnModelMgr = TEOTNModelDataMgr.getInstance();
        int nepath = otnModelMgr.getNePath(nmPath, boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID));
        if (nepath == -1) {
            nepath = nmPath;
        }
        return nepath;
    }

    private List<Operation> getAttrOperationList_NoLock(TEGenAttrObjectValue genAttrValue, String operationType, TEGenCfgFunCmd funCmd, TEGenValue genValue) {
        TEGenCfgFunAttr funAttr = funCmd.getGenCfgFunAttr(genValue.getAttrName(), operationType);
        if (funAttr == null) {
            TELogFactory.getNormalLogger().info("Get attr(" + genValue.getAttrName() + ") for" + operationType + " TEGenCfgFunAttr failed!");
            return null;
        }
        ArrayList<String> operationNameList = new ArrayList<String>();
        String operationName = funAttr.getPtcode();
        operationNameList.add(operationName);
        String additioncmd = funAttr.getAdditionCmd();
        if (null != additioncmd && !"".equals(additioncmd.trim())) {
            operationNameList.add(additioncmd);
        }
        Datainterface inputData = new Datainterface();
        ArrayList groupAttrList = funAttr.getGroupAttrList();
        inputData = groupAttrList.size() > 0 ? this.getAttrDatainterface(genValue.getAttrID(), groupAttrList, genAttrValue) : this.getAttrDatainterface(genValue.getAttrID(), genAttrValue);
        this.handleNewOTNPath(genAttrValue.getNEID(), operationName, inputData);
        return TEGenCfgDataConvertor.convertToOperation_NoLock((TEGenCfgFunAttr)funAttr, (Datainterface)inputData, (int)genAttrValue.getNEID(), operationNameList);
    }

    private TEGenAttrObjectValue getGenGroupAttrObjValue(TEGenAttrObjectValue curAttrObj, List<TEGenAttrObjectValue> attrList, ArrayList groupAttrList) {
        TEGenValue genValue;
        String attrName;
        int i;
        TEGenAttrObjectValue groupAttrObj = curAttrObj.clone();
        int size = groupAttrList.size();
        for (i = 0; i < size; ++i) {
            attrName = (String)groupAttrList.get(i);
            for (TEGenAttrObjectValue attrValue : attrList) {
                genValue = (TEGenValue)attrValue.getAttrIDList().get(0);
                if (!attrValue.getObjectID().equals((Object)curAttrObj.getObjectID()) || !genValue.getAttrName().equals(attrName) || groupAttrObj.getAttrIDList().contains(genValue)) continue;
                groupAttrObj.getAttrIDList().add(genValue);
            }
        }
        size = groupAttrList.size();
        for (i = 0; i < size; ++i) {
            attrName = (String)groupAttrList.get(i);
            for (int j = attrList.size() - 1; j >= 0; --j) {
                TEGenAttrObjectValue attrValue;
                attrValue = attrList.get(j);
                genValue = (TEGenValue)attrValue.getAttrIDList().get(0);
                if (!attrValue.getObjectID().equals((Object)curAttrObj.getObjectID()) || !genValue.getAttrName().equals(attrName) || curAttrObj.getAttrIDList().contains(genValue)) continue;
                attrValue.setNeedSetToNE(false);
            }
        }
        return groupAttrObj;
    }
}

