/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.fiber;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.util.ArrayList;

public class TEQueryReferFiberBean
extends TENEExplorerBean {
    private static final int SRC_FLAG = 0;
    private static final int SNK_FLAG = 1;
    private static final int WDM_LEVEL = 1;
    private static final int SINGLE_DIRECTION = 1;

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(38662);
        errorCodeList.add(41523);
        return errorCodeList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = this.outputData.getBussinessParams().getRowParams(i);
            if (row.getRowErrorsCount() > 0) continue;
            int srcneid = Integer.parseInt(row.getParam("srcNE").getValue());
            int srcslotid = Integer.parseInt(row.getParam("srcSlot").getValue());
            int srcportid = Integer.parseInt(row.getParam("srcPort").getValue());
            row.addParam("srcNEName", this.getNEName(srcneid));
            row.addParam("srcSelfName", TEBoardUtil.getSubrackNameFromSlot((int)srcneid, (int)srcslotid));
            row.addParam("srcBoardName", TEConfigurationDataMgr.getInstance().getBoardName(srcneid, srcslotid));
            row.addParam("srcPortName", this.convertPortName(srcneid, srcslotid, srcportid, 0));
            int snkneid = Integer.parseInt(row.getParam("snkNE").getValue());
            int snkslotid = Integer.parseInt(row.getParam("snkSlot").getValue());
            int snkportid = Integer.parseInt(row.getParam("snkPort").getValue());
            row.addParam("snkNEName", this.getNEName(snkneid));
            row.addParam("snkSelfName", TEBoardUtil.getSubrackNameFromSlot((int)snkneid, (int)snkslotid));
            row.addParam("snkBoardName", TEConfigurationDataMgr.getInstance().getBoardName(snkneid, snkslotid));
            row.addParam("snkPortName", this.convertPortName(snkneid, snkslotid, snkportid, 1));
            row.addParam("level", String.valueOf(1));
            row.addParam("direction", String.valueOf(1));
        }
    }

    private String getNEName(int neid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        String result = ne == null ? "NE(" + neid / 65536 + "-" + neid % 65536 + ")" : ne.getNEName();
        return result;
    }

    private String convertPortName(int neid, int slotid, int portid, int srcOrSnk) {
        TEPortParaRecord portParaRecord;
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        String result = String.valueOf(portid);
        String portName = "(UNKNOWN)";
        if (boardType != -1 && null != (portParaRecord = TEConfigurationDataMgr.getInstance().getPortParaRecord(neid, boardType, portid))) {
            switch (srcOrSnk) {
                case 0: {
                    portName = "(" + portParaRecord.outName + ")";
                    break;
                }
                case 1: {
                    portName = "(" + portParaRecord.inName + ")";
                    break;
                }
            }
        }
        return result + portName;
    }
}

