/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.fiber;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.util.ArrayList;

public class TEQueryFiberBean
extends TENEExplorerBean {
    private static final int SRC_FLAG = 0;
    private static final int SNK_FLAG = 1;
    private static final int WDM_LEVEL = 1;
    private static final int SINGLE_DIRECTION = 1;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams rowtemp = this.outputData.getBussinessParams().getRowParams(i);
            if (rowtemp.getRowErrorsCount() > 0) continue;
            int srcneid = Integer.parseInt(rowtemp.getParam("srcNE").getValue());
            int srcslotid = Integer.parseInt(rowtemp.getParam("srcSolt").getValue());
            int srcportid = Integer.parseInt(rowtemp.getParam("srcPort").getValue());
            rowtemp.addParam("srcNEName", this.getNEName(srcneid));
            rowtemp.addParam("srcSlot", rowtemp.getParam("srcSolt").getValue());
            rowtemp.addParam("srcSelfName", TEBoardUtil.getSubrackNameFromSlot((int)srcneid, (int)srcslotid));
            rowtemp.addParam("srcBoardName", TEConfigurationDataMgr.getInstance().getBoardName(srcneid, srcslotid));
            rowtemp.addParam("srcPortName", this.convertPortName(srcneid, srcslotid, srcportid, 0));
            int snkneid = Integer.parseInt(rowtemp.getParam("snkNE").getValue());
            int snkslotid = Integer.parseInt(rowtemp.getParam("snkSolt").getValue());
            int snkportid = Integer.parseInt(rowtemp.getParam("snkPort").getValue());
            rowtemp.addParam("snkNEName", this.getNEName(snkneid));
            rowtemp.addParam("snkSlot", rowtemp.getParam("snkSolt").getValue());
            rowtemp.addParam("snkSelfName", TEBoardUtil.getSubrackNameFromSlot((int)snkneid, (int)snkslotid));
            rowtemp.addParam("snkBoardName", TEConfigurationDataMgr.getInstance().getBoardName(snkneid, snkslotid));
            rowtemp.addParam("snkPortName", this.convertPortName(snkneid, snkslotid, snkportid, 1));
            rowtemp.addParam("level", String.valueOf(1));
            rowtemp.addParam("direction", String.valueOf(1));
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(new Integer(38662));
        return errorCodeList;
    }

    private String getNEName(int neid) {
        TENE nefiber = TENEListMgr.getInstance().getNE(neid);
        String result = nefiber == null ? "NE(" + neid / 65536 + "-" + neid % 65536 + ")" : nefiber.getNEName();
        return result;
    }

    private String convertPortName(int neid, int slotid, int portid, int srcOrSnk) {
        TEPortParaRecord portParaRecord;
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        String resultfiber = String.valueOf(portid);
        String portNamefiber = "(UNKNOWN)";
        if (boardType != -1 && null != (portParaRecord = TEConfigurationDataMgr.getInstance().getPortParaRecord(neid, boardType, portid))) {
            switch (srcOrSnk) {
                case 0: {
                    portNamefiber = "(" + portParaRecord.outName + ")";
                    break;
                }
                case 1: {
                    portNamefiber = "(" + portParaRecord.inName + ")";
                    break;
                }
            }
        }
        return resultfiber + portNamefiber;
    }
}

