/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.fiber;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ngwdm.fiber.TEFiberPort;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TECreateFiberPreBean
extends TENEExplorerBean {
    private static final String filename = "stringresource_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private static final String PAKAGE_PATH = "ngwdm" + File.separator + "res" + File.separator + filename;
    private final TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private List usedSrcPortList = new ArrayList();
    private List usedSnkPortList = new ArrayList();
    private List srcPortList = new ArrayList();
    private List snkPortList = new ArrayList();
    private static final int PORT_ODU0_BASE = 160;
    private List sdhBoardList = new ArrayList();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int result;
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.sdhBoardList.add(588);
        this.sdhBoardList.add(723);
        this.sdhBoardList.add(724);
        this.sdhBoardList.add(1039);
        this.sdhBoardList.add(1557);
        this.sdhBoardList.add(1576);
        this.sdhBoardList.add(1577);
        this.sdhBoardList.add(1578);
        this.sdhBoardList.add(1579);
        this.sdhBoardList.add(2048);
        this.sdhBoardList.add(2049);
        this.sdhBoardList.add(2051);
        this.sdhBoardList.add(2052);
        this.sdhBoardList.add(826);
        this.sdhBoardList.add(940);
        this.sdhBoardList.add(1173);
        this.sdhBoardList.add(1149);
        this.outputData = new Datainterface();
        this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
        if (null != this.operationList && this.operationList.size() > 0 && ((result = this.sendMessage(neid)) == 0 || result == 1)) {
            this.handleMessage(neid, this.operationList, subFunc);
        }
        this.getAvaliableRes();
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        if (null != operationList && operationList.size() > 0) {
            int len = operationList.size();
            for (int i = 0; i < len; ++i) {
                Operation operation = (Operation)operationList.get(i);
                TEDataConverter.handleSpecialStr((Operation)operation);
                int size = operation.getOutputCount();
                for (int row = 0; row < size; ++row) {
                    Output output = operation.getOutput(row);
                    if (null == output) continue;
                    boolean flag = true;
                    int errorCount = output.getFaultCount();
                    for (int err = 0; err < errorCount; ++err) {
                        if (output.getFault(err).getCode().equals(String.valueOf(0))) continue;
                        flag = false;
                        break;
                    }
                    if (!flag) continue;
                    for (int tmpCol = output.getPartCount() - 1; tmpCol >= 0; --tmpCol) {
                        int snkNeId;
                        int srcNeId;
                        if (null != output.getPartValue("srcNE") && !"".equals(output.getPartValue("srcNE")) && (srcNeId = Integer.parseInt(output.getPartValue("srcNE"))) == neid) {
                            String usedSrcPort = output.getPartValue("srcSolt") + "-" + output.getPartValue("srcPort");
                            this.usedSrcPortList.add(usedSrcPort);
                        }
                        if (null == output.getPartValue("snkNE") || "".equals(output.getPartValue("snkNE")) || (snkNeId = Integer.parseInt(output.getPartValue("snkNE"))) != neid) continue;
                        String usedSnkPort = output.getPartValue("snkSolt") + "-" + output.getPartValue("snkPort");
                        this.usedSnkPortList.add(usedSnkPort);
                    }
                }
            }
        }
    }

    private void getAvaliableRes() {
        this.operationList = new ArrayList();
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_SUBBDTYPE");
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse Qx description file fail!", (Throwable)e);
        }
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)PAKAGE_PATH);
        String fiberLevel = resourceUtil.getString("fiberlevel");
        String fiberDirection = resourceUtil.getString("fiberdirection");
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        String neName = ne.getNEName();
        Vector boardList = ne.getClonedBoardList();
        if (boardList != null) {
            if (boardList.size() > 0) {
                int m = boardList.size();
                for (int i = 0; i < m; ++i) {
                    TEBoard board = (TEBoard)boardList.get(i);
                    int board_solt = board.getSlotID();
                    int boardType = board.getBoardType();
                    boolean ifSDHBoard = TEConfigurationDataMgr.getInstance().isSDHLineBoard(this.neid, board_solt);
                    if (ifSDHBoard && !TEVirtualPortUtil.isMSOTNBoard((int)this.neid, (int)board_solt)) continue;
                    if (1095 == boardType && null != oper) {
                        Input input = oper.getInput();
                        Part part = input.getPart("slotid");
                        part.setValue(String.valueOf(board_solt));
                        this.operationList.add(oper.clone());
                    }
                    List portTypeList = this.mgr.getBoardPortTypeList(this.neid, boardType);
                    ArrayList logicPortList = this.mgr.getLogicPortList(this.neid, board_solt);
                    if (portTypeList == null || portTypeList.size() <= 0) continue;
                    int n = portTypeList.size();
                    for (int j = 0; j < n; ++j) {
                        Integer port = (Integer)portTypeList.get(j);
                        List portList = this.mgr.getPortListFromPortType(this.neid, boardType, port.intValue());
                        int nn = portList.size();
                        block9: for (int jj = 0; jj < nn; ++jj) {
                            int portNo = (Integer)portList.get(jj);
                            if (this.mgr.isDynPort(this.neid, boardType, portNo) && !logicPortList.contains(portList.get(jj))) continue;
                            int portUsage = this.mgr.getPortUsage(this.neid, boardType, port.intValue(), portNo);
                            String slot_port = board_solt + "-" + portNo;
                            switch (portUsage) {
                                case 0: {
                                    if (!this.usedSrcPortList.contains(slot_port)) {
                                        this.addSrcPort(this.neid, board, portNo);
                                    }
                                    if (this.usedSnkPortList.contains(slot_port)) continue block9;
                                    this.addSnkPort(this.neid, board, portNo);
                                    continue block9;
                                }
                                case 3: {
                                    if (this.usedSrcPortList.contains(slot_port)) continue block9;
                                    this.addSrcPort(this.neid, board, portNo);
                                    continue block9;
                                }
                                case 2: {
                                    if (this.usedSnkPortList.contains(slot_port)) continue block9;
                                    this.addSnkPort(this.neid, board, portNo);
                                    continue block9;
                                }
                            }
                        }
                    }
                }
            }
            this.dealWithToEcom();
            Collections.sort(this.srcPortList);
            Collections.sort(this.snkPortList);
            Datainterface output = new Datainterface();
            output.setBussinessParams(new BussinessParams());
            RowParams comRowParams = new RowParams();
            Param comParam = new Param("nename", neName);
            comRowParams.addParam(comParam);
            comParam = new Param("fiberlevel", fiberLevel);
            comRowParams.addParam(comParam);
            comParam = new Param("fiberdirection", fiberDirection);
            comRowParams.addParam(comParam);
            output.getBussinessParams().addRowParams(0, comRowParams);
            TEFiberPort fiberPort = null;
            Option option = null;
            RowParams rowParams = new RowParams();
            Param srcParam = new Param("srcPort", "");
            Param slotPort = new Param("srcslotport", "");
            if (this.srcPortList.size() > 0) {
                fiberPort = (TEFiberPort)this.srcPortList.get(0);
                srcParam.setValue(fiberPort.name);
                slotPort.setValue(fiberPort.slotId + "-" + fiberPort.portId);
                int mn = this.srcPortList.size();
                for (int k = 1; k < mn; ++k) {
                    fiberPort = (TEFiberPort)this.srcPortList.get(k);
                    option = new Option(fiberPort.name);
                    srcParam.addOption(option);
                    option = new Option(fiberPort.slotId + "-" + fiberPort.portId);
                    slotPort.addOption(option);
                }
            }
            rowParams.addParam(srcParam);
            rowParams.addParam(slotPort);
            Param snkParam = new Param("snkPort", "");
            slotPort = new Param("snkslotport", "");
            if (this.snkPortList.size() > 0) {
                fiberPort = (TEFiberPort)this.snkPortList.get(0);
                snkParam.setValue(fiberPort.name);
                slotPort.setValue(fiberPort.slotId + "-" + fiberPort.portId);
                int mn = this.snkPortList.size();
                for (int kk = 1; kk < mn; ++kk) {
                    fiberPort = (TEFiberPort)this.snkPortList.get(kk);
                    option = new Option(fiberPort.name);
                    snkParam.addOption(option);
                    option = new Option(fiberPort.slotId + "-" + fiberPort.portId);
                    slotPort.addOption(option);
                }
            }
            rowParams.addParam(snkParam);
            rowParams.addParam(slotPort);
            output.getBussinessParams().addRowParams(1, rowParams);
            this.outputData = output;
            this.usedSrcPortList.clear();
            this.usedSrcPortList = null;
            this.usedSnkPortList.clear();
            this.usedSnkPortList = null;
            this.srcPortList.clear();
            this.srcPortList = null;
            this.snkPortList.clear();
            this.snkPortList = null;
        }
    }

    private void addSrcPort(int neid, TEBoard board, int portNo) {
        TEFiberPort fiberPort = new TEFiberPort();
        fiberPort.slotId = board.getSlotID();
        fiberPort.portId = portNo;
        TEPortParaRecord portParaRecord = this.mgr.getPortParaRecord(neid, board.getBoardType(), portNo);
        if (portParaRecord != null) {
            if (portParaRecord.outName != null) {
                if (portNo > 160) {
                    return;
                }
                fiberPort.name = this.getPortName(board.getSlotID(), board.getBoardTypeName(), portNo, "(" + portParaRecord.outName + ")");
                this.srcPortList.add(fiberPort);
            }
        } else {
            fiberPort.name = this.getPortName(board.getSlotID(), board.getBoardTypeName(), portNo, "(UNKNOWN)");
            if (this.sdhBoardList.contains(board.getBoardType()) || TESpecialAttrMgr.getInstance().isCPSupportByType(board.getBoardType(), "TECMDCODE_SONET_DEL_ENV_ITEMS", "OTN_ATTR_SUPPORT_SDHPORTNAME_SELF")) {
                fiberPort.name = this.getPortName(board.getSlotID(), board.getBoardTypeName(), portNo, "(SDH-" + portNo + ")");
            }
            this.srcPortList.add(fiberPort);
        }
    }

    private String getPortName(int slotid, String boardName, int portNo, String portName) {
        String name = "";
        String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid);
        name = !subrackname.equals("") ? subrackname + "-" + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotid) + "-" : slotid + "-";
        name = name + boardName + "-" + portNo + portName;
        return name;
    }

    private void addSnkPort(int neid, TEBoard board, int portNo) {
        TEFiberPort fiberPort = new TEFiberPort();
        fiberPort.slotId = board.getSlotID();
        fiberPort.portId = portNo;
        TEPortParaRecord portParaRecord = this.mgr.getPortParaRecord(neid, board.getBoardType(), portNo);
        if (portParaRecord != null) {
            if (portParaRecord.inName != null) {
                if (portNo > 160) {
                    return;
                }
                fiberPort.name = this.getPortName(board.getSlotID(), board.getBoardTypeName(), portNo, "(" + portParaRecord.inName + ")");
                this.snkPortList.add(fiberPort);
            }
        } else {
            fiberPort.name = this.getPortName(board.getSlotID(), board.getBoardTypeName(), portNo, "(UNKNOWN)");
            if (this.sdhBoardList.contains(board.getBoardType()) || TESpecialAttrMgr.getInstance().isCPSupportByType(board.getBoardType(), "TECMDCODE_SONET_DEL_ENV_ITEMS", "OTN_ATTR_SUPPORT_SDHPORTNAME_SELF")) {
                fiberPort.name = this.getPortName(board.getSlotID(), board.getBoardTypeName(), portNo, "(SDH-" + portNo + ")");
            }
            this.snkPortList.add(fiberPort);
        }
    }

    private void dealWithToEcom() {
        int result;
        int SERVICE_MODE = 161;
        ArrayList<TEFiberPort> deleteResList = new ArrayList<TEFiberPort>();
        if (null != this.operationList && this.operationList.size() > 0 && 0 == (result = this.sendMessage(this.neid))) {
            TEFiberPort fiberPort = null;
            int m = this.operationList.size();
            for (int i = 0; i < m; ++i) {
                int boardMode;
                Operation operation = (Operation)this.operationList.get(i);
                Output output = operation.getOutput(0);
                if (!output.getFault(0).getCode().equals("0") || 161 != (boardMode = Integer.parseInt(output.getPartValue("W32BD_ATTR_SUBBDTYPE")))) continue;
                fiberPort = new TEFiberPort();
                fiberPort.slotId = Integer.parseInt(output.getPartValue("slotid"));
                fiberPort.portId = 1;
                deleteResList.add(fiberPort);
            }
        }
        this.srcPortList.removeAll(deleteResList);
        this.snkPortList.removeAll(deleteResList);
    }
}

