/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.fiber;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TECreateFiberBean
extends TENEExplorerBean {
    private static Logger log = TELogFactory.getNormalLogger();
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String STRING_SOURCE = "ngwdm" + File.separator + "res" + File.separator + "stringresource_" + LANGUAGE + ".ini";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        ArrayList errorData = this.getErrorData(neid, operationList);
        Operation operation = null;
        if (null == operationList || 0 == operationList.size()) {
            return;
        }
        RowParams rowparams = null;
        Output output = null;
        boolean succ = false;
        boolean fault = false;
        boolean row_succ = false;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        operation = (Operation)operationList.get(0);
        TEDataConverter.handleSpecialStr((Operation)operation);
        if (operation.getOutputCount() == 0) {
            succ = true;
        }
        int size = operation.getOutputCount();
        for (int row = 0; row < size; ++row) {
            output = operation.getOutput(row);
            row_succ = TEDataConverter.handleRowError((Output)output, null);
            if (row_succ) {
                succ = true;
                int n = output.getFaultCount();
                for (int j = 0; j < n; ++j) {
                    String errorCode = output.getFault(j).getCode();
                    if (Integer.parseInt(errorCode) == 0) continue;
                    fault = true;
                    break;
                }
            }
            row_succ = false;
        }
        if (null != errorData && 0 != errorData.size()) {
            fault = true;
            rowparams = new RowParams();
            size = errorData.size();
            for (int i = 0; i < size; ++i) {
                rowparams.addRowErrors((RowErrors)errorData.get(i));
            }
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
        this.outputData.setErrorMessage(new ErrorMessage());
        if (succ && !fault) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!succ && fault) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
    }

    private ArrayList getErrorData(int neid, ArrayList operationList) {
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        Operation operation = null;
        Output curOutput = null;
        int faultCode = 0;
        if (null == operationList || 0 == operationList.size()) {
            return errorDataList;
        }
        operation = (Operation)operationList.get(0);
        int ouputlen = operation.getOutputCount();
        for (int i = 0; i < ouputlen; ++i) {
            curOutput = operation.getOutput(i);
            faultCode = Integer.parseInt(curOutput.getFault(0).getCode());
            if (0 == faultCode) continue;
            errorDataList.add(this.handleErrorData(neid, curOutput));
        }
        return errorDataList;
    }

    private RowErrors handleErrorData(int neid, Output output) {
        RowParams rowParams;
        String errorCode = "";
        String errorinfo = "";
        errorCode = output.getFault(0).getCode();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        if (!errorCode.equals("")) {
            errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errorCode)));
        } else {
            errorMessage.setErrorinfo(errorinfo);
        }
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param("neid", String.valueOf(neid));
        rowError.addParam(errorparam);
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        if (null != rowError.getParam("neid")) {
            errorparam = new Param("nename", neObj.getNEName());
            rowError.addParam(errorparam);
        }
        if (null != (rowParams = this.inputData.getBussinessParams().getRowParams(0)).getParam("source")) {
            errorparam = rowParams.getParam("source");
            rowError.addParam(errorparam);
        }
        if (null != rowParams.getParam("sink")) {
            errorparam = rowParams.getParam("sink");
            rowError.addParam(errorparam);
        }
        return rowError;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        try {
            int i;
            if (outputData.getErrorMessage().getErrorcode().equals(String.valueOf(1090646019))) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(subfunc.getCode());
            loginfo.setLocation(ipAddress);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateObject("");
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (null == neObj) {
                loginfo.setOperateObject(String.valueOf(neid));
            } else {
                loginfo.setOperateObject(neObj.getNEName());
            }
            String desc = subfunc.getSubFuncDes(neid);
            loginfo.setOperateName(desc);
            RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
            String source = rowParams.getParam("source").getValue();
            String sink = rowParams.getParam("sink").getValue();
            desc = desc + "," + resourceUtil.getString("source") + "[" + loginfo.getOperateObject() + "-" + source + "]," + resourceUtil.getString("sink") + "[" + loginfo.getOperateObject() + "-" + sink + "]";
            loginfo.setOperateDesc(desc);
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 0) {
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo);
            } else {
                loginfo.setResult(2);
                if (errorCode == 1090646019) {
                    return;
                }
                if (errorCode == 2 || errorCode == 1) {
                    if (null == outputData.getBussinessParams() || outputData.getBussinessParams().getRowParamsCount() == 0) {
                        loginfo.setErrCode(errorCode);
                    }
                    int len = outputData.getBussinessParams().getRowParamsCount();
                    for (i = 0; i < len; ++i) {
                        RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                        int size = rowErrors.length;
                        for (int j = 0; j < size; ++j) {
                            loginfo.setErrCode(Integer.parseInt(rowErrors[i].getErrorMessage().getErrorcode()));
                            loginfo.setErrInfo(rowErrors[i].getErrorMessage().getErrorinfo());
                            loginfoList.add(loginfo);
                        }
                    }
                } else {
                    loginfo.setErrCode(errorCode);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                    loginfoList.add(loginfo);
                }
            }
            int size = loginfoList.size();
            for (i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            log.error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    public boolean isNeedOperationlog() {
        return true;
    }
}

