/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.fc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEFCServiceTestBean
extends TENEExplorerBean {
    private static final int INVALID_SUBSOLTID = 255;
    private static final int ZERO_SUBSOLTID = 0;
    private static final String VERIFY_FAILED = "42293";
    private static final int MAINITEM = 1;
    private static final String ITEMTYPE = "ITEMTYPE";
    private static final String TXFRAME = "TXFRAME";
    private static final String RXFRAME = "RXFRAME";
    private static final String TXERROR = "TXERROR";
    private static final String RXERROR = "RXERROR";
    private static final String RXOTHERFRAME = "RXOTHERFRAME";
    private static final String RXOVERFRAME = "RXOVERFRAME";
    private static final String TXCREDIT = "TXCREDIT";
    private static final String TXUTIL = "TXUTIL";
    private static final String RXUTIL = "RXUTIL";
    private static final String RTTDELAY = "RTTDELAY";
    private static final String LINKFAIL = "LINKFAIL";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEFCServiceTestBean.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList);
    }

    public static Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        ArrayList errorData = TEDataConverter.joinOperation((int)neid, (SubFunc)subfunc, (ArrayList)operationList, filterErrorCodeList);
        Operation operation = null;
        if (null == operationList || 0 == operationList.size()) {
            return null;
        }
        RowParams rowparams = null;
        Input input = null;
        Output output = null;
        boolean succ = false;
        boolean fault = false;
        boolean row_succ = false;
        boolean verify_succ = true;
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        int len = operationList.size();
        block0: for (int i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            TEDataConverter.handleSpecialStr((Operation)operation);
            input = operation.getInput();
            if (operation.getOutputCount() == 0) {
                succ = true;
            }
            int size = operation.getOutputCount();
            for (int row = 0; row < size; ++row) {
                output = operation.getOutput(row);
                rowparams = new RowParams();
                row_succ = TEDataConverter.handleRowError((Output)output, filterErrorCodeList);
                if (row_succ) {
                    succ = true;
                    boolean flag = false;
                    int errorSize = output.getFaultCount();
                    for (int a = 0; a < errorSize; ++a) {
                        if (filterErrorCodeList.contains(Integer.valueOf(output.getFault(a).getCode()))) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue block0;
                    TEFCServiceTestBean.handleRowData(neid, subfunc, rowparams, input, output);
                    flag = false;
                } else if (1 == operation.getOutputCount()) {
                    boolean hasDefault = true;
                    int count = operation.getOutput(0).getPartCount();
                    for (int index = 0; index < count; ++index) {
                        if (operation.getOutput(0).getPart(index).hasDefault()) continue;
                        hasDefault = false;
                        break;
                    }
                    if (hasDefault) {
                        TEFCServiceTestBean.handleRowData(neid, subfunc, rowparams, input, output);
                    }
                }
                if (0 != rowparams.getParamCount()) {
                    outputData.getBussinessParams().addRowParams(rowparams);
                }
                row_succ = false;
            }
        }
        if (null != errorData && 0 != errorData.size()) {
            fault = true;
            rowparams = new RowParams();
            RowErrors rErrors = null;
            int size = errorData.size();
            for (int i = 0; i < size; ++i) {
                rErrors = (RowErrors)errorData.get(i);
                rowparams.addRowErrors(rErrors);
                if (!rErrors.getErrorMessage().getErrorcode().equals(VERIFY_FAILED)) continue;
                verify_succ = false;
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (succ && !fault) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!succ && fault || !verify_succ) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        return outputData;
    }

    public static final int readPositiveLong(byte[] b, int offset) {
        int ch1 = IOStreamConvertor.readChar((byte)b[0 + offset]);
        int ch2 = IOStreamConvertor.readChar((byte)b[1 + offset]);
        int ch3 = IOStreamConvertor.readChar((byte)b[2 + offset]);
        int ch4 = IOStreamConvertor.readChar((byte)b[3 + offset]);
        int ch5 = IOStreamConvertor.readChar((byte)b[4 + offset]);
        int ch6 = IOStreamConvertor.readChar((byte)b[5 + offset]);
        int ch7 = IOStreamConvertor.readChar((byte)b[6 + offset]);
        int ch8 = IOStreamConvertor.readChar((byte)b[7 + offset]);
        int ch9 = IOStreamConvertor.readChar((byte)b[8 + offset]);
        int ch10 = IOStreamConvertor.readChar((byte)b[9 + offset]);
        int ch11 = IOStreamConvertor.readChar((byte)b[10 + offset]);
        int ch12 = IOStreamConvertor.readChar((byte)b[11 + offset]);
        int ch13 = IOStreamConvertor.readChar((byte)b[12 + offset]);
        int ch14 = IOStreamConvertor.readChar((byte)b[13 + offset]);
        int ch15 = IOStreamConvertor.readChar((byte)b[14 + offset]);
        int ch16 = IOStreamConvertor.readChar((byte)b[15 + offset]);
        return (ch1 << 60) + (ch2 << 56) + (ch3 << 52) + (ch4 << 48) + (ch5 << 44) + (ch6 << 40) + (ch7 << 36) + (ch8 << 32) + (ch9 << 28) + (ch10 << 24) + (ch11 << 20) + (ch12 << 16) + (ch13 << 12) + (ch14 << 8) + (ch15 << 4) + (ch16 << 0);
    }

    public static void handleRowData(int neid, SubFunc subfunc, RowParams rowparams, Input input, Output output) {
        Param tmp;
        String tmpValue = "";
        String tmpName = "";
        TENE neObj = null;
        int curNEid = neid;
        Param param = null;
        int len = subfunc.getOutput().getParamCount();
        for (int col = 0; col < len; ++col) {
            int tmpCol;
            param = new Param(subfunc.getOutput().getParam(col).getName(), "");
            if ("neid".equalsIgnoreCase(param.getName())) {
                param.setValue(String.valueOf(neid));
            }
            for (tmpCol = input.getPartCount() - 1; tmpCol >= 0; --tmpCol) {
                tmpName = input.getPart(tmpCol).getName();
                if (!tmpName.equalsIgnoreCase(param.getName())) continue;
                tmpValue = input.getPart(tmpCol).getValue();
                if (null != tmpValue) {
                    param.setValue(tmpValue);
                }
                input.removePart(input.getPart(tmpCol));
                break;
            }
            for (tmpCol = output.getPartCount() - 1; tmpCol >= 0; --tmpCol) {
                tmpName = output.getPart(tmpCol).getName();
                if (!tmpName.equalsIgnoreCase(param.getName())) continue;
                tmpValue = output.getPart(tmpCol).getValue();
                if (null != tmpValue) {
                    param.setValue(tmpValue);
                }
                output.removePart(output.getPart(tmpCol));
                break;
            }
            rowparams.addParam(param);
        }
        String itemValue = output.getPart("itemvalue").getValue();
        Param type = new Param();
        type.setName(ITEMTYPE);
        type.setValue(output.getPart("itemtype").getValue());
        rowparams.addParam(type);
        if (Integer.parseInt(output.getPart("itemtype").getValue()) == 1) {
            tmp = new Param();
            tmp.setName(TXFRAME);
            tmp.setValue(Integer.toString(TEFCServiceTestBean.readPositiveLong(itemValue.getBytes(), 0)));
            rowparams.addParam(tmp);
            tmp = new Param();
            tmp.setName(RXFRAME);
            tmp.setValue(Integer.toString(TEFCServiceTestBean.readPositiveLong(itemValue.getBytes(), 16)));
            rowparams.addParam(tmp);
            tmp = new Param();
            tmp.setName(TXERROR);
            tmp.setValue(Integer.toString(TEFCServiceTestBean.readPositiveLong(itemValue.getBytes(), 32)));
            rowparams.addParam(tmp);
            tmp = new Param();
            tmp.setName(RXERROR);
            tmp.setValue(Integer.toString(TEFCServiceTestBean.readPositiveLong(itemValue.getBytes(), 48)));
            rowparams.addParam(tmp);
        } else {
            tmp = new Param();
            tmp.setName(RXOTHERFRAME);
            tmp.setValue(Integer.toString(TEFCServiceTestBean.readPositiveLong(itemValue.getBytes(), 0)));
            rowparams.addParam(tmp);
            tmp = new Param();
            tmp.setName(RXOVERFRAME);
            tmp.setValue(Integer.toString(TEFCServiceTestBean.readPositiveLong(itemValue.getBytes(), 16)));
            rowparams.addParam(tmp);
            tmp = new Param();
            tmp.setName(TXCREDIT);
            tmp.setValue(Integer.toString(IOStreamConvertor.readPositiveInt((byte[])itemValue.getBytes(), (int)32)));
            rowparams.addParam(tmp);
            tmp = new Param();
            tmp.setName(TXUTIL);
            tmp.setValue(Integer.toString(IOStreamConvertor.readPositiveShort((byte[])itemValue.getBytes(), (int)36)));
            rowparams.addParam(tmp);
            tmp = new Param();
            tmp.setName(RXUTIL);
            tmp.setValue(Integer.toString(IOStreamConvertor.readPositiveShort((byte[])itemValue.getBytes(), (int)38)));
            rowparams.addParam(tmp);
            tmp = new Param();
            tmp.setName(RTTDELAY);
            tmp.setValue(Integer.toString(IOStreamConvertor.readPositiveInt((byte[])itemValue.getBytes(), (int)40)));
            rowparams.addParam(tmp);
            tmp = new Param();
            tmp.setName(LINKFAIL);
            tmp.setValue(Integer.toString(IOStreamConvertor.readPositiveInt((byte[])itemValue.getBytes(), (int)44)));
            rowparams.addParam(tmp);
        }
        if (null != output.getPart("neid")) {
            curNEid = Integer.parseInt(output.getPart("neid").getValue());
        } else if (null != input.getPart("neid")) {
            curNEid = Integer.parseInt(input.getPart("neid").getValue());
        }
        neObj = TENEListMgr.getInstance().getNE(curNEid);
        int slotid = 0;
        int subslotid = 0;
        int boardtype = 0;
        int subboardtype = 0;
        int port = 0;
        if (null != rowparams.getParam("neid")) {
            param = new Param("nename", neObj.getNEName());
            rowparams.addParam(param);
        }
        if (null != rowparams.getParam("slotid")) {
            try {
                slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                port = -1;
            }
            if (null != rowparams.getParam("boardtype")) {
                try {
                    boardtype = Integer.parseInt(rowparams.getParam("boardtype").getValue());
                }
                catch (NumberFormatException e) {
                    boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                    rowparams.getParam("boardtype").setValue(boardtype + "");
                }
            } else {
                boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                param = new Param("boardtype", boardtype + "");
                rowparams.addParam(param);
            }
            param = new Param("boardname", TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype));
            rowparams.addParam(param);
        }
        if (null != rowparams.getParam("subslotid")) {
            try {
                subslotid = Integer.parseInt(rowparams.getParam("subslotid").getValue());
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                port = -1;
            }
            if (null != rowparams.getParam("subboardtype")) {
                try {
                    subboardtype = Integer.parseInt(rowparams.getParam("subboardtype").getValue());
                }
                catch (NumberFormatException e) {
                    subboardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, subboardtype);
                    rowparams.getParam("subboardtype").setValue(subboardtype + "");
                }
            } else {
                if (255 != subslotid && 0 != subslotid) {
                    try {
                        subboardtype = TEConfigurationDataMgr.getInstance().getSubboardType(neid, slotid, subslotid);
                    }
                    catch (Exception e) {
                        slotid = 255;
                        subslotid = 255;
                    }
                }
                param = new Param("subboardtype", subboardtype + "");
                rowparams.addParam(param);
            }
            String subboardname = "";
            if (255 != subslotid && 0 != subslotid) {
                subboardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, subboardtype);
            }
            param = new Param("subboardname", subboardname);
            rowparams.addParam(param);
        }
        if (null != rowparams.getParam("port")) {
            try {
                port = Integer.parseInt(rowparams.getParam("port").getValue());
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                port = -1;
            }
            String portname = "";
            portname = 255 != subslotid && 0 != subslotid ? TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, subboardtype, port) : TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, port);
            param = new Param("portname", portname);
            rowparams.addParam(param);
        }
    }
}

