/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.fault_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.nelist.model.alarm.TEBitErrorTh;
import com.huawei.nglct.nelist.model.alarm.TEPortBitErrorTh;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ngwdm.fault.TEBitErrThMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryBitErrorBean
extends TENEExplorerBean {
    private static final int TIME_OUT = 10;
    private int slotID = -1;
    private int boardType = -1;
    private ArrayList tEPortBitErrorThList = null;
    private TEBitErrThMgr tEBitErrThMgr = TEBitErrThMgr.getInstance();
    private Logger log = TELogFactory.getNormalLogger();
    private TEResourceUtil res = null;
    private static final String NE_NOT_LOGIN = "37926";
    HashMap bitErrorMap = new HashMap();
    boolean isBreanchBoard = false;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.neid = neid;
            this.outputData = new Datainterface();
            RowParams[] rParams = inputData.getBussinessParams().getRowParams();
            this.slotID = Integer.parseInt(rParams[0].getParam("slotID").getValue());
            this.boardType = Integer.parseInt(rParams[0].getParam("boardType").getValue());
            this.operationList = this.queryBitError(neid);
            if (null == this.operationList) {
                if (this.isNeedOperationlog()) {
                    this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
                }
                this.log.info("The operationlist is null!");
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
                return this.outputData;
            }
            int result = TENECommMgr.getInstance().sendCommand((int)neid, (List)this.operationList, (int)10).retCode;
            if (result == 0) {
                this.handleMessage(result);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            this.log.error("query bit error fail!", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            return this.outputData;
        }
        if (!this.outputData.getErrorMessage().getErrorcode().equals("0")) {
            BussinessParams bussiness = this.outputData.getBussinessParams();
            if (bussiness == null) {
                return this.outputData;
            }
            if (bussiness.getRowParamsCount() == 0) {
                return this.outputData;
            }
            RowParams rowparams = bussiness.getRowParams(bussiness.getRowParamsCount() - 1);
            RowErrors rowErrors = rowparams.getRowErrors(0);
            if (rowErrors.getErrorMessage().getErrorcode().equals(NE_NOT_LOGIN)) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_LOGIN)));
                for (int j = rowparams.getRowErrorsCount() - 1; j >= 0; --j) {
                    rowparams.removeRowErrors(rowparams.getRowErrors(j));
                }
            }
        }
        return this.outputData;
    }

    public void handleMessage(int result) {
        TENE ne_R8C01 = TENEListMgr.getInstance().getNE(this.neid);
        if (ne_R8C01.getLogStatus() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)37926));
            return;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)result));
        BussinessParams bParams_R8C01 = new BussinessParams();
        this.outputData.setBussinessParams(bParams_R8C01);
        ArrayList<TEPortBitErrorTh> BitErrorThList = new ArrayList<TEPortBitErrorTh>();
        int size = this.operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation oper_R8C01 = (Operation)this.operationList.get(i);
            if (!oper_R8C01.getOutput()[0].getFault()[0].getCode().equalsIgnoreCase(String.valueOf(0))) continue;
            Part[] parts_R8C01 = oper_R8C01.getOutput()[0].getPart();
            String PortID = "0";
            String PathID = "0";
            TEBitErrorTh bitError_R8C01 = new TEBitErrorTh();
            for (Part part : parts_R8C01) {
                String name_R8C01 = part.getName();
                String value = part.getValue();
                if (name_R8C01.equalsIgnoreCase("portID")) {
                    PortID = value;
                    continue;
                }
                if (name_R8C01.equalsIgnoreCase("pathID")) {
                    PathID = value;
                    continue;
                }
                if (name_R8C01.indexOf("biterr_type_") < 0) continue;
                int index = name_R8C01.lastIndexOf("_");
                bitError_R8C01.setThtype(new Integer(name_R8C01.substring(index + 1)).intValue());
                bitError_R8C01.setBitErrorvalue(value);
                String key = PortID + "-" + PathID;
                if (!this.bitErrorMap.containsKey(key)) continue;
                TEPortBitErrorTh tEPortBitErrorTh = (TEPortBitErrorTh)this.bitErrorMap.get(key);
                tEPortBitErrorTh.getBitErrorThList().add(bitError_R8C01.clone());
            }
        }
        for (TEPortBitErrorTh tEPortBitErrorTh : this.bitErrorMap.values()) {
            BitErrorThList.add(tEPortBitErrorTh);
        }
        Collections.sort(BitErrorThList);
        int port = 0;
        String nename_R8C01 = ne_R8C01.getNEName();
        String boardname_R8C01 = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, this.boardType);
        String portname = "";
        RowParams row = null;
        Param param = null;
        String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.slotID);
        if (!subrackname.equals("")) {
            nename_R8C01 = nename_R8C01 + "-" + subrackname;
        }
        String monObject = nename_R8C01 + "-" + TEBoardUtil.slotIDNEToNM((int)this.slotID) + "-" + boardname_R8C01 + "-";
        int size2 = BitErrorThList.size();
        for (int i = 0; i < size2; ++i) {
            TEPortBitErrorTh tEPortBitErrorTh = (TEPortBitErrorTh)BitErrorThList.get(i);
            port = tEPortBitErrorTh.getPortID();
            portname = TEConfigurationDataMgr.getInstance().getPortName(this.neid, this.slotID, this.boardType, port);
            row = tEPortBitErrorTh.toRowParams(this.isBreanchBoard);
            param = row.getParam("monObject");
            int pathID = tEPortBitErrorTh.getPathID();
            if (pathID != 0) {
                TEOTNModelDataMgr instance = TEOTNModelDataMgr.getInstance();
                if (instance.isSupportSimpleModePort(this.boardType, port)) {
                    int grade = instance.getGradeFromBoard(this.boardType);
                    int layer = 8;
                    int nmPath = TEOTNModelDataMgr.getInstance().getNmPath(layer, grade, pathID, this.boardType);
                    if (nmPath != -1) {
                        param.setValue(monObject + portname + "-" + TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(nmPath));
                    } else {
                        param.setValue(monObject + portname + "-" + pathID);
                    }
                } else {
                    param.setValue(monObject + portname + "-" + tEPortBitErrorTh.getPathID());
                }
            } else {
                param.setValue(monObject + portname);
            }
            bParams_R8C01.addRowParams(row);
        }
    }

    private ArrayList queryBitError(int neID) {
        this.operationList = new ArrayList();
        try {
            this.tEPortBitErrorThList = TEAlarmDataMgr.getInstance().getBITThList(this.boardType);
            Collections.sort(this.tEPortBitErrorThList);
        }
        catch (Exception e) {
            this.log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        boolean isDynBD = mgr.isDynPortBoardType(this.neid, this.boardType);
        ArrayList existPortList = TEQueryLogicPort.getLogicPortList((int)this.neid, (int)this.slotID, (int)this.boardType);
        int len = this.tEPortBitErrorThList.size();
        for (int i = 0; i < len; ++i) {
            TEPortBitErrorTh tEPortBitErrorTh = (TEPortBitErrorTh)this.tEPortBitErrorThList.get(i);
            int portID = tEPortBitErrorTh.getPortID();
            if (isDynBD && !existPortList.contains(portID)) continue;
            int pathID = tEPortBitErrorTh.getPathID();
            TEPortBitErrorTh bitErrorTh = new TEPortBitErrorTh();
            bitErrorTh.setPortID(portID);
            bitErrorTh.setPathID(pathID);
            ArrayList bitErrorThList = tEPortBitErrorTh.getBitErrorThList();
            if (this.tEBitErrThMgr.isNABitError(bitErrorThList)) continue;
            this.bitErrorMap.put(bitErrorTh.makeBitErrorKey(), bitErrorTh);
            bitErrorThList = this.tEBitErrThMgr.delNABitErrorList(bitErrorThList);
            int length = bitErrorThList.size();
            for (int j = 0; j < length; j += 2) {
                TEBitErrorTh tEBitErrorTh = (TEBitErrorTh)bitErrorThList.get(j);
                int type = tEBitErrorTh.getThtype();
                int bitType = this.tEBitErrThMgr.getBitType(type);
                if (6 == bitType) {
                    this.setIFAQxData(portID);
                    continue;
                }
                if (35 == type) {
                    this.operationList.add(this.setFECQXData(this.slotID, portID, pathID));
                    continue;
                }
                if (bitType < 1 || bitType > 5) continue;
                this.setLineQxData(portID, bitType);
            }
        }
        return this.operationList;
    }

    private Operation setFECQXData(int slotID, int portID, int pathID) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_FLOAT_BEFORE_FEC_TH");
            Input input = null;
            if (oper != null) {
                input = oper.getInput();
                Part part = input.getPart("slotID");
                part.setValue(String.valueOf(slotID));
                part = input.getPart("portID");
                part.setValue(String.valueOf(portID));
                part = input.getPart("pathID");
                part.setValue(String.valueOf(pathID));
                oper.getOutput(0).getPart("coefficient").setName("biterr_type_35");
                oper.getOutput(0).getPart("exponent").setName("biterr_type_1001");
            } else {
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_BEFORE_FEC_TH");
                input = oper.getInput();
                Part part = input.getPart("slotID");
                part.setValue(String.valueOf(slotID));
                part = input.getPart("portID");
                part.setValue(String.valueOf(portID));
                part = input.getPart("pathID");
                part.setValue(String.valueOf(pathID));
                oper.getOutput(0).getPart("excValue").setName("biterr_type_35");
            }
        }
        catch (Exception e) {
            this.log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    private void setIFAQxData(int portID) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_RADIO_BIP_TH");
            if (null == oper) {
                this.log.info("The operation NSCMD_CFG_GET_RADIO_BIP_TH is not found!");
                return;
            }
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(this.slotID));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portID));
            oper.getOutput(0).getPart("exceedValue").setName("biterr_type_19");
            oper.getOutput(0).getPart("badValue").setName("biterr_type_20");
        }
        catch (Exception e) {
            this.log.error("Parse Qx description file fail!", (Throwable)e);
            return;
        }
        this.operationList.add(oper);
    }

    private void setBranchQxData(int pathID, int bitType) {
        this.isBreanchBoard = true;
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_BIP_TH");
            if (null == oper) {
                this.log.info("The operation NSCMD_CFG_GET_BIP_TH is not found!");
                return;
            }
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(new Integer(this.slotID).toString());
            part = input.getPart("pathID");
            part.setValue(new Integer(pathID).toString());
            part = input.getPart("bitType");
            part.setValue(new Integer(bitType).toString());
            oper.getOutput(0).getPart("exceedValue").setName(this.tEBitErrThMgr.getExceedType(bitType));
            oper.getOutput(0).getPart("badValue").setName(this.tEBitErrThMgr.getBadType(bitType));
        }
        catch (Exception e) {
            this.log.error("Parse Qx description file fail!", (Throwable)e);
            return;
        }
        this.operationList.add(oper);
    }

    private void setLineQxData(int portID, int bitType) {
        Operation oper = null;
        try {
            oper = 1557 == this.boardType || 2217 == this.boardType || TESpecialAttrMgr.getInstance().isCPSupportByType(this.boardType, "TE_FUNC_CFG_NGWDM_ALARM_ERROR", "SDH_ATTR_SUPPORT_ALARM_ERROR_SUPPORTBD") ? TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_BIP_TH_WBID") : TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_B1B2B3_TH_WBID");
            if (null == oper) {
                this.log.info("The operation NSCMD_CFG_GET_B1B2B3_TH is not found!");
                return;
            }
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(new Integer(this.slotID).toString());
            part = input.getPart("portID");
            part.setValue(new Integer(portID).toString());
            part = input.getPart("bitType");
            part.setValue(new Integer(bitType).toString());
            oper.getOutput(0).getPart("exceedValue").setName(this.tEBitErrThMgr.getExceedType(bitType));
            oper.getOutput(0).getPart("badValue").setName(this.tEBitErrThMgr.getBadType(bitType));
        }
        catch (Exception e) {
            this.log.error("Parse Qx description file fail!", (Throwable)e);
            return;
        }
        this.operationList.add(oper);
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1090646019) {
                return;
            }
            StringBuffer filePath = new StringBuffer();
            filePath.append("necommon").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("fault").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
            this.res = TEGetFilePath.getResource((int)neid, (StringBuffer)filePath);
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo logInfomations = new TELogInfo();
            logInfomations.setCmdID(subfunc.getCode());
            logInfomations.setLocation(ipAddress);
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                int userID = 0;
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
                logInfomations.setUserID(userID);
            }
            logInfomations.setUserName(TESysManagerBean.getInstance().getSysUser());
            logInfomations.setOperateName(subfunc.getSubFuncDes(neid));
            logInfomations.setOperateObject("");
            logInfomations.setOperateDesc(this.alarmToString());
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (null == neObj) {
                logInfomations.setOperateObject(String.valueOf(neid));
            } else {
                logInfomations.setOperateObject(neObj.getNEName());
            }
            logInfomations.setOperateName(this.res.getString("QueryBitError"));
            if (errorCode == 0) {
                logInfomations.setResult(0);
                logInfomations.setErrCode(0);
                logInfomations.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(logInfomations);
            } else if (errorCode == 2 || errorCode == 1) {
                logInfomations.setResult(errorCode);
                if (null == outputData.getBussinessParams() || outputData.getBussinessParams().getRowParamsCount() == 0) {
                    logInfomations.setErrCode(errorCode);
                }
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    if (rowErrors.length <= 0) continue;
                    logInfomations.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                    logInfomations.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                    loginfoList.add(logInfomations);
                    break;
                }
            } else {
                logInfomations.setResult(2);
                logInfomations.setErrCode(errorCode);
                logInfomations.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(logInfomations);
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private String alarmToString() {
        TEConfigurationDataMgr tEConfigurationDataMgr = TEConfigurationDataMgr.getInstance();
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(this.res.getString("Query"));
        String boardString = this.res.getString("board");
        strBuf.append(boardString);
        String subrack = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.slotID);
        if (!subrack.isEmpty()) {
            strBuf.append(TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.slotID)).append("-");
        }
        strBuf.append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.slotID)).append("-").append(tEConfigurationDataMgr.getBoardTypeName(this.neid, this.boardType));
        strBuf.append(this.res.getString("QueryBitError"));
        return strBuf.toString();
    }
}

