/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.fault_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEAISTh;
import com.huawei.nglct.nelist.model.alarm.TEAlarmAISTh;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TEGetSupportAisBean
implements TENEMgrInterface {
    protected Datainterface outputData = null;
    private TEResourceUtil res = null;
    private int boardType = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Param boardTypeParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"boardType");
        this.boardType = Integer.parseInt(boardTypeParam.getValue());
        TEAlarmAISTh supportAIS = (TEAlarmAISTh)TEAlarmDataMgr.getInstance().getAISList(this.boardType).get(0);
        this.convertToOutPutData(supportAIS.getAisThList());
        return this.outputData;
    }

    public void convertToOutPutData(ArrayList supportAIS) {
        this.outputData = new Datainterface();
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        if (null == supportAIS) {
            return;
        }
        BussinessParams bussinessParams = new BussinessParams();
        RowParams rowparams = null;
        TEAISTh aisTh = null;
        int len = supportAIS.size();
        for (int i = 0; i < len; ++i) {
            rowparams = new RowParams();
            aisTh = (TEAISTh)supportAIS.get(i);
            rowparams.addParam("alarmID", "" + aisTh.getType());
            bussinessParams.addRowParams(rowparams);
        }
        this.outputData.setBussinessParams(bussinessParams);
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1090646019) {
                return;
            }
            StringBuffer filePath = new StringBuffer();
            filePath.append("necommon").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("fault").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
            this.res = TEGetFilePath.getResource((int)neid, (StringBuffer)filePath);
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo logInf = new TELogInfo();
            logInf.setCmdID(subfunc.getCode());
            logInf.setLocation(ipAddress);
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                int userID = 0;
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
                logInf.setUserID(userID);
            }
            logInf.setUserName(TESysManagerBean.getInstance().getSysUser());
            logInf.setOperateName(subfunc.getSubFuncDes(neid));
            logInf.setOperateObject("");
            logInf.setOperateDesc(subfunc.getSubFuncDes(neid));
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (null == neObj) {
                logInf.setOperateObject(String.valueOf(neid));
            } else {
                String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, this.boardType);
                logInf.setOperateObject(neObj.getNEName() + "-" + "(" + boardName + ")");
            }
            if (errorCode == 0) {
                logInf.setResult(0);
                logInf.setErrCode(0);
                logInf.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(logInf);
            } else if (errorCode == 2 || errorCode == 1) {
                logInf.setResult(errorCode);
                if (null == outputData.getBussinessParams() || outputData.getBussinessParams().getRowParamsCount() == 0) {
                    logInf.setErrCode(errorCode);
                }
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    if (rowErrors.length <= 0) continue;
                    logInf.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                    logInf.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                    loginfoList.add(logInf);
                    break;
                }
            } else {
                logInf.setResult(2);
                logInf.setErrCode(errorCode);
                logInf.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(logInf);
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    public boolean isNeedOperationlog() {
        return true;
    }
}

