/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.fault_v2r8c01;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEBitErrorTh;
import com.huawei.nglct.nelist.model.alarm.TEPortBitErrorTh;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ngwdm.fault.TEBitErrThMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEApplyBitErrorBean
extends TECommonWriteLogBean {
    private static final int TIME_OUT = 10;
    private TEBitErrThMgr tEBitErrThMgr = TEBitErrThMgr.getInstance();
    private static Logger log = TELogFactory.getNormalLogger();
    private int slotID = -1;
    private int boardType = -1;
    private ArrayList alarmBITThList = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            RowParams[] rParams = inputData.getBussinessParams().getRowParams();
            this.boardType = Integer.parseInt(rParams[0].getParam("boardType").getValue());
            this.slotID = Integer.parseInt(rParams[0].getParam("slotID").getValue());
            this.operationList = this.applyBitError(neid, inputData);
            int result = TENECommMgr.getInstance().sendCommand((int)neid, (List)this.operationList, (int)10).retCode;
            this.outputData = new Datainterface();
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            log.error("Apply bit error fail!", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            return this.outputData;
        }
        return this.outputData;
    }

    private ArrayList applyBitError(int neID, Datainterface inputData) {
        this.operationList = new ArrayList();
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        this.boardType = Integer.parseInt(rParams[0].getParam("boardType").getValue());
        this.alarmBITThList = TEAlarmDataMgr.getInstance().getBITThList(this.boardType);
        int size = rParams.length;
        for (int i = 0; i < size; ++i) {
            int portID = Integer.parseInt(rParams[i].getParam("portID").getValue());
            int pathID = Integer.parseInt(rParams[i].getParam("pathID").getValue());
            if (rParams[i].getParam("biterr_type_35_coefficient") != null && !rParams[i].getParam("biterr_type_35_coefficient").getValue().isEmpty()) {
                int coefficient = Integer.parseInt(rParams[i].getParam("biterr_type_35_coefficient").getValue());
                int exponent = Integer.parseInt(rParams[i].getParam("biterr_type_35_exponent").getValue());
                Operation operation = this.setFloatFECQXData(this.slotID, portID, pathID, coefficient, exponent);
                this.operationList.add(operation);
            }
            int len = this.alarmBITThList.size();
            for (int j = 0; j < len; ++j) {
                TEPortBitErrorTh tEPortBitErrorTh = (TEPortBitErrorTh)this.alarmBITThList.get(j);
                if (portID != tEPortBitErrorTh.getPortID() || pathID != tEPortBitErrorTh.getPathID()) continue;
                ArrayList bitErrorThList = tEPortBitErrorTh.getBitErrorThList();
                int length = bitErrorThList.size();
                for (int k = 0; k < length; k += 2) {
                    TEBitErrorTh tEBitErrorTh = (TEBitErrorTh)bitErrorThList.get(k);
                    int type = tEBitErrorTh.getThtype();
                    int bitType = this.tEBitErrThMgr.getBitType(type);
                    Operation oper = null;
                    String Exc = "";
                    String SD = "";
                    if (4 == bitType) {
                        String vc3b3Exc = rParams[i].getParam("biterr_type_7").getValue();
                        String vc3b3SD = rParams[i].getParam("biterr_type_8").getValue();
                        if (vc3b3Exc.equals("") || vc3b3SD.equals("")) continue;
                        Exc = vc3b3Exc;
                        SD = vc3b3SD;
                    }
                    if (5 == bitType) {
                        String Bip2Exc = rParams[i].getParam("biterr_type_9").getValue();
                        String Bip2SD = rParams[i].getParam("biterr_type_10").getValue();
                        if (Bip2Exc.equals("") || Bip2SD.equals("")) continue;
                        Exc = Bip2Exc;
                        SD = Bip2SD;
                    } else if (6 == bitType) {
                        String IFAExc = rParams[i].getParam("biterr_type_19").getValue();
                        String IFASd = rParams[i].getParam("biterr_type_20").getValue();
                        if (IFAExc.equals("") || IFASd.equals("")) continue;
                        oper = this.setIFAQxData(portID, IFAExc, IFASd);
                        this.operationList.add(oper);
                        continue;
                    }
                    switch (bitType) {
                        case 1: {
                            Exc = rParams[i].getParam("biterr_type_1").getValue();
                            SD = rParams[i].getParam("biterr_type_2").getValue();
                            break;
                        }
                        case 2: {
                            Exc = rParams[i].getParam("biterr_type_3").getValue();
                            SD = rParams[i].getParam("biterr_type_4").getValue();
                            break;
                        }
                        case 3: {
                            Exc = rParams[i].getParam("biterr_type_5").getValue();
                            SD = rParams[i].getParam("biterr_type_6").getValue();
                            break;
                        }
                    }
                    if (Exc.equals("") || SD.equals("")) continue;
                    oper = this.setLineQxData(portID, bitType, Exc, SD);
                    this.operationList.add(oper);
                }
            }
        }
        return this.operationList;
    }

    private Operation setFloatFECQXData(int slotID, int portID, int pathID, int coefficient, int exponent) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_FLOAT_BEFORE_FEC_TH");
            if (null == oper) {
                log.info("The operation NSCMD_CFG_SET_FLOAT_BEFORE_FEC_TH is not found!");
                return null;
            }
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(slotID));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portID));
            part = input.getPart("pathID");
            part.setValue(String.valueOf(pathID));
            part = input.getPart("coefficient");
            part.setValue(String.valueOf(coefficient));
            part = input.getPart("exponent");
            part.setValue(String.valueOf(exponent));
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    private Operation setIFAQxData(int portID, String IFAExc, String IFASd) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_RADIO_BIP_TH");
            if (null == oper) {
                log.info("The operation NSCMD_CFG_SET_RADIO_BIP_TH is not found!");
                return null;
            }
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(this.slotID));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portID));
            part = input.getPart("exceedValue");
            part.setValue(IFAExc);
            part = input.getPart("badValue");
            part.setValue(IFASd);
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    private Operation setBranchQxData(int PathID, int bitType, String Bip2Exc, String Bip2SD) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_BIP_TH");
            if (null == oper) {
                log.info("The operation NSCMD_CFG_SET_BIP_TH is not found!");
                return null;
            }
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(this.slotID));
            part = input.getPart("pathID");
            part.setValue(String.valueOf(PathID));
            part = input.getPart("bitType");
            part.setValue(String.valueOf(bitType));
            part = input.getPart("exceedValue");
            part.setValue(Bip2Exc);
            part = input.getPart("badValue");
            part.setValue(Bip2SD);
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    private Operation setLineQxData(int portID, int bitType, String EXC, String SD) {
        Operation oper = null;
        try {
            oper = 1557 == this.boardType || TESpecialAttrMgr.getInstance().isCPSupportByType(this.boardType, "TE_FUNC_CFG_NGWDM_ALARM_ERROR", "SDH_ATTR_SUPPORT_ALARM_ERROR_SUPPORTBD") ? TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_BIP_TH_WBID") : TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_B1B2B3_TH_WBID");
            if (null == oper) {
                log.info("The operation NSCMD_CFG_SET_B1B2B3_TH is not found!");
                return null;
            }
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(this.slotID));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portID));
            part = input.getPart("bitType");
            part.setValue(String.valueOf(bitType));
            part = input.getPart("exceedValue");
            part.setValue(EXC);
            part = input.getPart("badValue");
            part.setValue(SD);
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    protected boolean isSingletonLog() {
        return true;
    }

    public String getSinleDetailInfo(RowParams[] rParams) {
        StringBuffer filePath = new StringBuffer(33);
        filePath.append("necommon").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("fault").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        StringBuffer strBufApply = new StringBuffer();
        String boardString = res.getString("board");
        int slotID = -1;
        strBufApply.append(boardString);
        slotID = Integer.parseInt(rParams[0].getParam("slotID").getValue());
        strBufApply.append(TEBoardUtil.getShelfBoardName((int)this.neid, (int)slotID));
        strBufApply.append(res.getString("ApplyBitError"));
        return strBufApply.toString();
    }
}

