/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.fanattribute;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.EscapeUnescape;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TEGetSubrackListBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        Map<Integer, List<String>> fanMap = this.getSubrackFanList(neid);
        boolean isSupportShelf = TEBoardUtil.isSupportShelfDevice((int)neid);
        AbstractList subrackList = null;
        if (isSupportShelf) {
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            subrackList = ne.getSubrackList();
            Collections.sort(subrackList);
        } else {
            subrackList = new ArrayList<TESubrack>();
            subrackList.add(new TESubrack(neid, "-1"));
        }
        int len = subrackList.size();
        for (int i = 0; i < len; ++i) {
            RowParams rowParams = new RowParams();
            String subrackId = ((TESubrack)subrackList.get(i)).getSubrackID();
            String subrackType = ((TESubrack)subrackList.get(i)).getLogicSubrackType();
            String subrackMemo = ((TESubrack)subrackList.get(i)).getSubrackName();
            rowParams.addParam(this.constructParma("subrackid", subrackId));
            rowParams.addParam(this.constructParma("subrackType", subrackType));
            rowParams.addParam(this.constructParma("subrackMemo", EscapeUnescape.escape((String)IOStreamConvertor.replaceSpecialStr((String)subrackMemo))));
            rowParams.addParam(this.constructParma("subrackName", TEBoardUtil.getSubrackNameFromSubrackID((int)neid, (int)Integer.parseInt(subrackId))));
            Param fanParam = this.convertRanParam(fanMap, Integer.valueOf(subrackId));
            if (fanParam != null) {
                rowParams.addParam(fanParam);
            }
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return this.outputData;
    }

    private Param convertRanParam(Map<Integer, List<String>> fanMap, int subrackId) {
        Param fanParam = null;
        List<String> fanList = fanMap.get(subrackId);
        if (fanList != null && !fanList.isEmpty()) {
            fanParam = new Param("fanlist", "");
            int lenj = fanList.size();
            for (int j = 0; j < lenj; ++j) {
                fanParam.addOption(new Option(fanList.get(j)));
            }
        }
        return fanParam;
    }

    private Map<Integer, List<String>> getSubrackFanList(int neid) {
        HashMap<Integer, List<String>> map = new HashMap<Integer, List<String>>();
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardlist = ne.getBoardList();
        Collections.sort(boardlist);
        int len = boardlist.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)boardlist.get(i);
            boolean isfan = TEConfigurationDataMgr.getInstance().isFanboard(board.getBoardType());
            if (!isfan) continue;
            int subrackID = TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)board.getSlotID());
            ArrayList<String> fanList = (ArrayList<String>)map.get(subrackID);
            if (fanList == null) {
                fanList = new ArrayList<String>();
                map.put(subrackID, fanList);
            }
            fanList.add(TEBoardUtil.getSlotIDFromSlot((int)neid, (int)board.getSlotID()) + "-" + board.getBoardName());
        }
        return map;
    }

    private Param constructParma(String key, String value) {
        Param param = new Param();
        param.setName(key);
        param.setValue(value);
        return param;
    }
}

