/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.exc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TETsPathMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class TETsPathDBMgr {
    private static final Logger normalLogger = TELogFactory.getNormalLogger();
    public static final String DB_COL_SLOT = "SlotID";
    public static final String DB_COL_PORT = "PortID";
    public static final String DB_COL_SUBCARD = "SubCardID";
    public static final String DB_COL_PATH = "PathID";

    private TETsPathDBMgr() {
    }

    public static List<TETsPathMOPO> getTsPathFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETsPathDBMgr.getTsPathFromDB";
        normalLogger.info("TETsPathDBMgr.getTsPathFromDB: begin.");
        ArrayList<TETsPathMOPO> tsPathList = new ArrayList<TETsPathMOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TETsPathDBMgr.logNullNEError(neID);
                errRet.setResult(1090596385);
                TETsPathDBMgr.logFuncEnd("TETsPathDBMgr.getTsPathFromDB");
                return tsPathList;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TETsPathMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TETsPathMOPO.class);
        }
        catch (Exception e) {
            normalLogger.error("get tsPath from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TETsPathDBMgr.logFuncEnd("TETsPathDBMgr.getTsPathFromDB");
            return tsPathList;
        }
        if (null == dbResult) {
            normalLogger.error("get clock device from db fail! dbResult is null! neID->" + neID);
            errRet.setResult(1092743443);
            TETsPathDBMgr.logFuncEnd("TETsPathDBMgr.getTsPathFromDB");
            return tsPathList;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    tsPathList.add((TETsPathMOPO)obj);
                }
            }
        } else {
            TETsPathDBMgr.logRetCodeErrorOnGet(neID, retCode);
            errRet.setResult(retCode);
        }
        TETsPathDBMgr.logFuncEnd("TETsPathDBMgr.getTsPathFromDB");
        return tsPathList;
    }

    public static void delTsPathFromDB(int neID, TETsPathMOPO tsPathMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETsPathDBMgr.delTsPathFromDB";
        normalLogger.info("TETsPathDBMgr.delTsPathFromDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)tsPathMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)tsPathMO);
        }
        catch (Exception e) {
            normalLogger.error("delete tsPath from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TETsPathDBMgr.logFuncEnd("TETsPathDBMgr.delTsPathFromDB");
            return;
        }
        if (null == dbResult) {
            TETsPathDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TETsPathDBMgr.logFuncEnd("TETsPathDBMgr.delTsPathFromDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TETsPathDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TETsPathDBMgr.logFuncEnd("TETsPathDBMgr.delTsPathFromDB");
    }

    public static void delAllTsPathsFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETsPathDBMgr.delAllTsPathsFromDB";
        normalLogger.info("TETsPathDBMgr.delAllTsPathsFromDB: begin.");
        List<TETsPathMOPO> tsPathList = TETsPathDBMgr.getTsPathFromDB(neID, errRet);
        int retCode = errRet.getResult();
        if (0 != retCode) {
            TETsPathDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        for (TETsPathMOPO tsPath : tsPathList) {
            TETsPathDBMgr.delTsPathFromDB(neID, tsPath, errRet);
        }
        TETsPathDBMgr.logFuncEnd("TETsPathDBMgr.delAllTsPathsFromDB");
    }

    public static void createtsPathToDB(int neID, TETsPathMOPO tsPathMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETsPathDBMgr.createtsPathToDB";
        normalLogger.info("TETsPathDBMgr.createtsPathToDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)tsPathMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)tsPathMO);
        }
        catch (Exception e) {
            TETsPathDBMgr.logExceptionErrorOnCreate(neID, e);
            errRet.setResult(1092743443);
            TETsPathDBMgr.logFuncEnd("TETsPathDBMgr.createtsPathToDB");
            return;
        }
        if (null == dbResult) {
            TETsPathDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TETsPathDBMgr.logFuncEnd("TETsPathDBMgr.createtsPathToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TETsPathDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TETsPathDBMgr.logFuncEnd("TETsPathDBMgr.createtsPathToDB");
    }

    public static TETsPathMOPO getTsPathFromDB(int neID, int slotid, int subslotid, int port) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair(DB_COL_SLOT, String.valueOf(slotid));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair(DB_COL_SUBCARD, String.valueOf(subslotid));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair(DB_COL_PORT, String.valueOf(port));
        criteria.add(aPair);
        TETsPathMOPO mopo = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findByID((int[])new int[]{neID}, TETsPathMOPO.class, criteria) : TECommonDaoService.findByID_NonLock((int[])new int[]{neID}, TETsPathMOPO.class, criteria);
            if (null == dbResult) {
                String tipStr = "Get TEP2PLPTMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                normalLogger.error(tipStr);
                return mopo;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEPTNPTPLPTMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            normalLogger.error(tipStr, (Throwable)e);
            return mopo;
        }
        if (0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            mopo = (TETsPathMOPO)dbResult.getData().get(0);
        }
        return mopo;
    }

    public static void updateTspathToDB(int neID, TETsPathMOPO lptMo, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETsPathDBMgr.updateTspathToDB";
        normalLogger.info("TETsPathDBMgr.updateTspathToDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)lptMo) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)lptMo);
        }
        catch (Exception e) {
            errRet.setResult(1092743443);
            TETsPathDBMgr.logFuncEnd("TETsPathDBMgr.updateTspathToDB");
            return;
        }
        if (null == dbResult) {
            TETsPathDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TETsPathDBMgr.logFuncEnd("TETsPathDBMgr.updateTspathToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TETsPathDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TETsPathDBMgr.logFuncEnd("TETsPathDBMgr.updateTspathToDB");
    }

    private static void logNullNEError(int neID) {
        normalLogger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    private static void logFuncEnd(String funcName) {
        normalLogger.info(funcName + ": end.");
    }

    private static void logNullError(int neID) {
        normalLogger.error("delete clock to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnCreate(int neID, Exception e) {
        normalLogger.error("create  fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeError(int neID, int retCode) {
        String tipStr = String.format("delete  fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }
}

