/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.exc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.channel.QueryWDMMode;
import com.huawei.nglct.nemgr.necommon.workmode.TEWorkModeMgr;
import com.huawei.nglct.nemgr.ngwdm.exc.ExcResourceKey;
import com.huawei.nglct.nemgr.ngwdm.exc.TEWorkModePortKey;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEExcCacheDataMgr {
    private static TEExcCacheDataMgr instance = null;
    private ArrayList<ExcResourceKey> existExcList = new ArrayList();
    private HashMap<TEWorkModePortKey, ArrayList<Integer>> modePath = new HashMap();
    private ArrayList<Integer> needQueryModeBoardList = new ArrayList();
    private HashMap<String, Integer> boardModeMap = new HashMap();
    private HashMap<String, Integer> portModeMap = new HashMap();
    private HashMap<Integer, Integer> portModeOffsetMap = new HashMap();
    private String filepath = "nemgr" + File.separator + "ngwdm" + File.separator + "conf" + File.separator + "exc" + File.separator + "workmodepathlist.xml";

    private TEExcCacheDataMgr() {
        this.initWorkModeXML();
    }

    public static synchronized TEExcCacheDataMgr getInstance() {
        if (instance == null) {
            instance = new TEExcCacheDataMgr();
        }
        return instance;
    }

    public void addExcData(ExcResourceKey value) {
        if (!this.existExcList.contains(value)) {
            this.existExcList.add(value);
        }
    }

    public void clear() {
        this.existExcList.clear();
        this.boardModeMap.clear();
        this.portModeMap.clear();
    }

    public boolean contiansExc(ExcResourceKey exc) {
        if (this.existExcList.isEmpty()) {
            return false;
        }
        return this.existExcList.contains(exc);
    }

    public void removeExc(ExcResourceKey exc) {
        if (this.existExcList.isEmpty()) {
            return;
        }
        this.existExcList.remove(exc);
    }

    public void initPathList(int neid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardList = ne.getBoardList();
        if (null == boardList) {
            return;
        }
        TEBoard board = null;
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            board = (TEBoard)boardList.get(i);
            if (!this.needQueryModeBoardList.contains(board.getBoardType())) continue;
            int bdType = board.getBoardType();
            int slotID = board.getSlotID();
            if (TEWorkModeMgr.getInstance().isSupportBoardMode(bdType)) {
                String serviceBoardMode = QueryWDMMode.queryBoardMode((int)neid, (int)slotID);
                int boardMode = QueryWDMMode.convertBoardMode((String)serviceBoardMode);
                this.boardModeMap.put(this.makeModeKey(neid, slotID, -1), boardMode);
            }
            if (!TEWorkModeMgr.getInstance().isSupportPortMode(bdType)) continue;
            HashMap portMap = QueryWDMMode.queryPortMode((int)neid, (int)slotID);
            for (Map.Entry entry : portMap.entrySet()) {
                Integer portID = (Integer)entry.getKey();
                Integer value = (Integer)entry.getValue();
                this.portModeMap.put(this.makeModeKey(neid, slotID, portID), value);
            }
        }
    }

    private String makeModeKey(int neid, int slotid, int portID) {
        if (portID == -1) {
            return neid + "-" + slotid;
        }
        return neid + "-" + slotid + "-" + portID;
    }

    private void initWorkModeXML() {
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile((String)"com.huawei.weblct.ngwdm_domain", (String)(TEResourceManager.getPath() + File.separator + this.filepath));
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("Parse XML Fail!" + e);
        }
        if (null == doc) {
            TELogFactory.getNormalLogger().info("Parse XML Fail: " + this.filepath);
            return;
        }
        NodeList nl = doc.getElementsByTagName("work_mode_desc");
        this.parseWorkModeNodeList(nl);
    }

    private void parseWorkModeNodeList(NodeList nl) {
        SDXMLInterpreterMgr instance = SDXMLInterpreterMgr.getInstance();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Element eltWdm = (Element)nl.item(i);
            String cpTypeValue = eltWdm.getAttribute("cp_type");
            int cptype = instance.parseInt(cpTypeValue);
            if (cptype == 0) continue;
            String portmodeOffsetStr = eltWdm.getAttribute("portmodeoffset");
            if (portmodeOffsetStr != null && !portmodeOffsetStr.isEmpty()) {
                this.portModeOffsetMap.put(cptype, Integer.valueOf(portmodeOffsetStr));
            }
            this.needQueryModeBoardList.add(cptype);
            NodeList itemNode = eltWdm.getElementsByTagName("item");
            int size = itemNode.getLength();
            for (int j = 0; j < size; ++j) {
                Element eltTmp = (Element)itemNode.item(j);
                String boardmode = eltTmp.getAttribute("boardmode");
                ArrayList<Integer> boardModeList = new ArrayList<Integer>();
                instance.parseIntList(boardmode, boardModeList);
                String portmode = eltTmp.getAttribute("portmode");
                ArrayList<Integer> portModeList = new ArrayList<Integer>();
                instance.parseIntList(portmode, portModeList);
                String level_str = eltTmp.getAttribute("level");
                ArrayList<Integer> levelList = new ArrayList<Integer>();
                if (level_str != null && !level_str.isEmpty()) {
                    instance.parseIntList(level_str, levelList);
                } else {
                    levelList.add(-1);
                }
                String pathList = eltTmp.getAttribute("pathList");
                ArrayList<Integer> pathIDList = new ArrayList<Integer>();
                if (!pathList.equals("0")) {
                    instance.parseIntList(pathList, pathIDList);
                }
                String portid = eltTmp.getAttribute("portid");
                ArrayList<Integer> portIDList = new ArrayList<Integer>();
                instance.parseIntList(portid, portIDList);
                this.addDataToMap(boardModeList, portModeList, levelList, portIDList, pathIDList, cptype);
            }
        }
    }

    private void addDataToMap(ArrayList<Integer> boardModeList, ArrayList<Integer> portModeList, ArrayList<Integer> levelList, ArrayList<Integer> portIDList, ArrayList<Integer> pathIDList, int cptype) {
        for (int boardMode : boardModeList) {
            for (int level : levelList) {
                for (int portMode : portModeList) {
                    for (int portID : portIDList) {
                        TEWorkModePortKey modeKey = new TEWorkModePortKey(cptype, boardMode, portMode, portID, level);
                        this.modePath.put(modeKey, pathIDList);
                    }
                }
            }
        }
    }

    public ArrayList<Integer> getPathList(int neid, int slotid, int portid, int bdtype, int level) {
        String boardkey = this.makeModeKey(neid, slotid, -1);
        int boardMode = -1;
        if (this.boardModeMap.get(boardkey) != null) {
            boardMode = this.boardModeMap.get(boardkey);
        }
        Integer portOffset = this.portModeOffsetMap.get(bdtype);
        int tmpPortid = portid;
        if (portOffset != null) {
            tmpPortid = portid - portOffset;
        }
        String portkey = this.makeModeKey(neid, slotid, tmpPortid);
        int portMode = -1;
        if (this.portModeMap.get(portkey) != null) {
            portMode = this.portModeMap.get(portkey);
        }
        int tmpLevel = this.convertLevel(level);
        TEWorkModePortKey modeKey = new TEWorkModePortKey(bdtype, boardMode, portMode, portid, tmpLevel);
        return this.modePath.get(modeKey);
    }

    private int convertLevel(int level) {
        if (level == 528 || level == 529 || level == 530 || level == 531 || level == 532 || level == 513) {
            return level;
        }
        return -1;
    }
}

