/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.util;

import com.huawei.network.qasn.m_q_common.QAsnCPIndex;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnCPInfo;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnGetCPInfoReq;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnGetCPInfoRsp;
import com.huawei.network.qasn.m_q_inventory_ne.QAsnGetNEInfoReq;
import com.huawei.network.qasn.m_q_inventory_ne.QAsnGetNEInfoRsp;
import com.huawei.network.qasn.m_q_inventory_ne.QAsnNEInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.jni.nelist.TEJNIGetBoardFromQ;
import com.huawei.nglct.jni.nelist.TEJNIGetNEFromQ;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPClockUtil;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPNgwdmPortMapping;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import java.util.HashSet;
import org.slf4j.Logger;

public class TEPTPSpecialForNgwdm {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEPTPSpecialForNgwdm() {
    }

    public static boolean isNgwdmDevice(int neID) {
        if (-1 == neID) {
            return false;
        }
        HashSet<Integer> ngwdmPhyDeviceType = new HashSet<Integer>();
        ngwdmPhyDeviceType.add(51);
        ngwdmPhyDeviceType.add(68);
        ngwdmPhyDeviceType.add(84);
        ngwdmPhyDeviceType.add(74);
        ngwdmPhyDeviceType.add(109);
        ngwdmPhyDeviceType.add(102);
        HashSet<Integer> ngwdmLogicDeviceType = new HashSet<Integer>();
        ngwdmLogicDeviceType.add(2013);
        ngwdmLogicDeviceType.add(1966);
        ngwdmLogicDeviceType.add(1984);
        ngwdmLogicDeviceType.add(1973);
        ngwdmLogicDeviceType.add(1986);
        ngwdmLogicDeviceType.add(1989);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        int neType = -1;
        if (null != ne) {
            neType = ne.getNEType();
            return ngwdmPhyDeviceType.contains(neType) || TESpecialAttrMgr.getInstance().isNESupportByType(neType, "TE_CFG_MODEL_FUNC_1588_CLOCK", "TE_CFG_MODEL_ATTR_1588_CLOCK");
        }
        QAsnGetNEInfoReq req = new QAsnGetNEInfoReq();
        QAsnGetNEInfoRsp rsp = new QAsnGetNEInfoRsp();
        req.neList.add((Object)neID);
        int retCode = TEJNIGetNEFromQ.getNE((int)neID, (QAsnGetNEInfoReq)req, (QAsnGetNEInfoRsp)rsp);
        if (0 == retCode && 0 == rsp.result.result && !rsp.neInfoList.isEmpty()) {
            QAsnNEInfo asnNE = (QAsnNEInfo)rsp.neInfoList.get(0);
            int devType = asnNE.neType;
            neType = TEGetNEDomainVersion.getInstance().getNeType(devType);
            return ngwdmLogicDeviceType.contains(devType) || TESpecialAttrMgr.getInstance().isNESupportByType(neType, "TE_CFG_MODEL_FUNC_1588_CLOCK", "TE_CFG_MODEL_ATTR_1588_CLOCK");
        }
        e2eLogger.error("get ne from Q fail! neID->" + neID);
        return false;
    }

    public static int getBoardType(int neID, int slotID) {
        int boardType = -1;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null != ne) {
            TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neID, slotID);
            if (null != board) {
                boardType = board.getBoardType();
            } else {
                String format = String.format("get board from db fail![neID:%d,slotID:%d]", neID, slotID);
                e2eLogger.error(format);
            }
        } else {
            QAsnGetCPInfoReq req = new QAsnGetCPInfoReq();
            QAsnGetCPInfoRsp rsp = new QAsnGetCPInfoRsp();
            QAsnCPIndex asnBoardIndex = new QAsnCPIndex();
            asnBoardIndex.neID = neID;
            asnBoardIndex.shelfID = TEPTPClockUtil.getShelfIDFromAbstractSlotID(slotID);
            asnBoardIndex.slotID = TEPTPClockUtil.getSlotIDFromAbstractSlotID(slotID);
            req.cpIndexList.add((Object)asnBoardIndex);
            int retCode = TEJNIGetBoardFromQ.getBoard((QAsnGetCPInfoReq)req, (QAsnGetCPInfoRsp)rsp);
            if (0 == retCode && 0 == rsp.result.result && !rsp.cpInfoList.isEmpty()) {
                QAsnCPInfo asnBoard = (QAsnCPInfo)rsp.cpInfoList.get(0);
                boardType = asnBoard.type;
            } else {
                String format = String.format("get board from Q fail![neID:%d,slotID:%d]", neID, slotID);
                e2eLogger.error(format);
            }
        }
        return boardType;
    }

    public static int getMappingRealPort(int neID, int slotID, int qxPort) {
        int boardType = TEPTPSpecialForNgwdm.getBoardType(neID, slotID);
        if (-1 == boardType) {
            String format = String.format("get board fail![neID:%d,slotID:%d,qxPort:%d", neID, slotID, qxPort);
            e2eLogger.error(format);
            return qxPort;
        }
        return TEPTPNgwdmPortMapping.getInstance().getMappingRealPort(boardType, qxPort);
    }
}

