/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.util;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public final class TEPTPSpecialFor1800 {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEPTPSpecialFor1800() {
    }

    public static int getFirstClockBoard(int neID) {
        List<Integer> slotIDList = TEPTPSpecialFor1800.getClockBoardSlotIDList(neID);
        if (!slotIDList.isEmpty()) {
            Collections.sort(slotIDList);
            return slotIDList.get(0);
        }
        return -1;
    }

    public static boolean hasOnlyOneClockBoard(int neID) {
        List<Integer> slotIDList = TEPTPSpecialFor1800.getClockBoardSlotIDList(neID);
        return 1 == slotIDList.size();
    }

    public static boolean hasNoneClockBoard(int neID) {
        List<Integer> slotIDList = TEPTPSpecialFor1800.getClockBoardSlotIDList(neID);
        return slotIDList.isEmpty();
    }

    private static List<Integer> getClockBoardSlotIDList(int neID) {
        ArrayList<Integer> slotIDList = new ArrayList<Integer>();
        List boardList = TEConfigurationDataMgr.getInstance().getBoardList(neID);
        if (boardList.isEmpty()) {
            return slotIDList;
        }
        for (TEBoard board : boardList) {
            if (!TEPTPSpecialFor1800.isClockBoard(board.getBoardType())) continue;
            slotIDList.add(board.getSlotID());
        }
        return slotIDList;
    }

    public static List<TEBoard> getClockBoardList(int neID) {
        ArrayList<TEBoard> clockBoardList = new ArrayList<TEBoard>();
        List boardList = TEConfigurationDataMgr.getInstance().getBoardList(neID);
        if (boardList.isEmpty()) {
            return clockBoardList;
        }
        for (TEBoard board : boardList) {
            if (!TEPTPSpecialFor1800.isClockBoard(board.getBoardType())) continue;
            clockBoardList.add(board);
        }
        Collections.sort(clockBoardList);
        return clockBoardList;
    }

    public static boolean isOSN1800(int neID) {
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neID);
        if (null == ne) {
            e2eLogger.error("ne is null! neID->" + neID);
            return false;
        }
        return 67 == ne.getNEType();
    }

    public static boolean isClockBoard(int boardType) {
        return 2446 == boardType;
    }
}

