/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.util;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEPTPNgwdmPortMapping {
    private static final StringBuffer fileNameBuffer = new StringBuffer("nemgr").append(File.separator).append("ngwdm").append(File.separator).append("conf").append(File.separator).append("clock_ptp").append(File.separator).append("ptp_port_mapping.xml");
    private static TEPTPNgwdmPortMapping instance = null;
    private Map<Integer, Map<Integer, Integer>> cpNodeMap = new HashMap<Integer, Map<Integer, Integer>>();
    private Map<Integer, Map<Integer, Integer>> cpNodeReverseMap = new HashMap<Integer, Map<Integer, Integer>>();

    public TEPTPNgwdmPortMapping() {
        this.parseXMLFile();
    }

    public static synchronized TEPTPNgwdmPortMapping getInstance() {
        if (null == instance) {
            return new TEPTPNgwdmPortMapping();
        }
        return instance;
    }

    private void parseXMLFile() {
        String filePath = new StringBuffer(TEResourceManager.getPath()).append(fileNameBuffer).toString();
        try {
            Document doc = TEParseXMLFile.parseFile((String)filePath);
            if (null == doc) {
                TELogFactory.getNormalLogger().info("Parse ptp ngwdm port mapping file fail! filePath->" + filePath);
                return;
            }
            int boardType = -1;
            String qxPortListStr = null;
            String realPortListStr = null;
            Map<Integer, Integer> qxToRealPortMap = null;
            Map<Integer, Integer> realToQxPortMap = null;
            Node node = null;
            Element root = doc.getDocumentElement();
            NodeList children = root.getChildNodes();
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                node = children.item(i);
                if (!(node instanceof Element)) continue;
                try {
                    boardType = Integer.parseInt(node.getAttributes().getNamedItem("cp_type_id").getNodeValue().trim());
                    qxPortListStr = node.getAttributes().getNamedItem("qx_port_list").getNodeValue().trim();
                    realPortListStr = node.getAttributes().getNamedItem("real_port_list").getNodeValue().trim();
                    qxToRealPortMap = this.getQxToRealPortMap(qxPortListStr, realPortListStr);
                    realToQxPortMap = this.getRealToQxPortMap(qxPortListStr, realPortListStr);
                    this.cpNodeMap.put(boardType, qxToRealPortMap);
                    this.cpNodeReverseMap.put(boardType, realToQxPortMap);
                    continue;
                }
                catch (Exception e1) {
                    TELogFactory.getNormalLogger().error("Parse eth support file fail!", (Throwable)e1);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse eth support file fail!", (Throwable)e);
        }
    }

    private Map<Integer, Integer> getQxToRealPortMap(String qxPortListStr, String realPortListStr) {
        String[] realPortArr;
        HashMap<Integer, Integer> qxToRealPortMap = new HashMap<Integer, Integer>();
        String[] qxPortArr = qxPortListStr.split(",");
        int len = qxPortArr.length > (realPortArr = realPortListStr.split(",")).length ? realPortArr.length : qxPortArr.length;
        for (int i = 0; i < len; ++i) {
            qxToRealPortMap.put(Integer.parseInt(qxPortArr[i]), Integer.parseInt(realPortArr[i]));
        }
        return qxToRealPortMap;
    }

    private Map<Integer, Integer> getRealToQxPortMap(String qxPortListStr, String realPortListStr) {
        String[] realPortArr;
        HashMap<Integer, Integer> realToQxPortMap = new HashMap<Integer, Integer>();
        String[] qxPortArr = qxPortListStr.split(",");
        int len = qxPortArr.length > (realPortArr = realPortListStr.split(",")).length ? realPortArr.length : qxPortArr.length;
        for (int i = 0; i < len; ++i) {
            realToQxPortMap.put(Integer.parseInt(realPortArr[i]), Integer.parseInt(qxPortArr[i]));
        }
        return realToQxPortMap;
    }

    public int getMappingRealPort(int boardType, int qxPort) {
        Map<Integer, Integer> qxToRealPortMap = this.cpNodeMap.get(boardType);
        if (null == qxToRealPortMap) {
            return qxPort;
        }
        Integer realPortObj = qxToRealPortMap.get(qxPort);
        if (null == realPortObj) {
            return qxPort;
        }
        return realPortObj;
    }

    public int getMappingQxPort(int boardType, int realPort) {
        Map<Integer, Integer> realToQxPortMap = this.cpNodeReverseMap.get(boardType);
        if (null == realToQxPortMap) {
            return realPort;
        }
        Integer qxPortObj = realToQxPortMap.get(realPort);
        if (null == qxPortObj) {
            return realPort;
        }
        return qxPortObj;
    }
}

