/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.util;

import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockPort;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockSource;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPBuildClock;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPClockUtil;
import com.huawei.nglct.po.embeddednemgrmo.otn.ptpclock.TEPTPClockPropertyMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.ptpclock.TEPTPClockSourceAttribMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.ptpclock.TEPTPExportClockAttribMOPO;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class TEPTPMOConverter {
    private TEPTPMOConverter() {
    }

    public static TEE2EClockDevice mo2DataDevice(int neID, TEPTPClockPropertyMOPO moDevice) {
        TEE2EClockDevice dataDevice = TEPTPBuildClock.buildClockDevice(neID);
        dataDevice.setClockSourceList(TEPTPMOConverter.mo2DataClockSource(neID, moDevice));
        dataDevice.setClockPortList(TEPTPMOConverter.mo2DataClockPort(neID, moDevice));
        return dataDevice;
    }

    public static TEPTPClockPropertyMOPO data2MO(int neID, TEE2EClockDevice dataDevice) {
        TEPTPClockPropertyMOPO moDevice = new TEPTPClockPropertyMOPO();
        moDevice.getPTPClockSourceList().addAll(TEPTPMOConverter.data2MOPortClockSource(dataDevice));
        moDevice.getPTPExportClockAttribList().addAll(TEPTPMOConverter.data2MOuterClockSource(dataDevice));
        return moDevice;
    }

    private static Set<TEPTPClockSourceAttribMOPO> data2MOPortClockSource(TEE2EClockDevice dataDevice) {
        HashSet<TEPTPClockSourceAttribMOPO> clockSourceMOSet = new HashSet<TEPTPClockSourceAttribMOPO>();
        TEPTPClockSourceAttribMOPO sourceMO = null;
        List clockSourceList = dataDevice.getClockSourceList();
        for (TEE2EClockSource dataSource : clockSourceList) {
            if (2 != dataSource.getType() || null == (sourceMO = TEPTPMOConverter.data2MOPortClockSource(dataSource))) continue;
            clockSourceMOSet.add(sourceMO);
        }
        return clockSourceMOSet;
    }

    private static Set<TEPTPExportClockAttribMOPO> data2MOuterClockSource(TEE2EClockDevice dataDevice) {
        HashSet<TEPTPExportClockAttribMOPO> clockSourceMOSet = new HashSet<TEPTPExportClockAttribMOPO>();
        TEPTPExportClockAttribMOPO sourceMO = null;
        List clockSourceList = dataDevice.getClockSourceList();
        for (TEE2EClockSource dataSource : clockSourceList) {
            if (3 != dataSource.getType()) continue;
            sourceMO = TEPTPMOConverter.data2MOuterClockSource(dataSource);
            clockSourceMOSet.add(sourceMO);
        }
        return clockSourceMOSet;
    }

    private static TEPTPExportClockAttribMOPO data2MOuterClockSource(TEE2EClockSource dataSource) {
        TEPTPExportClockAttribMOPO outerClockSource = new TEPTPExportClockAttribMOPO();
        outerClockSource.setExportClockID(dataSource.getClockID());
        return outerClockSource;
    }

    private static TEPTPClockSourceAttribMOPO data2MOPortClockSource(TEE2EClockSource dataSource) {
        TEPTPClockSourceAttribMOPO sourceMO = new TEPTPClockSourceAttribMOPO();
        if (!TEStringUtils.isNumber((String)dataSource.getClockID())) {
            return null;
        }
        sourceMO.setClockID(Long.parseLong(dataSource.getClockID()));
        sourceMO.setFarClockID(dataSource.getPoPortClockSource().getInPort().getStrFDN());
        return sourceMO;
    }

    public static List<TEE2EClockSource> mo2DataClockSource(int neID, TEPTPClockPropertyMOPO moDevice) {
        ArrayList<TEE2EClockSource> dataClockSource = new ArrayList<TEE2EClockSource>();
        dataClockSource.addAll(TEPTPMOConverter.buildPortClockSource(neID, moDevice));
        dataClockSource.addAll(TEPTPMOConverter.buildOuterClockSource(neID, moDevice));
        return dataClockSource;
    }

    public static List<TEE2EClockPort> mo2DataClockPort(int neID, TEPTPClockPropertyMOPO moDevice) {
        ArrayList<TEE2EClockPort> dataClockPortList = new ArrayList<TEE2EClockPort>();
        Set moClockSourceSet = moDevice.getPTPClockSourceList();
        for (TEPTPClockSourceAttribMOPO moClock : moClockSourceSet) {
            dataClockPortList.add(TEPTPMOConverter.buildPtpPort(neID, moClock));
        }
        return dataClockPortList;
    }

    private static TEE2EClockPort buildPtpPort(int neID, TEPTPClockSourceAttribMOPO moClock) {
        long moClockID = moClock.getClockID();
        int slotID = TEPTPMOConverter.getSlotIDFromClockID(moClockID);
        int portID = TEPTPMOConverter.getPortIDFromClockID(moClockID);
        short portworkmode = moClock.getPTPPortRealState();
        short portstatus = moClock.getPTPPortRealState();
        TEE2EClockPort dataPort = TEPTPBuildClock.buildClockPortList(neID, slotID, portID, portworkmode, portstatus);
        return dataPort;
    }

    public static List<TEE2EClockSource> buildPortClockSource(int neID, TEPTPClockPropertyMOPO moDevice) {
        ArrayList<TEE2EClockSource> dataSourceList = new ArrayList<TEE2EClockSource>();
        Set moPortClockSet = moDevice.getPTPClockSourceList();
        for (TEPTPClockSourceAttribMOPO moPortClock : moPortClockSet) {
            dataSourceList.add(TEPTPMOConverter.mo2DataPortClock(neID, moPortClock));
        }
        return dataSourceList;
    }

    public static List<TEE2EClockSource> buildOuterClockSource(int neID, TEPTPClockPropertyMOPO moDevice) {
        ArrayList<TEE2EClockSource> dataClockList = new ArrayList<TEE2EClockSource>();
        TEE2EClockSource source = null;
        Set moOuterClockSet = moDevice.getPTPExportClockAttribList();
        for (TEPTPExportClockAttribMOPO moOuterClock : moOuterClockSet) {
            source = TEPTPMOConverter.mo2DataOuterSource(neID, moOuterClock);
            if (null == source) continue;
            dataClockList.add(source);
        }
        return dataClockList;
    }

    private static TEE2EClockSource mo2DataPortClock(int neID, TEPTPClockSourceAttribMOPO moPortClock) {
        long moClockID = moPortClock.getClockID();
        int slotID = TEPTPMOConverter.getSlotIDFromClockID(moClockID);
        int portID = TEPTPMOConverter.getPortIDFromClockID(moClockID);
        return TEPTPBuildClock.buildClockSource(neID, slotID, portID, 2);
    }

    public static int getSlotIDFromClockID(long moClockID) {
        long tempClockID = moClockID;
        int shelfID = (int)(tempClockID %= 1000000000L) / 1000000;
        int relativeSlotID = (int)(tempClockID % 1000000L / 1000L);
        return TEPTPClockUtil.getAbstractSlotID(shelfID, relativeSlotID);
    }

    public static int getPortIDFromClockID(long moClockID) {
        int portID = (int)(moClockID % 1000L);
        return portID;
    }

    private static TEE2EClockSource mo2DataOuterSource(int neID, TEPTPExportClockAttribMOPO moOuterClock) {
        String clockIDStr = moOuterClock.getExportClockID();
        if (!TEStringUtils.isNumber((String)clockIDStr)) {
            return null;
        }
        if (!TEStringUtils.isNumber((String)clockIDStr)) {
            return null;
        }
        long clockID = Long.parseLong(clockIDStr);
        int slotID = TEPTPMOConverter.getSlotIDFromClockID(clockID);
        int portID = TEPTPMOConverter.getPortIDFromClockID(clockID);
        return TEPTPBuildClock.buildClockSource(neID, slotID, portID, 3);
    }
}

