/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.util;

import com.huawei.network.qasn.m_q_inventory_slots_shelfs.QAsnGetONEIndexByNeReq;
import com.huawei.network.qasn.m_q_inventory_slots_shelfs.QAsnGetONEIndexByNeRsp;
import com.huawei.network.qasn.m_q_inventory_slots_shelfs.QAsnOneIndex;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.jni.nelist.TEJNIGetOIDFromQ;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.List;
import org.slf4j.Logger;

public final class TEPTPClockUtil {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEPTPClockUtil() {
    }

    public static SubFunc createSubFunc(int neID, int sfid) {
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e) {
            TELogFactory.getE2ELogger().error("createSubFunc: Get SubFunc fail!", (Throwable)e);
        }
        return subFunc;
    }

    public static TEErrInfoReturn constructErrInfoReturn(int neID, int errorCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = "UNKNOWN";
        if (null != ne) {
            neName = ne.getNEName();
        }
        return TEPTPClockUtil.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, errorCode);
    }

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TEPTPClockUtil.getObjName(objName));
        errInfo.setErrorCode(retCode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    public static String getObjName(String[] objName) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objName.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objName[i]);
        }
        return objNameBuffer.toString();
    }

    public static void printRowError(Datainterface outputData) {
        BussinessParams bussiness = outputData.getBussinessParams();
        if (null == bussiness) {
            return;
        }
        RowParams[] rowParamsArr = bussiness.getRowParams();
        if (null == rowParamsArr) {
            return;
        }
        String errorCodeStr = null;
        for (RowParams rowParams : rowParamsArr) {
            int len = rowParams.getRowErrorsCount();
            for (int i = 0; i < len; ++i) {
                RowErrors[] rowErrorsArr = rowParams.getRowErrors();
                if (null == rowErrorsArr) continue;
                for (RowErrors rowErrors : rowErrorsArr) {
                    errorCodeStr = rowErrors.getErrorMessage().getErrorcode();
                    if (null == errorCodeStr || errorCodeStr.isEmpty()) continue;
                    e2eLogger.error("ne operation errorCode->" + errorCodeStr);
                }
            }
        }
    }

    public static TEErrInfoReturn constructErrInfoReturn(int neID, Datainterface outputData) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        if ("0".equals(outputData.getErrorMessage().getErrorcode())) {
            return errRet;
        }
        errRet.setResult(2);
        BussinessParams bussiness = outputData.getBussinessParams();
        if (null == bussiness) {
            String tipStr = "constructErrInfoReturn: bussiness is null! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            e2eLogger.error(tipStr);
            return TEPTPClockUtil.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, 1090646019);
        }
        RowParams[] rowParamsArr = bussiness.getRowParams();
        if (null == rowParamsArr) {
            String tipStr = "constructErrInfoReturn: rowParamsArr is null! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            e2eLogger.error(tipStr);
            return TEPTPClockUtil.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, 1090646019);
        }
        String errorCodeStr = null;
        for (RowParams rowParams : rowParamsArr) {
            int len = rowParams.getRowErrorsCount();
            for (int i = 0; i < len; ++i) {
                RowErrors[] rowErrorsArr = rowParams.getRowErrors();
                if (null == rowErrorsArr) continue;
                for (RowErrors rowErrors : rowErrorsArr) {
                    errorCodeStr = rowErrors.getErrorMessage().getErrorcode();
                    if (null == errorCodeStr || errorCodeStr.isEmpty()) continue;
                    int[] objID = new int[]{neID};
                    String[] objName = new String[]{neName};
                    TEErrInfo errInfo = new TEErrInfo();
                    errInfo.setErrorCode(Integer.parseInt(errorCodeStr));
                    errInfo.setObjName(TEPTPClockUtil.getObjName(objName));
                    errInfo.setObjID(objID);
                    errRet.getErrList().add(errInfo);
                    String tipStr = String.format("[neID:%d, errCode:%s]", neID, errorCodeStr);
                    e2eLogger.error(tipStr);
                }
            }
        }
        return errRet;
    }

    public static int getIntParam(RowParams rowparams, String paramName, int defaultValue) {
        int value = defaultValue;
        Param param = rowparams.getParam(paramName);
        if (null == param) {
            return value;
        }
        String obj = param.getValue();
        if (null == obj || obj.isEmpty()) {
            return value;
        }
        if (TEStringUtils.isNumber((String)obj)) {
            value = Integer.parseInt(obj);
        }
        return value;
    }

    public static long getLongParam(RowParams rowparams, String paramName, long defaultValue) {
        long value = defaultValue;
        Param param = rowparams.getParam(paramName);
        if (null == param) {
            return value;
        }
        String obj = param.getValue();
        if (null == obj || obj.isEmpty()) {
            return value;
        }
        if (TEStringUtils.isNumber((String)obj)) {
            value = Long.parseLong(obj);
        }
        return value;
    }

    public static String getStringParam(RowParams rowparams, String paramName, String defaultValue) {
        String value = defaultValue;
        Param param = rowparams.getParam(paramName);
        if (null == param) {
            return value;
        }
        String obj = param.getValue();
        if (null == obj || obj.isEmpty()) {
            return value;
        }
        value = obj;
        return value;
    }

    public static int getIntPartValue(Operation oper, String partName, int defaultValue) {
        if (0 == oper.getOutputCount()) {
            return defaultValue;
        }
        if (!"0".equals(oper.getOutput(0).getFault(0).getCode())) {
            return defaultValue;
        }
        Part part = oper.getOutput(0).getPart(partName);
        if (null == part) {
            return defaultValue;
        }
        String obj = part.getValue();
        if (TEStringUtils.isNumber((String)obj)) {
            return Integer.parseInt(obj);
        }
        return defaultValue;
    }

    public static int getInputPartValue(Operation oper, String partName, int defaultValue) {
        if (null == oper.getInput()) {
            return defaultValue;
        }
        Part part = oper.getInput().getPart(partName);
        if (null == part) {
            return defaultValue;
        }
        String obj = part.getValue();
        if (TEStringUtils.isNumber((String)obj)) {
            return Integer.parseInt(obj);
        }
        return defaultValue;
    }

    public static String getStringPartValue(Operation oper, String partName, String defaultValue) {
        if (0 == oper.getOutputCount()) {
            return defaultValue;
        }
        if (!"0".equals(oper.getOutput(0).getFault(0).getCode())) {
            return defaultValue;
        }
        Part part = oper.getOutput(0).getPart(partName);
        if (null == part) {
            return defaultValue;
        }
        String obj = part.getValue();
        if (null == obj || obj.isEmpty()) {
            return defaultValue;
        }
        return obj;
    }

    public static void addParam(RowParams rowParams, String paramName, int paramValue) {
        Param param = new Param(paramName, String.valueOf(paramValue));
        rowParams.addParam(param);
    }

    public static int getAbstractSlotID(int tempShelfID, int tempSlotID) {
        return 65536 * tempShelfID + tempSlotID;
    }

    public static int getSlotIDFromAbstractSlotID(int slotID) {
        return slotID % 65536;
    }

    public static int getShelfIDFromAbstractSlotID(int slotID) {
        return slotID / 65536;
    }

    public static int getOIDByNEID(int neID) {
        if (-1 == neID) {
            return -1;
        }
        QAsnGetONEIndexByNeReq req = new QAsnGetONEIndexByNeReq();
        QAsnGetONEIndexByNeRsp rsp = new QAsnGetONEIndexByNeRsp();
        req.neList.add((Object)neID);
        int retCode = TEJNIGetOIDFromQ.getONEIndexByNE((QAsnGetONEIndexByNeReq)req, (QAsnGetONEIndexByNeRsp)rsp);
        if (0 == retCode && 0 == rsp.result.result && !rsp.oneList.isEmpty()) {
            QAsnOneIndex asnOneIndex = (QAsnOneIndex)rsp.oneList.get(0);
            return asnOneIndex.oneID;
        }
        String format = String.format("get oid from Q fail! neID:%d, retCode:%d", neID, retCode);
        e2eLogger.error(format);
        return -1;
    }

    public static boolean isNotLogin(int neID, List<Operation> operationList) {
        int errorCode = 0;
        for (Operation oper : operationList) {
            errorCode = Integer.parseInt(oper.getOutput(0).getFault(0).getCode());
            if (37926 != errorCode && 37126 != errorCode) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainsNotLoginError(TEErrInfoReturn errRet) {
        if (0 == errRet.getResult()) {
            return false;
        }
        List errInfoList = errRet.getErrList();
        if (errInfoList.isEmpty()) {
            return false;
        }
        for (TEErrInfo errInfo : errInfoList) {
            if (37926 != errInfo.getErrorCode() && 37126 != errInfo.getErrorCode()) continue;
            return true;
        }
        return false;
    }
}

