/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.util;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EBMCData;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockPort;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockSource;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EPortClockSourceInfo;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EUniResID;
import com.huawei.nglct.nemgr.e2e.task.clock.util.TEE2EClockUtil;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPClockUtil;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPMOConverter;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPSpecialFor1800;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.ne.TENEUtils;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

public class TEPTPBuildClock {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private static final int DEFAULT_POINPORTID = 0;
    private static final int DEFAULT_POUPSTREAMPORTID = 0;

    private TEPTPBuildClock() {
    }

    public static TEE2EClockDevice buildClockDevice(int neID) {
        TEE2EClockDevice device = new TEE2EClockDevice();
        device.setNeID(neID);
        device.setClockSyncState(-1);
        device.setTimeSyncState(-1);
        device.setPoOperMask(0);
        device.setPoSearchMode(0);
        device.setClockDevType(1);
        TEPTPBuildClock.buildInnerClockSource(neID, device);
        return device;
    }

    public static void buildInnerClockSource(int neID, TEE2EClockDevice device) {
        if (null == device) {
            e2eLogger.error("device is null!");
            return;
        }
        TEE2EClockSource clockSource = null;
        List clockSourceList = device.getClockSourceList();
        if (null == clockSourceList) {
            e2eLogger.error("clockSourceList is null!");
            return;
        }
        Iterator iter = clockSourceList.iterator();
        while (iter.hasNext()) {
            clockSource = (TEE2EClockSource)iter.next();
            if (1 != clockSource.getType()) continue;
            iter.remove();
        }
        TEE2EClockSource clock = TEPTPBuildClock.buildClockSource(neID, -1, -1, 1);
        clock.setClockID("00F10001");
        clockSourceList.add(clock);
    }

    public static TEE2EClockSource buildClockSource(int neID, int slotID, int portID, int clockType) {
        TEE2EClockSource clock = new TEE2EClockSource();
        String clockID = TEPTPBuildClock.buildClockID(neID, slotID, portID, clockType);
        clock.setClockID(clockID);
        clock.setType(clockType);
        clock.setbIsCurrTrace(0);
        if (2 == clockType) {
            TEE2EPortClockSourceInfo portClock = TEPTPBuildClock.buildPortClockSourceInfo(neID, slotID, portID, clockType);
            clock.setPoPortClockSource(portClock);
        }
        return clock;
    }

    private static TEE2EPortClockSourceInfo buildPortClockSourceInfo(int neID, int slotID, int portID, int clockType) {
        TEE2EPortClockSourceInfo portClock = new TEE2EPortClockSourceInfo();
        TEE2EUniResID inPortID = TEE2EClockUtil.constructUniResID((int)neID, (int)slotID, (int)portID);
        portClock.setInPort(inPortID);
        portClock.setType(2);
        TEE2EUniResID upStreamPortID = TEE2EClockUtil.constructUniResID((int)-1, (int)-1, (int)-1);
        portClock.setPoUpstreamPort(upStreamPortID);
        portClock.setPoClockSource("");
        portClock.setPoInPortId(0);
        portClock.setPoUpstreamClockSource("");
        portClock.setPoUpstreamPortId(0);
        portClock.setInPortName(TEPTPBuildClock.getPortName(neID, slotID, portID, clockType));
        portClock.setPoUpstreamName("");
        return portClock;
    }

    public static TEE2EClockPort buildClockPortList(int neID, int slotID, int portID, int portworkmode, int portstatus) {
        TEE2EClockPort clockPort = new TEE2EClockPort();
        clockPort.setPortIndex(TEE2EClockUtil.constructUniResID((int)neID, (int)slotID, (int)portID));
        clockPort.setPortClockType(portworkmode);
        clockPort.setMode(portstatus);
        clockPort.setState(-1);
        clockPort.setPortName(TEPTPBuildClock.getPortName(neID, slotID, portID, 2));
        clockPort.setPoPortCompensator("");
        return clockPort;
    }

    private static String buildClockID(int neID, int slotID, int portID, int clockType) {
        String clockID = "";
        if (1 == clockType) {
            clockID = "00F10001";
        } else if (2 == clockType) {
            clockID = TEPTPBuildClock.getPortClockID(neID, slotID, portID);
        } else if (3 == clockType) {
            clockID = TEPTPBuildClock.getOuterClockID(neID, slotID, portID);
        } else {
            e2eLogger.error("undefined clockType->" + clockType);
        }
        return clockID;
    }

    public static String getPortName(int neID, int slotID, int portID, int clockType) {
        String portName = "";
        if (-1 != portID) {
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
            portName = 3 == clockType ? String.valueOf(portID) : TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, boardType, portID);
            String neName = TEPTPBuildClock.getNEName(neID);
            String shelfName = TEBoardUtil.getSubrackNameFromSlot((int)neID, (int)slotID);
            String boardName = TEBoardUtil.getCPTypeName((int)boardType);
            int relativeSlotID = TEBoardUtil.bigSlotToSmall((int)slotID);
            portName = neName + '-' + shelfName + '-' + relativeSlotID + '-' + boardName + '-' + portName;
        }
        return portName;
    }

    private static String getNEName(int neID) {
        String neName = "UNKNOWN";
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null != ne) {
            neName = ne.getNEName();
        }
        return neName;
    }

    private static String getPortClockID(int neID, int slotID, int portID) {
        int shelfID = TEBoardUtil.getSubrackIDFromSlot((int)neID, (int)slotID);
        int relativeSlotID = TEBoardUtil.getSlotIDFromSlot((int)neID, (int)slotID);
        return String.valueOf(shelfID * 1000000 + relativeSlotID * 1000 + portID);
    }

    public static String getOuterClockID(int neID, int slotID, int portID) {
        int shelfID = TEBoardUtil.getSubrackIDFromSlot((int)neID, (int)slotID);
        int relativeSlotID = TEBoardUtil.getSlotIDFromSlot((int)neID, (int)slotID);
        return String.valueOf(1000000000 + shelfID * 1000000 + relativeSlotID * 1000 + portID);
    }

    public static boolean isInvalidClock(int gneid, int gslotid, int gportid) {
        return -1 == gneid && -1 == gslotid && -1 == gportid;
    }

    public static boolean isUnknownClock(int gneid, int gportid) {
        return -1 == gneid && -1 != gportid;
    }

    public static boolean isInnerClock(int currNEID, int gneid, int gportid) {
        return currNEID == gneid && 0 == gportid;
    }

    public static boolean isOuterClock(int currNEID, int gneid, int gslotid) {
        int smallGSlotID = TEBoardUtil.bigSlotToSmall((int)gslotid);
        return 240 == smallGSlotID;
    }

    public static void resetClockSourceBMCInfo(TEE2EClockDevice clockDevice) {
        List clockSourceList = clockDevice.getClockSourceList();
        for (TEE2EClockSource clockSource : clockSourceList) {
            int clockType = clockSource.getType();
            if (2 != clockType && 1 != clockType) continue;
            TEE2EBMCData bmcData = clockDevice.getBmcData();
            clockSource.setClockAccuracy(bmcData.getTimeprecision());
            clockSource.setClockClass(bmcData.getTimelevel());
            clockSource.setClockPriority1(bmcData.getClockpri1());
            clockSource.setClockPriority2(bmcData.getClockpri2());
            clockSource.setClockTimeSource(bmcData.getClocktype());
        }
    }

    public static void resetGrandMasterID(int neID, TEE2EClockDevice device) {
        int[] grandMaster = device.getGrandMaster();
        int gneid = grandMaster[0];
        int gslotid = grandMaster[1];
        int gportid = grandMaster[2];
        int gInputSlotID = grandMaster[3];
        int gClockType = TEPTPBuildClock.getGrandMasterClockType(neID, gneid, gslotid, gportid);
        if (1 == gClockType) {
            TEPTPBuildClock.setClockSourceOnInnerClockTraced(device);
        } else if (3 == gClockType) {
            TEPTPBuildClock.setClockSourceOnOuterClockTraced(neID, device, gslotid, gportid, gInputSlotID);
        } else if (2 == gClockType) {
            TEPTPBuildClock.setClockSourceOnPortTraced(device, gslotid, gportid);
        } else if (-200 == gClockType) {
            TEPTPBuildClock.setClockSourceOnUnknownTraced(device, gslotid, gportid);
        } else {
            e2eLogger.info("invalid gClockType->" + gClockType);
        }
    }

    private static int getGrandMasterClockType(int neID, int gneid, int gslotid, int gportid) {
        if (TEPTPBuildClock.isInvalidClock(gneid, gslotid, gportid)) {
            return -1;
        }
        if (TEPTPBuildClock.isInnerClock(neID, gneid, gportid)) {
            return 1;
        }
        if (TEPTPBuildClock.isOuterClock(neID, gneid, gslotid)) {
            return 3;
        }
        if (TEPTPBuildClock.isUnknownClock(gneid, gportid)) {
            return -200;
        }
        return 2;
    }

    private static void setClockSourceOnInnerClockTraced(TEE2EClockDevice device) {
        List clockSourceList = device.getClockSourceList();
        for (TEE2EClockSource clockSource : clockSourceList) {
            int clockType = clockSource.getType();
            if (1 != clockType) continue;
            clockSource.setbIsCurrTrace(1);
            break;
        }
    }

    private static void setClockSourceOnPortTraced(TEE2EClockDevice device, int gslotid, int gportid) {
        List clockSourceList = device.getClockSourceList();
        for (TEE2EClockSource clockSource : clockSourceList) {
            String clockID = clockSource.getClockID();
            int clockType = clockSource.getType();
            if (2 != clockType || !TEStringUtils.isNumber((String)clockID)) continue;
            long longClockID = Long.parseLong(clockID);
            int clockSourceSlotID = TEPTPMOConverter.getSlotIDFromClockID(longClockID);
            int clockSourcePortID = TEPTPMOConverter.getPortIDFromClockID(longClockID);
            if (gslotid != clockSourceSlotID || gportid != clockSourcePortID) continue;
            clockSource.setbIsCurrTrace(1);
            break;
        }
    }

    private static void setClockSourceOnUnknownTraced(TEE2EClockDevice device, int gslotid, int gportid) {
        List clockSourceList = device.getClockSourceList();
        for (TEE2EClockSource clockSource : clockSourceList) {
            String clockID = clockSource.getClockID();
            int clockType = clockSource.getType();
            if (1 == clockType || !TEStringUtils.isNumber((String)clockID)) continue;
            long longClockID = Long.parseLong(clockID);
            int clockSourceSlotID = TEPTPMOConverter.getSlotIDFromClockID(longClockID);
            int clockSourcePortID = TEPTPMOConverter.getPortIDFromClockID(longClockID);
            if (gslotid != clockSourceSlotID || gportid != clockSourcePortID) continue;
            clockSource.setbIsCurrTrace(1);
            break;
        }
    }

    private static void setClockSourceOnOuterClockTraced(int neID, TEE2EClockDevice device, int gslotid, int gportid, int gInputSlotID) {
        List clockSourceList = device.getClockSourceList();
        for (TEE2EClockSource clockSource : clockSourceList) {
            String clockID = clockSource.getClockID();
            int clockType = clockSource.getType();
            if (3 != clockType || !TEStringUtils.isNumber((String)clockID)) continue;
            long longClockID = Long.parseLong(clockID);
            int clockSourceSlotID = TEPTPMOConverter.getSlotIDFromClockID(longClockID);
            int clockSourcePortID = TEPTPMOConverter.getPortIDFromClockID(longClockID);
            if (clockSourcePortID != gportid) continue;
            if (TEPTPSpecialFor1800.isOSN1800(neID)) {
                if (clockSourceSlotID != gInputSlotID) continue;
                clockSource.setbIsCurrTrace(1);
                break;
            }
            int gShelfID = TEPTPClockUtil.getShelfIDFromAbstractSlotID(gslotid);
            int clockSourceShelfID = TEPTPClockUtil.getShelfIDFromAbstractSlotID(clockSourceSlotID);
            if (clockSourceShelfID != gShelfID) continue;
            clockSource.setbIsCurrTrace(1);
            break;
        }
    }

    public static int getPhyNEIDFromHex(String grandPhyNEIDStr) {
        int neID = -1;
        if (null == grandPhyNEIDStr || grandPhyNEIDStr.trim().isEmpty() || "FFFFFFFF".equals(grandPhyNEIDStr)) {
            return neID;
        }
        try {
            int tenneid = Integer.parseInt(grandPhyNEIDStr.trim(), 16);
            if (-1 == tenneid) {
                return neID;
            }
            String neIDStr = "" + tenneid / 65536 + "-" + tenneid % 65536;
            neID = TENEUtils.deformatNEID((String)neIDStr);
        }
        catch (Exception e) {
            neID = -1;
            e2eLogger.error("parse grandPhyNEIDStr fail!", (Throwable)e);
        }
        return neID;
    }

    public static void clearPtpPort(TEE2EClockDevice dataDevice) {
        List clockSourceList = dataDevice.getClockSourceList();
        Iterator iter = clockSourceList.iterator();
        while (iter.hasNext()) {
            TEE2EClockSource source = (TEE2EClockSource)iter.next();
            if (2 != source.getType()) continue;
            iter.remove();
        }
        List clockPortList = dataDevice.getClockPortList();
        clockPortList.clear();
    }

    public static void clearOuterClock(TEE2EClockDevice dataDevice) {
        List clockSourceList = dataDevice.getClockSourceList();
        Iterator iter = clockSourceList.iterator();
        while (iter.hasNext()) {
            TEE2EClockSource source = (TEE2EClockSource)iter.next();
            if (3 != source.getType()) continue;
            iter.remove();
        }
    }

    public static List<TEE2EClockSource> getClockSource(TEE2EClockDevice device, int clockType) {
        ArrayList<TEE2EClockSource> resultList = new ArrayList<TEE2EClockSource>();
        TEE2EClockSource clock2 = null;
        List clockSourceList = device.getClockSourceList();
        for (TEE2EClockSource clock2 : clockSourceList) {
            if (clockType != clock2.getType()) continue;
            resultList.add(clock2);
        }
        return resultList;
    }
}

