/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.ptpclock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.ngwdm.e2e.bean.TEE2EQueryClockPortList;
import com.huawei.nglct.nemgr.ngwdm.e2e.bean.TEPTPQueryClockInfo;
import com.huawei.nglct.nemgr.ngwdm.e2e.bean.TEPTPQueryOuterClockSource;
import com.huawei.nglct.nemgr.ngwdm.e2e.db.TEPTPClockDBMgr;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPBuildClock;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPClockUtil;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPMOConverter;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPSpecialFor1800;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPSpecialForNgwdm;
import com.huawei.nglct.po.embeddednemgrmo.otn.ptpclock.TEPTPClockPropertyMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;

public final class TEPTPGetClockDeviceFromNE {
    public static final int IS_ALL_NE_FALSE = 0;
    public static final int IS_ALL_NE_TRUE = 1;

    private TEPTPGetClockDeviceFromNE() {
    }

    public static TEErrInfoReturn getClockDevice(int neID, List<TEE2EClockDevice> rspDeviceList, int uploadFlag) {
        TEErrInfoReturn tempErrRet;
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        if (!TEPTPSpecialFor1800.isOSN1800(neID) && !TEPTPSpecialForNgwdm.isNgwdmDevice(neID)) {
            TELogFactory.getE2ELogger().info("not 1800 or ngwdm device. neID->" + neID);
            return errRet;
        }
        if (TEPTPSpecialFor1800.isOSN1800(neID) && TEPTPSpecialFor1800.hasNoneClockBoard(neID)) {
            return errRet;
        }
        TEE2EClockDevice clockDevice = TEPTPBuildClock.buildClockDevice(neID);
        if (1 == uploadFlag) {
            TEPTPClockPropertyMOPO moDevice = TEPTPClockDBMgr.getClockDeviceFromDB(neID, errRet);
            if (null != moDevice) {
                TEPTPClockDBMgr.delClockDeviceToDB(neID, moDevice, errRet);
            }
            TEE2EQueryClockPortList.queryClockPortList(neID, clockDevice);
            TEPTPQueryOuterClockSource.queryOuterClockSource(neID, clockDevice);
        }
        if (TEPTPClockUtil.isContainsNotLoginError(tempErrRet = TEPTPQueryClockInfo.queryClockDeviceBasicInfo(neID, clockDevice))) {
            errRet.setResult(1090650122);
            errRet.addErrInfo(tempErrRet.getErrList());
            return errRet;
        }
        TEPTPClockPropertyMOPO moDevice = TEPTPClockDBMgr.getClockDeviceFromDB(neID, errRet);
        if (null != moDevice) {
            clockDevice.getClockSourceList().addAll(TEPTPMOConverter.buildPortClockSource(neID, moDevice));
            clockDevice.getClockSourceList().addAll(TEPTPMOConverter.buildOuterClockSource(neID, moDevice));
            clockDevice.setClockPortList(TEPTPMOConverter.mo2DataClockPort(neID, moDevice));
        }
        if (TEPTPClockUtil.isContainsNotLoginError(tempErrRet = TEPTPQueryClockInfo.queryPortClockSourceInfo(neID, clockDevice))) {
            errRet.setResult(1090650122);
            errRet.addErrInfo(tempErrRet.getErrList());
            return errRet;
        }
        tempErrRet = TEPTPQueryClockInfo.queryOuterClockSourceInfo(neID, clockDevice);
        if (TEPTPClockUtil.isContainsNotLoginError(tempErrRet)) {
            errRet.setResult(1090650122);
            errRet.addErrInfo(tempErrRet.getErrList());
            return errRet;
        }
        tempErrRet = TEPTPQueryClockInfo.querySysTimeAndClockLockState(neID, clockDevice);
        if (TEPTPClockUtil.isContainsNotLoginError(tempErrRet)) {
            errRet.setResult(1090650122);
            errRet.addErrInfo(tempErrRet.getErrList());
            return errRet;
        }
        TEPTPBuildClock.resetClockSourceBMCInfo(clockDevice);
        TEPTPBuildClock.resetGrandMasterID(neID, clockDevice);
        rspDeviceList.add(clockDevice);
        return errRet;
    }
}

