/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.message;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.ngwdm.e2e.message.TEPTPClockMessage;
import com.huawei.nglct.nemgr.ngwdm.e2e.message.TEPTPClockNoticeMgr;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPSpecialFor1800;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPSpecialForNgwdm;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import org.slf4j.Logger;

public class TEPTPClockSrcChgEventHandlerOnI
implements NoticeHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    public void handleNotice(int cmdKey, int neID, Operation oper) {
        String tip = String.format("handle notice begin. cmdKey:%d, neID:%d", cmdKey, neID);
        e2eLogger.info(tip);
        if (!TEPTPSpecialFor1800.isOSN1800(neID) && !TEPTPSpecialForNgwdm.isNgwdmDevice(neID)) {
            e2eLogger.info("not 1800 or ngwdm device. neID->" + neID);
            return;
        }
        int retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
        if (0 != retCode) {
            e2eLogger.info("connect ne for sbi fail! neID->" + neID);
        }
        if (cmdKey == 16591 || cmdKey == 16572 || cmdKey == 16615 || cmdKey == 18529) {
            this.eventinterpretEvent(cmdKey, neID, oper);
        }
        e2eLogger.info("handle notice end");
    }

    private void eventinterpretEvent(int cmdKey, int neID, Operation oper) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        try {
            TEPTPClockMessage message = TEPTPClockNoticeMgr.buildDevChangeMessage(neID, 12);
            TEPTPClockNoticeMgr.sendClockDevChangeNtf(message);
        }
        catch (Exception e) {
            e2eLogger.error("send clocksource change exception!", (Throwable)e);
        }
    }
}

