/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.message;

import com.huawei.network.qasn.m_q_nml_clock_model.QAsnClockDevice;
import com.huawei.network.qasn.m_q_nml_clock_model.QAsnClockNE;
import com.huawei.network.qasn.m_q_nml_clock_op.QAsnClockDevAddRpt;
import com.huawei.network.qasn.m_q_nml_clock_op.QAsnClockDevChangeRpt;
import com.huawei.network.qasn.m_q_nml_clock_op.QAsnClockDevDelRpt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.reliableevent.TEReliableEventMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.util.TEE2EClockDataConverter;
import com.huawei.nglct.nemgr.ngwdm.e2e.message.TEPTPClockDevAddMsg;
import com.huawei.nglct.nemgr.ngwdm.e2e.message.TEPTPClockDevChangeMsg;
import com.huawei.nglct.nemgr.ngwdm.e2e.message.TEPTPClockDevDelMsg;
import com.huawei.nglct.nemgr.ngwdm.e2e.message.TEPTPClockMessage;
import com.huawei.nglct.nemgr.ngwdm.e2e.ptpclock.TEPTPGetClockDeviceFromNE;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPClockUtil;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPSpecialFor1800;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPSpecialForNgwdm;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class TEPTPClockNoticeMgr {
    private static final Logger e2elogger = TELogFactory.getE2ELogger();
    public static final int QEVENT_CLOCKDEVADD = 65589;
    public static final int QEVENT_CLOCKDEVCHANGE = 65590;
    public static final int QEVENT_CLOCKDEVDEL = 65591;

    private TEPTPClockNoticeMgr() {
    }

    public static void sendClockDevAddNtf(TEPTPClockMessage message) {
        if (null == message) {
            e2elogger.info("Send clock dev add notify fail! the message is null!");
            return;
        }
        int neID = -1;
        int eventID = message.getEventID();
        FStruct asnMsg = message.getContent();
        TEReliableEventMgr.getInstance().send(eventID, neID, asnMsg);
        e2elogger.info(((Object)message).toString());
    }

    public static void sendClockDevChangeNtf(TEPTPClockMessage message) {
        if (null == message) {
            e2elogger.info("Send clock dev change notify fail! the message is null!");
            return;
        }
        int neID = -1;
        int eventID = message.getEventID();
        FStruct asnMsg = message.getContent();
        TEReliableEventMgr.getInstance().send(eventID, neID, asnMsg);
        e2elogger.info(((Object)message).toString());
    }

    public static void sendClockDevDelNtf(TEPTPClockMessage message) {
        if (null == message) {
            e2elogger.info("Send clock dev del notify fail! the message is null!");
            return;
        }
        int neID = -1;
        int eventID = message.getEventID();
        FStruct asnMsg = message.getContent();
        TEReliableEventMgr.getInstance().send(eventID, neID, asnMsg);
        e2elogger.info(((Object)message).toString());
    }

    public static TEPTPClockMessage buildDevAddMessage(int neID, int poOperMask, int isUploadFlag) {
        if (!TEPTPSpecialFor1800.isOSN1800(neID) && !TEPTPSpecialForNgwdm.isNgwdmDevice(neID)) {
            e2elogger.info("not 1800 or ngwdm device. neID->" + neID);
            return null;
        }
        List<QAsnClockDevice> asnDeviceList = TEPTPClockNoticeMgr.queryAsnClockDev(neID, poOperMask, isUploadFlag);
        if (asnDeviceList.isEmpty()) {
            return null;
        }
        TEPTPClockMessage msg = TEPTPClockNoticeMgr.buildDevAddMessage(asnDeviceList);
        return msg;
    }

    public static TEPTPClockMessage buildDevChangeMessage(int neID, int poOperMask) {
        if (!TEPTPSpecialFor1800.isOSN1800(neID) && !TEPTPSpecialForNgwdm.isNgwdmDevice(neID)) {
            e2elogger.info("not 1800 or ngwdm device. neID->" + neID);
            return null;
        }
        List<QAsnClockDevice> asnDeviceList = TEPTPClockNoticeMgr.queryAsnClockDev(neID, poOperMask, 1);
        if (asnDeviceList.isEmpty()) {
            return null;
        }
        TEPTPClockMessage msg = TEPTPClockNoticeMgr.buildDevChangeMessage(asnDeviceList);
        return msg;
    }

    public static TEPTPClockMessage buildDevDelMessage(int neID) {
        if (!TEPTPSpecialFor1800.isOSN1800(neID) && !TEPTPSpecialForNgwdm.isNgwdmDevice(neID)) {
            e2elogger.info("not 1800 or ngwdm device. neID->" + neID);
            return null;
        }
        QAsnClockNE clockNE = new QAsnClockNE();
        clockNE.neID = neID;
        clockNE.type = 1;
        QAsnClockDevDelRpt content = new QAsnClockDevDelRpt();
        content.clockNEList.add((Object)clockNE);
        TEPTPClockDevDelMsg msg = new TEPTPClockDevDelMsg(content);
        return msg;
    }

    private static List<QAsnClockDevice> queryAsnClockDev(int neID, int poOperMask, int isUploadFlag) {
        ArrayList<TEE2EClockDevice> rspDeviceList = new ArrayList<TEE2EClockDevice>();
        TEPTPGetClockDeviceFromNE.getClockDevice(neID, rspDeviceList, isUploadFlag);
        if (rspDeviceList.isEmpty()) {
            return new ArrayList<QAsnClockDevice>();
        }
        for (TEE2EClockDevice dataDevice : rspDeviceList) {
            if (0 == dataDevice.getNeID()) continue;
            dataDevice.setPoOperMask(poOperMask);
        }
        List asnDeviceList = TEE2EClockDataConverter.data2AsnClockDevice(rspDeviceList);
        for (QAsnClockDevice asnDevice : asnDeviceList) {
            asnDevice.poOneID = TEPTPClockUtil.getOIDByNEID(neID);
        }
        return asnDeviceList;
    }

    private static TEPTPClockMessage buildDevAddMessage(List<QAsnClockDevice> asnDeviceList) {
        if (asnDeviceList.isEmpty()) {
            return null;
        }
        QAsnClockDevAddRpt content = new QAsnClockDevAddRpt();
        for (QAsnClockDevice asnClockDevice : asnDeviceList) {
            QAsnClockNE clockNE = new QAsnClockNE();
            clockNE.neID = asnClockDevice.neID;
            clockNE.clockDevice = asnClockDevice;
            clockNE.type = 1;
            content.clockNEList.add((Object)clockNE);
        }
        TEPTPClockDevAddMsg msg = new TEPTPClockDevAddMsg(content);
        return msg;
    }

    private static TEPTPClockMessage buildDevChangeMessage(List<QAsnClockDevice> asnDeviceList) {
        if (asnDeviceList.isEmpty()) {
            return null;
        }
        QAsnClockDevChangeRpt content = new QAsnClockDevChangeRpt();
        for (QAsnClockDevice asnClockDevice : asnDeviceList) {
            QAsnClockNE clockNE = new QAsnClockNE();
            clockNE.neID = asnClockDevice.neID;
            clockNE.clockDevice = asnClockDevice;
            clockNE.type = 1;
            content.clockNEList.add((Object)clockNE);
        }
        TEPTPClockDevChangeMsg msg = new TEPTPClockDevChangeMsg(content);
        return msg;
    }
}

