/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.util.TEE2EClockLog;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPClockUtil;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPMOConverter;
import com.huawei.nglct.po.embeddednemgrmo.otn.ptpclock.TEPTPClockPropertyMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;
import org.slf4j.Logger;

public final class TEPTPClockDBMgr {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEPTPClockDBMgr() {
    }

    public static TEPTPClockPropertyMOPO getClockDeviceFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEPTPClockDBMgr.getClockDeviceFromDB";
        TEE2EClockLog.logFuncBegin((String)"TEPTPClockDBMgr.getClockDeviceFromDB");
        TEPTPClockPropertyMOPO moDevice = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEPTPClockDBMgr.logNullNEError(neID);
                TEPTPClockDBMgr.setOperFail(neID, errRet, 1090596385);
                TEE2EClockLog.logFuncEnd((String)"TEPTPClockDBMgr.getClockDeviceFromDB");
                return moDevice;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEPTPClockPropertyMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEPTPClockPropertyMOPO.class);
        }
        catch (Exception e) {
            TEPTPClockDBMgr.logExceptionOnGet(neID, e);
            TEPTPClockDBMgr.setOperFail(neID, errRet, 1092743443);
            TEE2EClockLog.logFuncEnd((String)"TEPTPClockDBMgr.getClockDeviceFromDB");
            return moDevice;
        }
        if (null == dbResult) {
            TEPTPClockDBMgr.logNullErrorOnGet(neID);
            TEPTPClockDBMgr.setOperFail(neID, errRet, 1092743443);
            TEE2EClockLog.logFuncEnd((String)"TEPTPClockDBMgr.getClockDeviceFromDB");
            return moDevice;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                moDevice = (TEPTPClockPropertyMOPO)data.get(0);
            }
        } else {
            TEPTPClockDBMgr.logRetCodeErrorOnGet(neID, retCode);
            TEPTPClockDBMgr.setOperFail(neID, errRet, retCode);
        }
        TEE2EClockLog.logFuncEnd((String)"TEPTPClockDBMgr.getClockDeviceFromDB");
        return moDevice;
    }

    public static void updateClockDeviceToDB(int neID, TEE2EClockDevice dataDevice, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEPTPClockDBMgr.updateClockDeviceToDB";
        TEE2EClockLog.logFuncBegin((String)"TEPTPClockDBMgr.updateClockDeviceToDB");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            TEPTPClockPropertyMOPO moDevice = TEPTPMOConverter.data2MO(neID, dataDevice);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)moDevice) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)moDevice);
        }
        catch (Exception e) {
            TEPTPClockDBMgr.logExceptionErrorOnUpdate(neID, e);
            TEPTPClockDBMgr.setOperFail(neID, errRet, 1092743443);
            TEE2EClockLog.logFuncEnd((String)"TEPTPClockDBMgr.updateClockDeviceToDB");
            return;
        }
        if (null == dbResult) {
            TEPTPClockDBMgr.logNullErrorOnUpdate(neID);
            TEPTPClockDBMgr.setOperFail(neID, errRet, 1092743443);
            TEE2EClockLog.logFuncEnd((String)"TEPTPClockDBMgr.updateClockDeviceToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEPTPClockDBMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TEPTPClockDBMgr.setOperFail(neID, errRet, retCode);
        }
        TEE2EClockLog.logFuncEnd((String)"TEPTPClockDBMgr.updateClockDeviceToDB");
    }

    public static void createClockDeviceToDB(int neID, TEE2EClockDevice dataDevice, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEPTPClockDBMgr.createClockDeviceToDB";
        TEE2EClockLog.logFuncBegin((String)"TEPTPClockDBMgr.createClockDeviceToDB");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            TEPTPClockPropertyMOPO moDevice = TEPTPMOConverter.data2MO(neID, dataDevice);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)moDevice) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)moDevice);
        }
        catch (Exception e) {
            TEPTPClockDBMgr.logExceptionErrorOnCreate(neID, e);
            TEPTPClockDBMgr.setOperFail(neID, errRet, 1092743443);
            TEE2EClockLog.logFuncEnd((String)"TEPTPClockDBMgr.createClockDeviceToDB");
            return;
        }
        if (null == dbResult) {
            TEPTPClockDBMgr.logNullErrorOnCreate(neID);
            TEPTPClockDBMgr.setOperFail(neID, errRet, 1092743443);
            TEE2EClockLog.logFuncEnd((String)"TEPTPClockDBMgr.createClockDeviceToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEPTPClockDBMgr.logRetCodeErrorOnCreate(neID, retCode);
            TEPTPClockDBMgr.setOperFail(neID, errRet, retCode);
        }
        TEE2EClockLog.logFuncEnd((String)"TEPTPClockDBMgr.createClockDeviceToDB");
    }

    public static void delClockDeviceToDB(int neID, TEPTPClockPropertyMOPO moDevice, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEPTPClockDBMgr.delClockDeviceToDB";
        TEE2EClockLog.logFuncBegin((String)"TEPTPClockDBMgr.delClockDeviceToDB");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)moDevice) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)moDevice);
        }
        catch (Exception e) {
            TEPTPClockDBMgr.logExceptionErrorOnDel(neID, e);
            TEPTPClockDBMgr.setOperFail(neID, errRet, 1092743443);
            TEE2EClockLog.logFuncEnd((String)"TEPTPClockDBMgr.delClockDeviceToDB");
            return;
        }
        if (null == dbResult) {
            TEPTPClockDBMgr.logNullErrorOnDel(neID);
            TEPTPClockDBMgr.setOperFail(neID, errRet, 1092743443);
            TEE2EClockLog.logFuncEnd((String)"TEPTPClockDBMgr.delClockDeviceToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEPTPClockDBMgr.logRetCodeErrorOnDel(neID, retCode);
            TEPTPClockDBMgr.setOperFail(neID, errRet, retCode);
        }
        TEE2EClockLog.logFuncEnd((String)"TEPTPClockDBMgr.delClockDeviceToDB");
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = "";
        if (ne != null) {
            neName = ne.getNEName();
        }
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TEPTPClockUtil.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCode).getErrList());
    }

    private static void logNullNEError(int neID) {
        e2eLogger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logNullErrorOnGet(int neID) {
        e2eLogger.error("get clock device from db fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionOnGet(int neID, Exception e) {
        e2eLogger.error("get clock device from db fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnUpdate(int neID, int retCode) {
        String tipStr = String.format("update clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logNullErrorOnUpdate(int neID) {
        e2eLogger.error("update clock to db device fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionErrorOnUpdate(int neID, Exception e) {
        e2eLogger.error("update clock to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logNullErrorOnCreate(int neID) {
        e2eLogger.error("create clock to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnCreate(int neID, Exception e) {
        e2eLogger.error("create clock to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnCreate(int neID, int retCode) {
        String tipStr = String.format("create clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logNullErrorOnDel(int neID) {
        e2eLogger.error("delete clock to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnDel(int neID, Exception e) {
        e2eLogger.error("delete clock to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnDel(int neID, int retCode) {
        String tipStr = String.format("delete clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        e2eLogger.error(tipStr);
    }
}

