/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.clockupload;

import com.huawei.nglct.cbb.datamanage.integration.handler.TECIUpLoadHandler;
import com.huawei.nglct.cbb.datamanage.integration.handler.TECfgItem;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgUploadPara;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.util.TEE2EClockLog;
import com.huawei.nglct.nemgr.ngwdm.e2e.message.TEPTPClockMessage;
import com.huawei.nglct.nemgr.ngwdm.e2e.message.TEPTPClockNoticeMgr;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import org.slf4j.Logger;

public class TEE2EClockUploadHandler
implements TECIUpLoadHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    public TECfgItem getOperIF(int OperType) {
        return null;
    }

    public String getItemName() {
        return null;
    }

    public int getItemID() {
        return 0;
    }

    public int upLoad(TEDataCfgUploadPara pPara) {
        int neID = pPara.getTmpNEInfo().getNeID();
        if (!this.isNEExist(neID)) {
            e2eLogger.info("temp ne is not exist");
            neID = pPara.getOldNEID();
            if (!this.isNEExist(neID)) {
                e2eLogger.info("old ne is not exist");
                return 0;
            }
        }
        return TEE2EClockUploadHandler.uploadImpl(neID);
    }

    private boolean isNEExist(int neID) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        return null != ne;
    }

    public static int uploadImpl(int neID) {
        String FUNC_NAME = "TEE2EClockUpload.uploadImpl";
        TEE2EClockLog.logFuncBegin((String)"TEE2EClockUpload.uploadImpl");
        int retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
        if (0 != retCode) {
            TEE2EClockUploadHandler.logConnectNEFail(neID, retCode);
            TEE2EClockLog.logFuncEnd((String)"TEE2EClockUpload.uploadImpl");
            return retCode;
        }
        TEPTPClockMessage message = TEPTPClockNoticeMgr.buildDevAddMessage(neID, 0, 1);
        if (null != message) {
            TEPTPClockNoticeMgr.sendClockDevAddNtf(message);
        }
        if (null != (message = TEPTPClockNoticeMgr.buildDevChangeMessage(neID, 2047))) {
            TEPTPClockNoticeMgr.sendClockDevChangeNtf(message);
        }
        TEE2EClockLog.logFuncEnd((String)"TEE2EClockUpload.uploadImpl");
        return 0;
    }

    private static void logConnectNEFail(int neID, int retCode) {
        String tipStr = "upload ptp clock device fail! ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        e2eLogger.error(tipStr);
    }
}

