/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EUniResID;
import com.huawei.nglct.nemgr.neadapter.functionadapter.clock.NeClockSouceObj;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.ClockUtil;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TEClockSource;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TEClockSynBean;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TEQueryClockPriority;
import com.huawei.nglct.nemgr.ngwdm.e2e.clock.TEE2EGetClockDeviceUtil;
import com.huawei.nglct.nemgr.ngwdm.e2e.clock.ptpclock.TEE2EBuildClockSource;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;

public class TEE2EGetNEPhyClockAttribute {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private static final String CLOCK_SLOT_ID = "65535";

    public static NeClockSouceObj queryPhysicClockAttribute(int neID) {
        NeClockSouceObj clockSource = null;
        try {
            clockSource = TEE2EGetNEPhyClockAttribute.getPhyClockSource(neID);
            TEE2EGetNEPhyClockAttribute.queryPhyClockPri(neID, clockSource);
        }
        catch (Exception e) {
            e2eLogger.error("query physic clock Attribute fail", (Throwable)e);
        }
        return clockSource;
    }

    private static void queryPhyClockPri(int neID, NeClockSouceObj clockSource) {
        TEQueryClockPriority bean = TEE2EGetNEPhyClockAttribute.getQueryBean();
        Datainterface inputData = TEE2EGetNEPhyClockAttribute.constructQueryPhyClockInput(neID);
        int sfid = 2556101;
        SubFunc subFunc = TEE2EGetClockDeviceUtil.createSubFunc(neID, sfid);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            return;
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEE2EGetNEPhyClockAttribute.logBeanOperError(neID, retCode);
            TEE2EGetClockDeviceUtil.printRowError(outputData);
            clockSource.result = retCode;
            clockSource.retReason = outputData.getErrorMessage().getErrorinfo();
            return;
        }
        if (null == outputData.getBussinessParams()) {
            TEE2EGetNEPhyClockAttribute.logNullBussinessParamsError();
            return;
        }
        RowParams[] rowParamsArr = outputData.getBussinessParams().getRowParams();
        if (null == rowParamsArr) {
            TEE2EGetNEPhyClockAttribute.logNullRowParamsError();
            return;
        }
        int clockpri = bean.getClockSourcePri(clockSource.getClockSource());
        clockSource.setClockPriority(clockpri);
        String[] clockID = bean.getClockidstr();
        if (clockID == null) {
            e2eLogger.error("no clock. neid = " + neID);
            return;
        }
        ArrayList<NeClockSouceObj> tempList = new ArrayList<NeClockSouceObj>();
        int len = clockID.length;
        for (int i = 0; i < len; ++i) {
            String idStr = clockID[i];
            TEClockSource clocksource = ClockUtil.hexclockID2TEClockSource(neID, idStr);
            NeClockSouceObj clockObj = new NeClockSouceObj();
            if (clocksource.getClockSourceType() == 0) {
                clockObj.setClockSourceFDN("INTERNAL");
            } else {
                TEE2EUniResID resID = TEE2EBuildClockSource.constructUniResID(neID, clocksource.getSlotID(), clocksource.getPortID());
                clockObj.setClockSourceFDN(resID.getStrFDN());
            }
            clockObj.setClockPriority(i + 1);
            tempList.add(clockObj);
        }
        Collections.sort(tempList);
        clockSource.setClockPriList(tempList);
    }

    private static NeClockSouceObj getPhyClockSource(int neID) {
        NeClockSouceObj clockSource = new NeClockSouceObj();
        TEClockSynBean bean = new TEClockSynBean();
        Datainterface inputData = TEE2EGetNEPhyClockAttribute.constructQueryPhyClockInput(neID);
        int sfid = 0x202606;
        SubFunc subFunc = TEE2EGetClockDeviceUtil.createSubFunc(neID, sfid);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            return clockSource;
        }
        ErrorMessage errorMessage = TEE2EGetNEPhyClockAttribute.getClockSourceError("clocksource", outputData);
        if (errorMessage != null) {
            clockSource.result = Integer.parseInt(errorMessage.getErrorcode());
            clockSource.retReason = errorMessage.getErrorinfo();
            return clockSource;
        }
        if (null == outputData.getBussinessParams()) {
            TEE2EGetNEPhyClockAttribute.logNullBussinessParamsError();
            return clockSource;
        }
        RowParams[] rowParamsArr = outputData.getBussinessParams().getRowParams();
        if (null == rowParamsArr) {
            TEE2EGetNEPhyClockAttribute.logNullRowParamsError();
            return clockSource;
        }
        Param neClockParam = outputData.getBussinessParams().getRowParams(0).getParam("neClockSource");
        if (null == neClockParam || neClockParam.getValue().isEmpty()) {
            TEE2EGetNEPhyClockAttribute.logNullNEClockError(neID);
            return clockSource;
        }
        String value = outputData.getBussinessParams().getRowParams(0).getParam("neClockSource").getValue();
        clockSource.setClockSource(value);
        TEClockSource clocksource = ClockUtil.hexclockID2TEClockSource(neID, value);
        if (clocksource.getClockSourceType() == 0) {
            clockSource.setClockSourceFDN("INTERNAL");
        } else {
            TEE2EUniResID resID = TEE2EBuildClockSource.constructUniResID(neID, clocksource.getSlotID(), clocksource.getPortID());
            clockSource.setClockSourceFDN(resID.getStrFDN());
        }
        clockSource.result = 0;
        return clockSource;
    }

    private static ErrorMessage getClockSourceError(String paramName, Datainterface outputData) {
        BussinessParams bussinessparam = outputData.getBussinessParams();
        int size = bussinessparam.getRowParamsCount();
        for (int i = 0; i < size; ++i) {
            RowParams rowparam = bussinessparam.getRowParams(i);
            int len = rowparam.getRowErrorsCount();
            for (int j = 0; j < len; ++j) {
                RowErrors rowError = rowparam.getRowErrors(j);
                int errorlen = rowError.getParamCount();
                for (int k = 0; k < errorlen; ++k) {
                    if (!rowError.getParam(k).getValue().equalsIgnoreCase(paramName)) continue;
                    return rowError.getErrorMessage();
                }
            }
        }
        return null;
    }

    private static Datainterface constructQueryPhyClockInput(int neID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("clockslotno", CLOCK_SLOT_ID);
        rowparams.addParam(param);
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return inputData;
    }

    private static TEQueryClockPriority getQueryBean() {
        return new TEQueryClockPriority(){

            public boolean isNeedOperationlog() {
                return false;
            }
        };
    }

    private static void logNullNEClockError(int neID) {
        e2eLogger.error("no NE Clock or NE Clock is empty. neID = " + neID);
    }

    private static void logNullRowParamsError() {
        e2eLogger.error("no rowparams in outputData.");
    }

    private static void logNullBussinessParamsError() {
        e2eLogger.error("no bussinessparams in outputData.");
    }

    private static void logBeanOperError(int neID, int retCode) {
        String tipStr = "query clock priority fail! ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        e2eLogger.error(tipStr);
    }
}

