/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EUniResID;
import com.huawei.nglct.nemgr.neadapter.functionadapter.clock.NeClockSouceObj;
import com.huawei.nglct.nemgr.ngwdm.clockptp.TEQueryPriorityBean;
import com.huawei.nglct.nemgr.ngwdm.clockptp.TEQuerySyncAttriBean;
import com.huawei.nglct.nemgr.ngwdm.e2e.clock.TEE2EGetClockDeviceUtil;
import com.huawei.nglct.nemgr.ngwdm.e2e.clock.ptpclock.TEE2EBuildClockSource;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;

public class TEE2EGetNEPTPClockAttribute {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    public static NeClockSouceObj queryPTPClockAttribute(int neID) {
        NeClockSouceObj clockSource = null;
        try {
            clockSource = TEE2EGetNEPTPClockAttribute.getPTPClockSource(neID);
            TEE2EGetNEPTPClockAttribute.queryPTPClockPri(neID, clockSource);
        }
        catch (Exception e) {
            e2eLogger.error("query ptp clock Attribute fail", (Throwable)e);
        }
        return clockSource;
    }

    private static void queryPTPClockPri(int neID, NeClockSouceObj clockSource) {
        TEQueryPriorityBean bean = new TEQueryPriorityBean();
        Datainterface inputData = TEE2EGetNEPTPClockAttribute.constructQueryPTPClockInput(neID);
        int sfid = 2106672;
        SubFunc subFunc = TEE2EGetClockDeviceUtil.createSubFunc(neID, sfid);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            return;
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEE2EGetNEPTPClockAttribute.logBeanOperError(neID, retCode);
            TEE2EGetClockDeviceUtil.printRowError(outputData);
            clockSource.result = retCode;
            clockSource.retReason = outputData.getErrorMessage().getErrorinfo();
            return;
        }
        if (null == outputData.getBussinessParams()) {
            TEE2EGetNEPTPClockAttribute.logNullBussinessParamsError();
            return;
        }
        RowParams[] rowParamsArr = outputData.getBussinessParams().getRowParams();
        if (null == rowParamsArr) {
            TEE2EGetNEPTPClockAttribute.logNullRowParamsError();
            return;
        }
        int clockpri = bean.getClockSourcePri(clockSource.getPtpClockSourceHigh() + "-" + clockSource.getPtpClockSourceLow());
        if (clockSource.getClockSourceFDN().equals("INTERNAL") && clockpri == -1) {
            clockpri = 1;
        }
        clockSource.setClockPriority(clockpri);
        ArrayList<NeClockSouceObj> tempList = new ArrayList<NeClockSouceObj>();
        int len = rowParamsArr.length;
        for (int i = 0; i < len; ++i) {
            RowParams row = rowParamsArr[i];
            String boardName = row.getParam("boardname").getValue();
            NeClockSouceObj clockObj = new NeClockSouceObj();
            if (boardName.equals("0")) {
                clockObj.setClockSourceFDN("INTERNAL");
            } else {
                String slotID = row.getParam("slotid").getValue();
                String portID = row.getParam("port").getValue();
                TEE2EUniResID resID = TEE2EBuildClockSource.constructUniResID(neID, Integer.parseInt(slotID), Integer.parseInt(portID));
                clockObj.setClockSourceFDN(resID.getStrFDN());
            }
            clockObj.setClockPriority(i + 1);
            tempList.add(clockObj);
        }
        Collections.sort(tempList);
        clockSource.setClockPriList(tempList);
    }

    private static NeClockSouceObj getPTPClockSource(int neID) {
        NeClockSouceObj clockSource = new NeClockSouceObj();
        TEQuerySyncAttriBean bean = new TEQuerySyncAttriBean();
        Datainterface inputData = TEE2EGetNEPTPClockAttribute.constructQueryPTPClockInput(neID);
        int sfid = 2106668;
        SubFunc subFunc = TEE2EGetClockDeviceUtil.createSubFunc(neID, sfid);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            return clockSource;
        }
        ErrorMessage errorMessage = TEE2EGetNEPTPClockAttribute.getClockSourceError("gid1", outputData);
        if (errorMessage != null) {
            clockSource.result = Integer.parseInt(errorMessage.getErrorcode());
            clockSource.retReason = errorMessage.getErrorinfo();
            return clockSource;
        }
        if (null == outputData.getBussinessParams()) {
            TEE2EGetNEPTPClockAttribute.logNullBussinessParamsError();
            return clockSource;
        }
        RowParams[] rowParamsArr = outputData.getBussinessParams().getRowParams();
        if (null == rowParamsArr) {
            TEE2EGetNEPTPClockAttribute.logNullRowParamsError();
            return clockSource;
        }
        String gid1value = outputData.getBussinessParams().getRowParams(0).getParam("gid1").getValue();
        String gid2value = outputData.getBussinessParams().getRowParams(0).getParam("gid2").getValue();
        clockSource.setPtpClockSourceHigh(gid1value);
        clockSource.setPtpClockSourceLow(gid2value);
        String slotID = outputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue();
        String portID = outputData.getBussinessParams().getRowParams(0).getParam("gportid").getValue();
        if (Integer.parseInt(slotID) == 0) {
            clockSource.setClockSourceFDN("INTERNAL");
        } else {
            TEE2EUniResID resID = TEE2EBuildClockSource.constructUniResID(neID, Integer.parseInt(slotID), Integer.parseInt(portID));
            clockSource.setClockSourceFDN(resID.getStrFDN());
        }
        return clockSource;
    }

    private static Datainterface constructQueryPTPClockInput(int neID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return inputData;
    }

    private static ErrorMessage getClockSourceError(String paramName, Datainterface outputData) {
        BussinessParams bussinessparam = outputData.getBussinessParams();
        int size = bussinessparam.getRowParamsCount();
        for (int i = 0; i < size; ++i) {
            RowParams rowparam = bussinessparam.getRowParams(i);
            int len = rowparam.getRowErrorsCount();
            for (int j = 0; j < len; ++j) {
                RowErrors rowError = rowparam.getRowErrors(j);
                int errorlen = rowError.getParamCount();
                for (int k = 0; k < errorlen; ++k) {
                    if (!rowError.getParam(k).getValue().equalsIgnoreCase(paramName)) continue;
                    return rowError.getErrorMessage();
                }
            }
        }
        return null;
    }

    private static void logNullRowParamsError() {
        e2eLogger.error("no rowparams in outputData.");
    }

    private static void logNullBussinessParamsError() {
        e2eLogger.error("no bussinessparams in outputData.");
    }

    private static void logBeanOperError(int neID, int retCode) {
        String tipStr = "query clock priority fail! ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        e2eLogger.error(tipStr);
    }
}

