/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.neadapter.functionadapter.clock.NeClockFreqencyModeObj;
import com.huawei.nglct.nemgr.ngwdm.clockptp.TEQuerySourceModeBean;
import com.huawei.nglct.nemgr.ngwdm.e2e.clock.TEE2EGetClockDeviceUtil;
import org.slf4j.Logger;

public class TEE2EGetClockFreqencyMode {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    public static NeClockFreqencyModeObj getNeClockFreqencyMode(int neID) {
        NeClockFreqencyModeObj modeObj = new NeClockFreqencyModeObj();
        TENEMgrInterface bean = TEE2EGetClockFreqencyMode.getQueryBean(neID);
        Datainterface inputData = TEE2EGetClockFreqencyMode.constructQueryInput(neID);
        int sfid = TEE2EGetClockFreqencyMode.getSfid();
        SubFunc subFunc = TEE2EGetClockDeviceUtil.createSubFunc(neID, sfid);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            return modeObj;
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEE2EGetClockFreqencyMode.logBeanOperError(neID, retCode);
            TEE2EGetClockDeviceUtil.printRowError(outputData);
            Param srcMode = outputData.getBussinessParams().getRowParams(0).getParam("srcmode");
            if (null != srcMode && null != srcMode.getValue()) {
                modeObj.neClockFreqencyMode = Integer.parseInt(srcMode.getValue());
                modeObj.result = 0;
            } else {
                modeObj.result = retCode;
                modeObj.retReason = outputData.getErrorMessage().getErrorinfo();
            }
            return modeObj;
        }
        if (null == outputData.getBussinessParams()) {
            TEE2EGetClockFreqencyMode.logNullBussinessParamsError();
            return modeObj;
        }
        RowParams[] rowParamsArr = outputData.getBussinessParams().getRowParams();
        if (null == rowParamsArr) {
            TEE2EGetClockFreqencyMode.logNullRowParamsError();
            return modeObj;
        }
        String value = outputData.getBussinessParams().getRowParams(0).getParam("srcmode").getValue();
        modeObj.neClockFreqencyMode = Integer.parseInt(value);
        modeObj.result = 0;
        return modeObj;
    }

    private static TENEMgrInterface getQueryBean(int neID) {
        return new TEQuerySourceModeBean(){

            public boolean isNeedOperationlog() {
                return false;
            }
        };
    }

    private static Datainterface constructQueryInput(int neID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        return inputData;
    }

    private static int getSfid() {
        return 2106722;
    }

    private static void logBeanOperError(int neID, int retCode) {
        String tipStr = "query clock FreqencyMode fail! ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logNullRowParamsError() {
        e2eLogger.error("no rowparams in outputData.");
    }

    private static void logNullBussinessParamsError() {
        e2eLogger.error("no bussinessparams in outputData.");
    }
}

