/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import org.slf4j.Logger;

public final class TEE2EGetClockDeviceUtil {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEE2EGetClockDeviceUtil() {
    }

    public static SubFunc createSubFunc(int neID, int sfid) {
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e) {
            TELogFactory.getE2ELogger().error("createSubFunc: Get SubFunc fail!", (Throwable)e);
        }
        return subFunc;
    }

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TEE2EGetClockDeviceUtil.getObjName(objName));
        errInfo.setErrorCode(retCode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    public static String getObjName(String[] objName) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objName.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objName[i]);
        }
        return objNameBuffer.toString();
    }

    public static void printRowError(Datainterface outputData) {
        BussinessParams bussiness = outputData.getBussinessParams();
        if (null == bussiness) {
            return;
        }
        RowParams[] rowParamsArr = bussiness.getRowParams();
        if (null == rowParamsArr) {
            return;
        }
        String errorCodeStr = null;
        for (RowParams rowParams : rowParamsArr) {
            int len = rowParams.getRowErrorsCount();
            for (int i = 0; i < len; ++i) {
                RowErrors[] rowErrorsArr = rowParams.getRowErrors();
                if (null == rowErrorsArr) continue;
                for (RowErrors rowErrors : rowErrorsArr) {
                    errorCodeStr = rowErrors.getErrorMessage().getErrorcode();
                    if (null == errorCodeStr || errorCodeStr.isEmpty()) continue;
                    e2eLogger.error("ne operation errorCode->" + errorCodeStr);
                }
            }
        }
    }

    public static TEErrInfoReturn constructErrInfoReturn(int neID, Datainterface outputData) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        if ("0".equals(outputData.getErrorMessage().getErrorcode())) {
            return errRet;
        }
        errRet.setResult(2);
        BussinessParams bussiness = outputData.getBussinessParams();
        if (null == bussiness) {
            String tipStr = "constructErrInfoReturn: bussiness is null! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            e2eLogger.error(tipStr);
            return TEE2EGetClockDeviceUtil.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, 1090646019);
        }
        RowParams[] rowParamsArr = bussiness.getRowParams();
        if (null == rowParamsArr) {
            String tipStr = "constructErrInfoReturn: rowParamsArr is null! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            e2eLogger.error(tipStr);
            return TEE2EGetClockDeviceUtil.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, 1090646019);
        }
        String errorCodeStr = null;
        for (RowParams rowParams : rowParamsArr) {
            int len = rowParams.getRowErrorsCount();
            for (int i = 0; i < len; ++i) {
                RowErrors[] rowErrorsArr = rowParams.getRowErrors();
                if (null == rowErrorsArr) continue;
                for (RowErrors rowErrors : rowErrorsArr) {
                    errorCodeStr = rowErrors.getErrorMessage().getErrorcode();
                    if (null == errorCodeStr || errorCodeStr.isEmpty()) continue;
                    int[] objID = new int[]{neID};
                    String[] objName = new String[]{neName};
                    TEErrInfo errInfo = new TEErrInfo();
                    errInfo.setErrorCode(Integer.parseInt(errorCodeStr));
                    errInfo.setObjName(TEE2EGetClockDeviceUtil.getObjName(objName));
                    errInfo.setObjID(objID);
                    errRet.getErrList().add(errInfo);
                    String tipStr = String.format("[neID:%d, errCode:%s]", neID, errorCodeStr);
                    e2eLogger.error(tipStr);
                }
            }
        }
        return errRet;
    }

    public static boolean isNumber(String str) {
        if (null == str || str.isEmpty()) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int getIntParam(RowParams rowparams, String paramName, int defaultValue) {
        int value = defaultValue;
        Param param = rowparams.getParam(paramName);
        if (null == param) {
            return value;
        }
        String obj = param.getValue();
        if (null == obj || obj.isEmpty()) {
            return value;
        }
        if (TEE2EGetClockDeviceUtil.isNumber(obj)) {
            value = Integer.parseInt(obj);
        }
        return value;
    }

    public static long getLongParam(RowParams rowparams, String paramName, long defaultValue) {
        long value = defaultValue;
        Param param = rowparams.getParam(paramName);
        if (null == param) {
            return value;
        }
        String obj = param.getValue();
        if (null == obj || obj.isEmpty()) {
            return value;
        }
        if (TEE2EGetClockDeviceUtil.isNumber(obj)) {
            value = Long.parseLong(obj);
        }
        return value;
    }

    public static String getStringParam(RowParams rowparams, String paramName, String defaultValue) {
        String value = defaultValue;
        Param param = rowparams.getParam(paramName);
        if (null == param) {
            return value;
        }
        String obj = param.getValue();
        if (null == obj || obj.isEmpty()) {
            return value;
        }
        value = obj;
        return value;
    }
}

