/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.bean;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockSource;
import com.huawei.nglct.nemgr.e2e.task.clock.util.TEE2EClockLog;
import com.huawei.nglct.nemgr.ngwdm.clockptp.TENEClockWriteLogBean;
import com.huawei.nglct.nemgr.ngwdm.clockptp.TEQueryOuterBaseAttrBean;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPAppendBeanProcessor;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPBuildClock;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPClockUtil;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPSpecialFor1800;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

public final class TEPTPQueryOuterClockSource {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private static final int INVALID_SUB_SLOTID = 255;
    private static final int DEFAULT_PORT_ID = 0;

    private TEPTPQueryOuterClockSource() {
    }

    public static TEErrInfoReturn queryOuterClockSource(int neID, TEE2EClockDevice device) {
        String FUNC_NAME = "TEPTPQueryOuterClockSource.queryOuterClockSource";
        TEE2EClockLog.logFuncBegin((String)"TEPTPQueryOuterClockSource.queryOuterClockSource");
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TENEMgrInterface bean = TEPTPQueryOuterClockSource.getQueryBean(neID);
        Datainterface inputData = TEPTPQueryOuterClockSource.constructQueryInput(neID, device);
        int sfid = TEPTPQueryOuterClockSource.getSfid();
        SubFunc subFunc = TEPTPClockUtil.createSubFunc(neID, sfid);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            String neName = ne.getNEName();
            TEE2EClockLog.logFuncEnd((String)"TEPTPQueryOuterClockSource.queryOuterClockSource");
            return TEPTPClockUtil.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, 1090646019);
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEPTPQueryOuterClockSource.logBeanOperError(neID, retCode);
            TEPTPClockUtil.printRowError(outputData);
            errRet = TEPTPClockUtil.constructErrInfoReturn(neID, outputData);
        }
        if (null == outputData.getBussinessParams()) {
            TEPTPQueryOuterClockSource.logNullBussinessParamsError();
            TEE2EClockLog.logFuncEnd((String)"TEPTPQueryOuterClockSource.queryOuterClockSource");
            return errRet;
        }
        if (0 == outputData.getBussinessParams().getRowParamsCount()) {
            TEPTPQueryOuterClockSource.logNullRowParamsError();
            TEE2EClockLog.logFuncEnd((String)"TEPTPQueryOuterClockSource.queryOuterClockSource");
            return errRet;
        }
        TEPTPAppendBeanProcessor.appendProcessor(neID, subFunc, inputData, outputData);
        TEE2EClockLog.logFuncEnd((String)"TEPTPQueryOuterClockSource.queryOuterClockSource");
        return errRet;
    }

    private static int getSfid() {
        return 2106676;
    }

    private static Datainterface constructQueryInput(int neID, TEE2EClockDevice device) {
        if (TEPTPSpecialFor1800.isOSN1800(neID)) {
            return TEPTPQueryOuterClockSource.constructQueryInput4Osn1800(neID);
        }
        return TEPTPQueryOuterClockSource.constructQueryInput4Ngwdm(neID);
    }

    private static Datainterface constructQueryInput4Osn1800(int neID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = null;
        List<TEBoard> clockBoardList = TEPTPSpecialFor1800.getClockBoardList(neID);
        if (clockBoardList.isEmpty()) {
            return null;
        }
        for (TEBoard board : clockBoardList) {
            rowparams = new RowParams();
            bussiness.addRowParams(rowparams);
            TEPTPClockUtil.addParam(rowparams, "neid", neID);
            TEPTPClockUtil.addParam(rowparams, "subslotid", 255);
            TEPTPClockUtil.addParam(rowparams, "slotid", board.getSlotID());
            TEPTPClockUtil.addParam(rowparams, "port", 0);
        }
        return inputData;
    }

    private static Datainterface constructQueryInput4Ngwdm(int neID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        bussiness.addRowParams(rowparams);
        TEPTPClockUtil.addParam(rowparams, "neid", neID);
        return inputData;
    }

    private static TENEMgrInterface getQueryBean(int neID) {
        TENEClockWriteLogBean bean = null;
        int TIMEOUT = 20;
        bean = TEPTPSpecialFor1800.isOSN1800(neID) ? new TENEClockWriteLogBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            public int getTimeOut() {
                return 20;
            }
        } : new TEQueryOuterBaseAttrBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            public int getTimeOut() {
                return 20;
            }
        };
        return bean;
    }

    public static void parseAttributeFromRowParams(int neID, TEE2EClockDevice device, RowParams[] rowParamsArr) {
        RowParams rowParams2 = null;
        TEPTPQueryOuterClockSource.clearOuterClock(device);
        for (RowParams rowParams2 : rowParamsArr) {
            if (0 != rowParams2.getRowErrorsCount()) continue;
            TEE2EClockSource clock = null;
            int slotID = TEPTPClockUtil.getIntParam(rowParams2, "slotid", -1);
            int portID = TEPTPClockUtil.getIntParam(rowParams2, "port", -1);
            clock = TEPTPBuildClock.buildClockSource(neID, slotID, portID, 3);
            device.getClockSourceList().add(clock);
        }
    }

    private static void clearOuterClock(TEE2EClockDevice device) {
        List clockSourceList = device.getClockSourceList();
        Iterator iter = clockSourceList.iterator();
        TEE2EClockSource clock = null;
        while (iter.hasNext()) {
            clock = (TEE2EClockSource)iter.next();
            if (3 != clock.getType()) continue;
            iter.remove();
        }
    }

    private static void logBeanOperError(int neID, int retCode) {
        String tipStr = "query clock subnet fail! ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logNullRowParamsError() {
        e2eLogger.error("no rowparams in outputData.");
    }

    private static void logNullBussinessParamsError() {
        e2eLogger.error("no bussinessparams in outputData.");
    }
}

