/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.bean;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.Input;
import com.huawei.nglct.common.functions.OperObject;
import com.huawei.nglct.common.functions.Output;
import com.huawei.nglct.common.functions.Param;
import com.huawei.nglct.common.functions.QxMapping;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.jni.nelist.TEGetLogicNEIDService;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EBMCData;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockPort;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockSource;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EPortClockSourceInfo;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EUniResID;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TESlotPortKey;
import com.huawei.nglct.nemgr.e2e.task.clock.util.TEE2EClockLog;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPBuildClock;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPClockUtil;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPMOConverter;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPNgwdmPortMapping;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPSpecialFor1800;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.fdn.FDNUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public final class TEPTPQueryClockInfo {
    private static final int QUERY_BMC_LOCAL_PORT = 65535;
    private static final int NO_USE_SLOTID = 65535;
    private static final int INTERFACEID_SLOT_OFFSET = 4;
    private static final int INTERFACEID_SHELF_OFFSET = 11;
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEPTPQueryClockInfo() {
    }

    public static TEErrInfoReturn queryClockDeviceBasicInfo(int neID, TEE2EClockDevice clockDevice) {
        String FUNC_NAME = "TEPTPQueryClockInfo.queryClockDeviceBasicInfo";
        TEE2EClockLog.logFuncBegin((String)"TEPTPQueryClockInfo.queryClockDeviceBasicInfo");
        SubFunc subFunc = TEPTPQueryClockInfo.buildQueryClockDeviceInfoSubFunc();
        Datainterface inputData = TEPTPQueryClockInfo.buildQueryClockDeviceInfoInput(neID);
        TEErrInfoReturn errRet1 = new TEErrInfoReturn();
        if (null == inputData) {
            TEE2EClockLog.logFuncEnd((String)"TEPTPQueryClockInfo.queryClockDeviceBasicInfo");
            return errRet1;
        }
        List<Operation> operationList = TEPTPQueryClockInfo.buildOperaion(neID, subFunc, inputData);
        if (null == operationList || operationList.isEmpty()) {
            TEErrInfoReturn tempErrRet = TEPTPClockUtil.constructErrInfoReturn(neID, 1090646019);
            errRet1.setResult(1090650122);
            errRet1.addErrInfo(tempErrRet.getErrList());
            TEE2EClockLog.logFuncEnd((String)"TEPTPQueryClockInfo.queryClockDeviceBasicInfo");
            return errRet1;
        }
        int retCode = TEPTPQueryClockInfo.sendMessage(neID, operationList, subFunc);
        if (0 != retCode) {
            TEErrInfoReturn tempErrRet = TEPTPClockUtil.constructErrInfoReturn(neID, 1090646019);
            errRet1.setResult(1090650122);
            errRet1.addErrInfo(tempErrRet.getErrList());
            TEE2EClockLog.logFuncEnd((String)"TEPTPQueryClockInfo.queryClockDeviceBasicInfo");
            return errRet1;
        }
        if (TEPTPClockUtil.isNotLogin(neID, operationList)) {
            TEErrInfoReturn tempErrRet = TEPTPClockUtil.constructErrInfoReturn(neID, 37126);
            errRet1.addErrInfo(tempErrRet.getErrList());
            errRet1.setResult(1090650122);
            return errRet1;
        }
        TEPTPQueryClockInfo.setClockOnQueryClockBasicInfo(neID, operationList, clockDevice);
        TEE2EClockLog.logFuncEnd((String)"TEPTPQueryClockInfo.queryClockDeviceBasicInfo");
        return errRet1;
    }

    private static SubFunc buildQueryClockDeviceInfoSubFunc() {
        SubFunc subFunc = new SubFunc();
        Input input = new Input();
        subFunc.setInput(input);
        Output output = new Output();
        subFunc.setOutput(output);
        OperObject operObj = new OperObject();
        subFunc.setOperObject(operObj);
        subFunc.getInput().addParam(TEPTPQueryClockInfo.createFuncParam("neid"));
        subFunc.getInput().addParam(TEPTPQueryClockInfo.createFuncParam("neid"));
        subFunc.getOutput().addParam(TEPTPQueryClockInfo.createFuncParam("neid"));
        ArrayList<QxMapping> newQxList = new ArrayList<QxMapping>();
        TEPTPQueryClockInfo.addQxMapping(newQxList, "NSCMD_CFG_GET_PTPMODE", 0);
        TEPTPQueryClockInfo.addQxMapping(newQxList, "NSCMD_CFG_GET_PTP_STATICBMC_ENABLE", 1);
        TEPTPQueryClockInfo.addQxMapping(newQxList, "NSCMD_CFG_GET_PTP_GRANDMASTER", 2);
        TEPTPQueryClockInfo.addQxMapping(newQxList, "NSCMD_CFG_GET_PTPDOMAIN", 3);
        TEPTPQueryClockInfo.addQxMapping(newQxList, "NSCMD_CFG_GET_PTPTIMEATTR", 4);
        TEPTPQueryClockInfo.addQxMapping(newQxList, "NSCMD_CFG_GET_PTPTIMESRCID", 5);
        subFunc.setQxMapping(newQxList);
        return subFunc;
    }

    private static List<Operation> buildOperaion(int neID, SubFunc subFunc, Datainterface inputData) {
        try {
            return TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neID);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("get Operation fail!", (Throwable)e);
            return null;
        }
    }

    private static Datainterface buildQueryClockDeviceInfoInput(int neID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = null;
        if (TEPTPSpecialFor1800.isOSN1800(neID)) {
            List<TEBoard> clockBoardList = TEPTPSpecialFor1800.getClockBoardList(neID);
            if (clockBoardList.isEmpty()) {
                return null;
            }
            for (TEBoard board : clockBoardList) {
                rowparams = new RowParams();
                bussiness.addRowParams(rowparams);
                TEPTPClockUtil.addParam(rowparams, "neid", neID);
                TEPTPClockUtil.addParam(rowparams, "subslotid", 255);
                TEPTPClockUtil.addParam(rowparams, "slotid", board.getSlotID());
                TEPTPClockUtil.addParam(rowparams, "port", 65535);
            }
        } else {
            rowparams = new RowParams();
            bussiness.addRowParams(rowparams);
            TEPTPClockUtil.addParam(rowparams, "neid", neID);
            TEPTPClockUtil.addParam(rowparams, "subslotid", 255);
            TEPTPClockUtil.addParam(rowparams, "slotid", 65535);
            TEPTPClockUtil.addParam(rowparams, "port", 65535);
        }
        return inputData;
    }

    public static TEErrInfoReturn queryPortClockSourceInfo(int neID, TEE2EClockDevice clockDevice) {
        String FUNC_NAME = "TEPTPQueryClockInfo.queryPortClockSourceInfo";
        TEE2EClockLog.logFuncBegin((String)"TEPTPQueryClockInfo.queryPortClockSourceInfo");
        TEErrInfoReturn errRet2 = new TEErrInfoReturn();
        SubFunc subFunc = TEPTPQueryClockInfo.buildQueryPortClockSourceInfoSubFunc();
        Datainterface inputData = TEPTPQueryClockInfo.buildQueryPortClockSourceInfoInput(neID, clockDevice);
        if (null == inputData || 0 == inputData.getBussinessParams().getRowParamsCount()) {
            TEE2EClockLog.logFuncEnd((String)"TEPTPQueryClockInfo.queryPortClockSourceInfo");
            return errRet2;
        }
        List<Operation> operationList = TEPTPQueryClockInfo.buildOperaion(neID, subFunc, inputData);
        if (null == operationList || operationList.isEmpty()) {
            TEErrInfoReturn tempErrRet = TEPTPClockUtil.constructErrInfoReturn(neID, 1090646019);
            errRet2.setResult(1090650122);
            errRet2.addErrInfo(tempErrRet.getErrList());
            TEE2EClockLog.logFuncEnd((String)"TEPTPQueryClockInfo.queryPortClockSourceInfo");
            return errRet2;
        }
        int retCode = TEPTPQueryClockInfo.sendMessage(neID, operationList, subFunc);
        if (0 != retCode) {
            TEErrInfoReturn tempErrRet = TEPTPClockUtil.constructErrInfoReturn(neID, 1090646019);
            errRet2.setResult(1090650122);
            errRet2.addErrInfo(tempErrRet.getErrList());
            TEE2EClockLog.logFuncEnd((String)"TEPTPQueryClockInfo.queryPortClockSourceInfo");
            return errRet2;
        }
        if (TEPTPClockUtil.isNotLogin(neID, operationList)) {
            TEErrInfoReturn tempErrRet = TEPTPClockUtil.constructErrInfoReturn(neID, 37126);
            errRet2.addErrInfo(tempErrRet.getErrList());
            errRet2.setResult(1090650122);
            return errRet2;
        }
        TEPTPQueryClockInfo.setClockOnQueryPortClock(operationList, clockDevice);
        TEE2EClockLog.logFuncEnd((String)"TEPTPQueryClockInfo.queryPortClockSourceInfo");
        return errRet2;
    }

    public static TEErrInfoReturn querySysTimeAndClockLockState(int neID, TEE2EClockDevice clockDevice) {
        String FUNC_NAME = "TEPTPQueryClockInfo.querySysTimeAndClockState";
        TEE2EClockLog.logFuncBegin((String)"TEPTPQueryClockInfo.querySysTimeAndClockState");
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        List<Operation> operationList = TEPTPQueryClockInfo.buildLockStateOperationList(neID);
        if (null == operationList || operationList.isEmpty()) {
            TEErrInfoReturn tempErrRet = TEPTPClockUtil.constructErrInfoReturn(neID, 1090646019);
            errRet.setResult(1090650122);
            errRet.addErrInfo(tempErrRet.getErrList());
            TEE2EClockLog.logFuncEnd((String)"TEPTPQueryClockInfo.querySysTimeAndClockState");
            return errRet;
        }
        int retCode = TEPTPQueryClockInfo.sendMessage(neID, operationList, null);
        if (0 != retCode) {
            TEErrInfoReturn tempErrRet = TEPTPClockUtil.constructErrInfoReturn(neID, 1090646019);
            errRet.setResult(1090650122);
            errRet.addErrInfo(tempErrRet.getErrList());
            TEE2EClockLog.logFuncEnd((String)"TEPTPQueryClockInfo.querySysTimeAndClockState");
            return errRet;
        }
        if (TEPTPClockUtil.isNotLogin(neID, operationList)) {
            TEErrInfoReturn tempErrRet = TEPTPClockUtil.constructErrInfoReturn(neID, 37126);
            errRet.addErrInfo(tempErrRet.getErrList());
            errRet.setResult(1090650122);
            return errRet;
        }
        TEPTPQueryClockInfo.setTimeAndClockLockState(operationList, clockDevice);
        TEE2EClockLog.logFuncEnd((String)"TEPTPQueryClockInfo.querySysTimeAndClockState");
        return errRet;
    }

    private static void setTimeAndClockLockState(List<Operation> operationList, TEE2EClockDevice clockDevice) {
        String operName = null;
        for (Operation oper : operationList) {
            operName = oper.getName();
            if ("NSCMD_CFG_GET_SYSCLOCK_LOCKSTATE".equals(operName)) {
                int clockState = TEPTPClockUtil.getIntPartValue(oper, "lockstate", -1);
                clockDevice.setPoClockLockState(clockState);
                continue;
            }
            if (!"NSCMD_CFG_GET_SYSTIME_LOCKSTATE".equals(operName)) continue;
            int timeState = TEPTPClockUtil.getIntPartValue(oper, "lockstate", -1);
            clockDevice.setPoTimeLockState(timeState);
        }
    }

    private static List<Operation> buildLockStateOperationList(int neid) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation clockOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_SYSCLOCK_LOCKSTATE");
        Operation timeOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_SYSTIME_LOCKSTATE");
        if (clockOperation != null) {
            operationList.add(clockOperation);
        }
        if (timeOperation != null) {
            operationList.add(timeOperation);
        }
        return operationList;
    }

    private static SubFunc buildQueryPortClockSourceInfoSubFunc() {
        SubFunc subFunc = new SubFunc();
        Input input = new Input();
        subFunc.setInput(input);
        Output output = new Output();
        subFunc.setOutput(output);
        OperObject operObj = new OperObject();
        subFunc.setOperObject(operObj);
        subFunc.getInput().addParam(TEPTPQueryClockInfo.createFuncParam("neid"));
        subFunc.getInput().addParam(TEPTPQueryClockInfo.createFuncParam("slotid"));
        subFunc.getOutput().addParam(TEPTPQueryClockInfo.createFuncParam("port"));
        ArrayList<QxMapping> newQxList = new ArrayList<QxMapping>();
        TEPTPQueryClockInfo.addQxMapping(newQxList, "BDCMD_CFG_GET_PTPMODE", 0);
        TEPTPQueryClockInfo.addQxMapping(newQxList, "NSCMD_CFG_GET_PTPPORTSTATE", 1);
        TEPTPQueryClockInfo.addQxMapping(newQxList, "NSCMD_CFG_GET_PTPPORTREALSTATE", 2);
        TEPTPQueryClockInfo.addQxMapping(newQxList, "NSCMD_CFG_GET_PTPSRCLINKSTAT", 3);
        subFunc.setQxMapping(newQxList);
        return subFunc;
    }

    private static Datainterface buildQueryPortClockSourceInfoInput(int neID, TEE2EClockDevice clockDevice) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        List clockPortList = clockDevice.getClockPortList();
        if (null == clockPortList || clockPortList.isEmpty()) {
            return null;
        }
        for (TEE2EClockPort clockPort : clockPortList) {
            TEE2EUniResID portIndex = clockPort.getPortIndex();
            String fdn = portIndex.getStrFDN();
            int slotID = TEBoardUtil.neToSlotIDNM((int)FDNUtil.getFrameID((String)fdn), (int)FDNUtil.getSlotID((String)fdn));
            int portID = TEConfigurationDataMgr.getPortRelativeID((int)FDNUtil.getPortID((String)fdn));
            if (-1 == slotID && -1 == portID) continue;
            RowParams rowparams = new RowParams();
            bussiness.addRowParams(rowparams);
            TEPTPClockUtil.addParam(rowparams, "neid", neID);
            TEPTPClockUtil.addParam(rowparams, "slotid", slotID);
            TEPTPClockUtil.addParam(rowparams, "subslotid", 255);
            TEPTPClockUtil.addParam(rowparams, "port", portID);
        }
        return inputData;
    }

    public static TEErrInfoReturn queryOuterClockSourceInfo(int neID, TEE2EClockDevice clockDevice) {
        String FUNC_NAME = "TEE2EQueryClockPortList.queryOuterClockSourceInfo";
        TEE2EClockLog.logFuncBegin((String)"TEE2EQueryClockPortList.queryOuterClockSourceInfo");
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        SubFunc subFunc = TEPTPQueryClockInfo.buildQueryOuterClockSourceInfoSubFunc();
        Datainterface inputData = TEPTPQueryClockInfo.buildQueryOuterClockSourceInfoInput(neID, clockDevice);
        if (null == inputData) {
            TEE2EClockLog.logFuncEnd((String)"TEE2EQueryClockPortList.queryOuterClockSourceInfo");
            return errRet;
        }
        List<Operation> operationList = TEPTPQueryClockInfo.buildOperaion(neID, subFunc, inputData);
        if (null == operationList || operationList.isEmpty()) {
            TEErrInfoReturn tempErrRet = TEPTPClockUtil.constructErrInfoReturn(neID, 1090646019);
            errRet.setResult(1090650122);
            errRet.addErrInfo(tempErrRet.getErrList());
            TEE2EClockLog.logFuncEnd((String)"TEE2EQueryClockPortList.queryOuterClockSourceInfo");
            return errRet;
        }
        int retCode = TEPTPQueryClockInfo.sendMessage(neID, operationList, subFunc);
        if (0 != retCode) {
            TEErrInfoReturn tempErrRet = TEPTPClockUtil.constructErrInfoReturn(neID, 1090646019);
            errRet.setResult(1090650122);
            errRet.addErrInfo(tempErrRet.getErrList());
            TEE2EClockLog.logFuncEnd((String)"TEE2EQueryClockPortList.queryOuterClockSourceInfo");
            return errRet;
        }
        if (TEPTPClockUtil.isNotLogin(neID, operationList)) {
            TEErrInfoReturn tempErrRet = TEPTPClockUtil.constructErrInfoReturn(neID, 37126);
            errRet.addErrInfo(tempErrRet.getErrList());
            errRet.setResult(1090650122);
            return errRet;
        }
        TEPTPQueryClockInfo.setClockOnQueryOuterClockSource(operationList, clockDevice);
        TEE2EClockLog.logFuncEnd((String)"TEE2EQueryClockPortList.queryOuterClockSourceInfo");
        return errRet;
    }

    private static SubFunc buildQueryOuterClockSourceInfoSubFunc() {
        SubFunc subFunc = new SubFunc();
        Input input = new Input();
        subFunc.setInput(input);
        Output output = new Output();
        subFunc.setOutput(output);
        OperObject operObj = new OperObject();
        subFunc.setOperObject(operObj);
        subFunc.getInput().addParam(TEPTPQueryClockInfo.createFuncParam("neid"));
        subFunc.getInput().addParam(TEPTPQueryClockInfo.createFuncParam("slotid"));
        subFunc.getOutput().addParam(TEPTPQueryClockInfo.createFuncParam("port"));
        ArrayList<QxMapping> newQxList = new ArrayList<QxMapping>();
        TEPTPQueryClockInfo.addQxMapping(newQxList, "NSCMD_CFG_GET_PTPTIMEATTR", 0);
        subFunc.setQxMapping(newQxList);
        return subFunc;
    }

    private static Datainterface buildQueryOuterClockSourceInfoInput(int neID, TEE2EClockDevice clockDevice) {
        List<TEE2EClockSource> clockSourceList = TEPTPBuildClock.getClockSource(clockDevice, 3);
        if (clockSourceList.isEmpty()) {
            return null;
        }
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        for (TEE2EClockSource clockSource : clockSourceList) {
            RowParams rowparams = new RowParams();
            bussiness.addRowParams(rowparams);
            String clockID = clockSource.getClockID();
            if (!TEStringUtils.isNumber((String)clockID)) continue;
            long longClockID = Long.parseLong(clockID);
            int slotID = TEPTPMOConverter.getSlotIDFromClockID(longClockID);
            int portID = TEPTPMOConverter.getPortIDFromClockID(longClockID);
            TEPTPClockUtil.addParam(rowparams, "neid", neID);
            TEPTPClockUtil.addParam(rowparams, "slotid", slotID);
            TEPTPClockUtil.addParam(rowparams, "subslotid", 255);
            TEPTPClockUtil.addParam(rowparams, "port", portID);
        }
        return inputData;
    }

    private static int sendMessage(int neid, List<Operation> operationList, SubFunc subFunc) {
        int retCode = 0;
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, (ArrayList)operationList, TEPTPQueryClockInfo.getTimeOut(), subFunc);
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    private static int getTimeOut() {
        int TIME_OUT = 20;
        return 20;
    }

    private static void setClockOnQueryClockBasicInfo(int neID, List<Operation> operationList, TEE2EClockDevice clockDevice) {
        String operName = null;
        for (Operation oper : operationList) {
            operName = oper.getName();
            if ("NSCMD_CFG_GET_PTPMODE".equals(operName)) {
                TEPTPQueryClockInfo.handleNSCMD_CFG_GET_PTPMODE(clockDevice, oper);
                continue;
            }
            if ("NSCMD_CFG_GET_PTP_STATICBMC_ENABLE".equals(operName)) {
                TEPTPQueryClockInfo.handleNSCMD_CFG_GET_PTP_STATICBMC_ENABLE(clockDevice, oper);
                continue;
            }
            if ("NSCMD_CFG_GET_PTP_GRANDMASTER".equals(operName)) {
                TEPTPQueryClockInfo.handleNSCMD_CFG_GET_PTP_GRANDMASTER(neID, clockDevice, oper);
                continue;
            }
            if ("NSCMD_CFG_GET_PTPDOMAIN".equals(operName)) {
                TEPTPQueryClockInfo.handleNSCMD_CFG_GET_PTPDOMAIN(clockDevice, oper);
                continue;
            }
            if ("NSCMD_CFG_GET_PTPTIMEATTR".equals(operName)) {
                TEPTPQueryClockInfo.handleNSCMD_CFG_GET_PTPTIMEATTRForLocal(clockDevice, oper);
                continue;
            }
            if ("NSCMD_CFG_GET_PTPTIMESRCID".equals(operName)) {
                TEPTPQueryClockInfo.handleNSCMD_CFG_GET_PTPTIMESRCID(clockDevice, oper);
                continue;
            }
            e2eLogger.info("not handle operName->" + operName);
        }
    }

    private static void handleNSCMD_CFG_GET_PTPMODE(TEE2EClockDevice clockDevice, Operation oper) {
        int workmode = TEPTPClockUtil.getIntPartValue(oper, "workmode", -1);
        clockDevice.setPtpClockType(workmode);
    }

    private static void handleNSCMD_CFG_GET_PTP_STATICBMC_ENABLE(TEE2EClockDevice clockDevice, Operation oper) {
        int staticBMC = TEPTPClockUtil.getIntPartValue(oper, "staticBMC", -1);
        clockDevice.setStaticBMC(staticBMC);
    }

    private static void handleNSCMD_CFG_GET_PTP_GRANDMASTER(int neID, TEE2EClockDevice clockDevice, Operation oper) {
        int gslotid = TEPTPClockUtil.getIntPartValue(oper, "slotid", -1);
        if (gslotid > 256 && gslotid < 65536) {
            gslotid = TEBoardUtil.subrackIDNEToNM((int)gslotid);
        }
        int gportid = TEPTPClockUtil.getIntPartValue(oper, "gportid", -1);
        int queryPortId = TEPTPClockUtil.getInputPartValue(oper, "slotid", -1);
        int gneid = TEPTPQueryClockInfo.getGrandNEID(oper, "gid2", gportid, -1);
        TEPTPQueryClockInfo.setRealGrandClock(neID, clockDevice, gneid, gslotid, gportid, queryPortId);
    }

    private static void handleNSCMD_CFG_GET_PTPDOMAIN(TEE2EClockDevice clockDevice, Operation oper) {
        int ptpdomain = TEPTPClockUtil.getIntPartValue(oper, "ptpdomain", -1);
        clockDevice.setClockDomain(ptpdomain);
    }

    private static void handleNSCMD_CFG_GET_PTPTIMEATTRForLocal(TEE2EClockDevice clockDevice, Operation oper) {
        TEE2EBMCData bmcData = new TEE2EBMCData();
        bmcData.setTimelevel(TEPTPClockUtil.getIntPartValue(oper, "timelevel", -1));
        bmcData.setTimeprecision(TEPTPClockUtil.getIntPartValue(oper, "timeprecision", -1));
        bmcData.setClocktype(TEPTPClockUtil.getIntPartValue(oper, "clocktype", -1));
        bmcData.setClockpri1(TEPTPClockUtil.getIntPartValue(oper, "clockpri1", -1));
        bmcData.setClockpri2(TEPTPClockUtil.getIntPartValue(oper, "clockpri2", -1));
        bmcData.setClockoffset(TEPTPClockUtil.getIntPartValue(oper, "clockoffset", -1));
        clockDevice.setBmcData(bmcData);
    }

    private static void handleNSCMD_CFG_GET_PTPTIMESRCID(TEE2EClockDevice clockDevice, Operation oper) {
        String srcidhigh = TEPTPClockUtil.getStringPartValue(oper, "srcidhigh", "FFFFFFFF");
        String srcidlow = TEPTPClockUtil.getStringPartValue(oper, "srcidlow", "FFFFFFFF");
        clockDevice.setNeClockSrcID(srcidhigh + srcidlow);
    }

    private static int getGrandNEID(Operation oper, String paramName, int gportid, int defaultValue) {
        int gneid = TEPTPQueryClockInfo.getClockSrcLogicNEID(oper, paramName, defaultValue);
        if (-1 == gneid && -1 != gportid) {
            gneid = -200;
        }
        return gneid;
    }

    private static int getClockSrcLogicNEID(Operation oper, String paramName, int defaultValue) {
        int grandNeID = defaultValue;
        String grandPhyNEIDStr = TEPTPClockUtil.getStringPartValue(oper, paramName, String.valueOf(defaultValue));
        int phyNEID = TEPTPBuildClock.getPhyNEIDFromHex(grandPhyNEIDStr);
        if (-1 == phyNEID) {
            return grandNeID;
        }
        TENE grandNE = TENEListMgr.getInstance().getPhyNE(phyNEID);
        if (null != grandNE) {
            grandNeID = grandNE.getNEID();
        } else {
            grandNeID = TEGetLogicNEIDService.getLogicNEID((int)phyNEID);
            if (-1 == grandNeID) {
                e2eLogger.error("no found ne. grandPhyNEIDStr->" + grandPhyNEIDStr);
            }
        }
        return grandNeID;
    }

    protected static int getClockSrcPhyNEID(Operation oper, String paramName, int defaultValue) {
        String grandPhyNEIDStr = TEPTPClockUtil.getStringPartValue(oper, paramName, String.valueOf(defaultValue));
        int phyNEID = TEPTPBuildClock.getPhyNEIDFromHex(grandPhyNEIDStr);
        return phyNEID;
    }

    private static void setRealGrandClock(int neID, TEE2EClockDevice clockDevice, int gneid, int gslotid, int gportid, int queryPortId) {
        int[] oldGrandMaster = clockDevice.getGrandMaster();
        int oldGneid = oldGrandMaster[0];
        int oldGslotid = oldGrandMaster[1];
        int oldGportid = oldGrandMaster[2];
        if (TEPTPBuildClock.isInvalidClock(gneid, gslotid, gportid)) {
            return;
        }
        if (TEPTPBuildClock.isInnerClock(neID, gneid, gportid)) {
            if (TEPTPBuildClock.isInvalidClock(oldGneid, oldGslotid, oldGportid)) {
                clockDevice.setGrandMaster(new int[]{gneid, gslotid, gportid, queryPortId});
            }
            return;
        }
        clockDevice.setGrandMaster(new int[]{gneid, gslotid, gportid, queryPortId});
    }

    private static void setClockOnQueryPortClock(List<Operation> operationList, TEE2EClockDevice clockDevice) {
        Map<TESlotPortKey, TEE2EClockPort> clockPortMap = TEPTPQueryClockInfo.getClockPortListMap(clockDevice);
        Map<TESlotPortKey, TEE2EClockSource> portClockSourceMap = TEPTPQueryClockInfo.getClockSourceMap(clockDevice, 2);
        String operName = null;
        for (Operation oper : operationList) {
            operName = oper.getName();
            if ("BDCMD_CFG_GET_PTPMODE".equals(operName)) {
                TEPTPQueryClockInfo.handleBDCMD_CFG_GET_PTPMODE(clockPortMap, oper);
                continue;
            }
            if ("NSCMD_CFG_GET_PTPPORTREALSTATE".equals(operName)) {
                TEPTPQueryClockInfo.handleNSCMD_CFG_GET_PTPPORTREALSTATE(clockPortMap, oper);
                continue;
            }
            if (!"NSCMD_CFG_GET_PTPSRCLINKSTAT".equals(operName)) continue;
            TEPTPQueryClockInfo.handleNSCMD_CFG_GET_PTPSRCLINKSTAT(oper, clockPortMap, portClockSourceMap, clockDevice);
        }
    }

    protected static void handleNSCMD_CFG_GET_PTPPORTSTATE(TEE2EClockDevice clockDevice, Map<TESlotPortKey, TEE2EClockPort> clockPortMap, Operation oper) {
        int slotID = TEPTPClockUtil.getIntPartValue(oper, "slotid", -1);
        int portID = TEPTPClockUtil.getIntPartValue(oper, "port", -1);
        if (1 == clockDevice.getStaticBMC()) {
            int portstatus = TEPTPClockUtil.getIntPartValue(oper, "portstatus", -1);
            TEE2EClockPort clockPort = clockPortMap.get(new TESlotPortKey(slotID, portID));
            if (null != clockPort) {
                clockPort.setMode(portstatus);
            }
        }
    }

    private static void handleNSCMD_CFG_GET_PTPPORTREALSTATE(Map<TESlotPortKey, TEE2EClockPort> clockPortMap, Operation oper) {
        int slotID = TEPTPClockUtil.getIntPartValue(oper, "slotid", -1);
        int portID = TEPTPClockUtil.getIntPartValue(oper, "port", -1);
        int portstatus = TEPTPClockUtil.getIntPartValue(oper, "portrealstatus", -1);
        TEE2EClockPort clockPort = clockPortMap.get(new TESlotPortKey(slotID, portID));
        if (null != clockPort) {
            clockPort.setMode(portstatus);
        }
    }

    private static void handleBDCMD_CFG_GET_PTPMODE(Map<TESlotPortKey, TEE2EClockPort> clockPortMap, Operation oper) {
        int slotID = TEPTPClockUtil.getIntPartValue(oper, "slotid", -1);
        int portID = TEPTPClockUtil.getIntPartValue(oper, "port", -1);
        int portworkmode = TEPTPClockUtil.getIntPartValue(oper, "portworkmode", -1);
        TEE2EClockPort clockPort = clockPortMap.get(new TESlotPortKey(slotID, portID));
        if (null != clockPort) {
            clockPort.setPortClockType(portworkmode);
        }
    }

    private static void handleNSCMD_CFG_GET_PTPSRCLINKSTAT(Operation oper, Map<TESlotPortKey, TEE2EClockPort> clockPortMap, Map<TESlotPortKey, TEE2EClockSource> clockSourceMap, TEE2EClockDevice clockDevice) {
        TEE2EClockSource clockSource;
        int slotID = TEPTPClockUtil.getIntPartValue(oper, "slotid", -1);
        int portID = TEPTPClockUtil.getIntPartValue(oper, "port", -1);
        int linkstatus = TEPTPClockUtil.getIntPartValue(oper, "linkstatus", -1);
        String srcidhigh = TEPTPClockUtil.getStringPartValue(oper, "srcidhigh", "FFFFFFFF");
        String srcidlow = TEPTPClockUtil.getStringPartValue(oper, "srcidlow", "FFFFFFFF");
        String interfaceid = TEPTPClockUtil.getStringPartValue(oper, "interfaceid", "FFFF");
        TESlotPortKey slotPortKey = new TESlotPortKey(slotID, portID);
        TEE2EClockPort clockPort = clockPortMap.get(slotPortKey);
        if (null != clockPort) {
            clockPort.setState(linkstatus);
        }
        if (null == (clockSource = clockSourceMap.get(slotPortKey))) {
            return;
        }
        interfaceid = interfaceid.trim();
        TEE2EPortClockSourceInfo portClock = clockSource.getPoPortClockSource();
        TEPTPQueryClockInfo.resetCurrentPoClockSource(clockDevice, slotID, portID, portClock);
        if ("FFFFFFFF".equals(srcidlow) || interfaceid.trim().isEmpty() || "FFFF".equals(interfaceid)) {
            return;
        }
        TEPTPQueryClockInfo.resetUpStreamOnNotRecogniseSrc(clockDevice, slotID, portID, srcidhigh, srcidlow, interfaceid, portClock);
    }

    private static void resetCurrentPoClockSource(TEE2EClockDevice clockDevice, int slotID, int portID, TEE2EPortClockSourceInfo portClock) {
        try {
            portClock.setPoClockSource(clockDevice.getNeClockSrcID().toLowerCase());
            portClock.setPoInPortId(TEPTPQueryClockInfo.buildNEinterfaceID(clockDevice.getNeID(), slotID, portID));
        }
        catch (Exception e) {
            e2eLogger.error("set current port clock source fail!", (Throwable)e);
        }
    }

    private static void resetUpStreamOnNotRecogniseSrc(TEE2EClockDevice clockDevice, int slotID, int portID, String srcidhigh, String srcidlow, String interfaceid, TEE2EPortClockSourceInfo portClockSourceInfo) {
        try {
            portClockSourceInfo.setType(2);
            portClockSourceInfo.setPoUpstreamClockSource(srcidhigh.toLowerCase() + srcidlow.toLowerCase());
            portClockSourceInfo.setPoUpstreamPortId(Integer.parseInt(interfaceid, 16));
            portClockSourceInfo.setPoUpstreamName("");
        }
        catch (Exception e) {
            e2eLogger.error("get second port clock src fail!", (Throwable)e);
        }
    }

    private static int buildNEinterfaceID(int neID, int slotID, int portID) {
        int shelfID = TEPTPClockUtil.getShelfIDFromAbstractSlotID(slotID);
        int aSlotID = TEPTPClockUtil.getSlotIDFromAbstractSlotID(slotID);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        int qxPort = TEPTPNgwdmPortMapping.getInstance().getMappingQxPort(boardType, portID);
        return (shelfID << 11) + (aSlotID << 4) + qxPort;
    }

    private static void setClockOnQueryOuterClockSource(List<Operation> operationList, TEE2EClockDevice clockDevice) {
        Map<TESlotPortKey, TEE2EClockSource> outerClockSourceMap = TEPTPQueryClockInfo.getClockSourceMap(clockDevice, 3);
        for (Operation oper : operationList) {
            if (!"NSCMD_CFG_GET_PTPTIMEATTR".equals(oper.getName())) continue;
            TEPTPQueryClockInfo.handleNSCMD_CFG_GET_PTPTIMEATTRForOuter(outerClockSourceMap, oper);
        }
    }

    private static void handleNSCMD_CFG_GET_PTPTIMEATTRForOuter(Map<TESlotPortKey, TEE2EClockSource> outerClockSourceMap, Operation oper) {
        int slotID = TEPTPClockUtil.getIntPartValue(oper, "slotid", -1);
        int portID = TEPTPClockUtil.getIntPartValue(oper, "port", -1);
        TEE2EBMCData bmcData = new TEE2EBMCData();
        bmcData.setTimelevel(TEPTPClockUtil.getIntPartValue(oper, "timelevel", -1));
        bmcData.setTimeprecision(TEPTPClockUtil.getIntPartValue(oper, "timeprecision", -1));
        bmcData.setClocktype(TEPTPClockUtil.getIntPartValue(oper, "clocktype", -1));
        bmcData.setClockpri1(TEPTPClockUtil.getIntPartValue(oper, "clockpri1", -1));
        bmcData.setClockpri2(TEPTPClockUtil.getIntPartValue(oper, "clockpri2", -1));
        bmcData.setClockoffset(TEPTPClockUtil.getIntPartValue(oper, "clockoffset", -1));
        TEE2EClockSource clockSource = outerClockSourceMap.get(new TESlotPortKey(slotID, portID));
        if (null != clockSource) {
            clockSource.setClockAccuracy(bmcData.getTimeprecision());
            clockSource.setClockClass(bmcData.getTimelevel());
            clockSource.setClockPriority1(bmcData.getClockpri1());
            clockSource.setClockPriority2(bmcData.getClockpri2());
            clockSource.setClockTimeSource(bmcData.getClocktype());
        }
    }

    private static Map<TESlotPortKey, TEE2EClockSource> getClockSourceMap(TEE2EClockDevice clockDevice, int clockType) {
        TESlotPortKey key = null;
        HashMap<TESlotPortKey, TEE2EClockSource> clockSourceMap = new HashMap<TESlotPortKey, TEE2EClockSource>();
        List<TEE2EClockSource> clockSourceList = TEPTPBuildClock.getClockSource(clockDevice, clockType);
        for (TEE2EClockSource clockSource : clockSourceList) {
            long clockID = Long.parseLong(clockSource.getClockID());
            int slotID = TEPTPMOConverter.getSlotIDFromClockID(clockID);
            int portID = TEPTPMOConverter.getPortIDFromClockID(clockID);
            key = new TESlotPortKey();
            key.setSlotID(slotID);
            key.setPortID(portID);
            clockSourceMap.put(key, clockSource);
        }
        return clockSourceMap;
    }

    private static Map<TESlotPortKey, TEE2EClockPort> getClockPortListMap(TEE2EClockDevice clockDevice) {
        TESlotPortKey key = null;
        HashMap<TESlotPortKey, TEE2EClockPort> clockPortMap = new HashMap<TESlotPortKey, TEE2EClockPort>();
        List clockPortList = clockDevice.getClockPortList();
        for (TEE2EClockPort clockPort : clockPortList) {
            TEE2EUniResID portIndex = clockPort.getPortIndex();
            String fdn = portIndex.getStrFDN();
            int slotID = TEBoardUtil.neToSlotIDNM((int)FDNUtil.getFrameID((String)fdn), (int)FDNUtil.getSlotID((String)fdn));
            int portID = TEConfigurationDataMgr.getPortRelativeID((int)FDNUtil.getPortID((String)fdn));
            key = new TESlotPortKey();
            key.setSlotID(slotID);
            key.setPortID(portID);
            clockPortMap.put(key, clockPort);
        }
        return clockPortMap;
    }

    private static Param createFuncParam(String paramName) {
        Param param = new Param();
        param.setName(paramName);
        return param;
    }

    private static void addQxMapping(List<QxMapping> newQxList, String qxCmdNameStr, int serialNo) {
        QxMapping qxMapping = new QxMapping();
        qxMapping.setContent(qxCmdNameStr);
        qxMapping.setParent(0);
        qxMapping.setSerialno(serialNo);
        qxMapping.deleteParent();
        newQxList.add(qxMapping);
    }
}

