/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.e2e.bean;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockPort;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockSource;
import com.huawei.nglct.nemgr.e2e.task.clock.util.TEE2EClockLog;
import com.huawei.nglct.nemgr.ngwdm.clockptp.TEQueryPortStatusBean;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPAppendBeanProcessor;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPBuildClock;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPClockUtil;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import org.slf4j.Logger;

public final class TEE2EQueryClockPortList {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEE2EQueryClockPortList() {
    }

    public static TEErrInfoReturn queryClockPortList(int neID, TEE2EClockDevice device) {
        String FUNC_NAME = "TEE2EQueryClockPortList.queryClockPortList";
        TEE2EClockLog.logFuncBegin((String)"TEE2EQueryClockPortList.queryClockPortList");
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TENEMgrInterface bean = TEE2EQueryClockPortList.getQueryBean(neID);
        int sfid = TEE2EQueryClockPortList.getSfid();
        SubFunc subFunc = TEPTPClockUtil.createSubFunc(neID, sfid);
        Datainterface inputData = TEE2EQueryClockPortList.constructQueryInput(neID, device);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            String neName = ne.getNEName();
            TEE2EClockLog.logFuncEnd((String)"TEE2EQueryClockPortList.queryClockPortList");
            return TEPTPClockUtil.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, 1090646019);
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEE2EQueryClockPortList.logBeanOperError(neID, retCode);
            TEPTPClockUtil.printRowError(outputData);
            errRet = TEPTPClockUtil.constructErrInfoReturn(neID, outputData);
        }
        if (null == outputData.getBussinessParams()) {
            TEE2EQueryClockPortList.logNullBussinessParamsError();
            TEE2EClockLog.logFuncEnd((String)"TEE2EQueryClockPortList.queryClockPortList");
            return errRet;
        }
        RowParams[] rowParamsArr = outputData.getBussinessParams().getRowParams();
        if (null == rowParamsArr) {
            TEE2EQueryClockPortList.logNullRowParamsError();
            TEE2EClockLog.logFuncEnd((String)"TEE2EQueryClockPortList.queryClockPortList");
            return errRet;
        }
        TEPTPAppendBeanProcessor.appendProcessor(neID, subFunc, inputData, outputData);
        TEE2EClockLog.logFuncEnd((String)"TEE2EQueryClockPortList.queryClockPortList");
        return errRet;
    }

    private static int getSfid() {
        return 2106669;
    }

    private static Datainterface constructQueryInput(int neID, TEE2EClockDevice device) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("isFromNE", "0");
        rowparams.addParam(param);
        param = new Param("workmode", String.valueOf(device.getPtpClockType()));
        rowparams.addParam(param);
        return inputData;
    }

    private static TENEMgrInterface getQueryBean(int neID) {
        int TIMEOUT = 20;
        return new TEQueryPortStatusBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            public int getTimeOut() {
                return 20;
            }
        };
    }

    public static void parseAttributeFromRowParams(int neID, TEE2EClockDevice device, RowParams[] rowParamsArr) {
        RowParams rowParams2 = null;
        device.getClockPortList().clear();
        for (RowParams rowParams2 : rowParamsArr) {
            if (0 != rowParams2.getRowErrorsCount()) continue;
            int slotID = TEPTPClockUtil.getIntParam(rowParams2, "slotid", -1);
            int portID = TEPTPClockUtil.getIntParam(rowParams2, "port", -1);
            portID = TEConfigurationDataMgr.getPortRelativeID((int)portID);
            int portstatus = TEPTPClockUtil.getIntParam(rowParams2, "portrealstatus", -1);
            int portworkmode = TEPTPClockUtil.getIntParam(rowParams2, "portworkmode", -1);
            TEE2EClockPort clockPort = TEPTPBuildClock.buildClockPortList(neID, slotID, portID, portworkmode, portstatus);
            device.getClockPortList().add(clockPort);
            TEE2EClockSource clock = TEPTPBuildClock.buildClockSource(neID, slotID, portID, 2);
            device.getClockSourceList().add(clock);
        }
    }

    private static void logBeanOperError(int neID, int retCode) {
        String tipStr = "query clock subnet fail! ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logNullRowParamsError() {
        e2eLogger.error("no rowparams in outputData.");
    }

    private static void logNullBussinessParamsError() {
        e2eLogger.error("no bussinessparams in outputData.");
    }
}

