/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.dlag.mooperation;

import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgNEInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginUtil;
import com.huawei.nglct.explorer.beanplugin.TEMODBMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEWebLCTDlagMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.errinfo.TECommonResult;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.wnemgrprocess.TEWNEMgrBussinessProcess;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEDLAGMoUtil {
    private static final int DEFAULT_PRI = 32768;
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();
    private static final TEMODBMgr<TEWebLCTDlagMOPO> dlagMOMgr = new TEMODBMgr();

    private TEDLAGMoUtil() {
    }

    public static boolean checkOutputSuccess(int neID, Datainterface inputData, Datainterface outputData, String errorMsg) {
        if (outputData.getErrorMessage() == null) {
            return false;
        }
        String errorCode = outputData.getErrorMessage().getErrorcode();
        int dlagID = 0;
        if (inputData.getBussinessParams().getRowParams(0).getParam("dlagID") != null) {
            dlagID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("dlagID").getValue());
        }
        if (!errorCode.equals(String.valueOf(0)) && !errorCode.equals(String.valueOf(1))) {
            String tipStr = "perform " + errorMsg + " is fail and not save data to DB! ";
            tipStr = tipStr + String.format("[neID:%d, dlagID:%d]", neID, dlagID);
            E2ELOGGER.info(tipStr);
            return false;
        }
        return true;
    }

    public static TEWebLCTDlagMOPO parseDLAGMOPOFromInputRow(RowParams rowparam) {
        TEWebLCTDlagMOPO mopo = null;
        if (rowparam.getRowErrorsCount() == 0) {
            mopo = new TEWebLCTDlagMOPO();
            int dlagID = Integer.parseInt(rowparam.getParam("dlagID").getValue());
            String dlagName = rowparam.getParam("aggregationName").getValue();
            int rvtMode = Integer.parseInt(rowparam.getParam("revertiveMode").getValue());
            int mainSlot = Integer.parseInt(rowparam.getParam("mainBoard").getValue());
            int mainPort = Integer.parseInt(rowparam.getParam("mainPort").getValue());
            int slaveSlot = Integer.parseInt(rowparam.getParam("slaveBoard").getValue());
            int slavePort = Integer.parseInt(rowparam.getParam("slavePort").getValue());
            mopo.setDlagid(dlagID);
            mopo.setDlagname(dlagName);
            mopo.setMastboard(mainSlot);
            mopo.setMastport(mainPort);
            mopo.setSlvboard(slaveSlot);
            mopo.setSlvport(slavePort);
            mopo.setRvtmode(rvtMode);
            mopo.setMastportpri(32768);
            mopo.setSlaveportpri(32768);
            mopo.setSyspri(32768);
        }
        return mopo;
    }

    public static TEWebLCTDlagMOPO parseDLAGMOPOFromOutputRow(RowParams rowparam) {
        TEWebLCTDlagMOPO mopo = null;
        if (rowparam.getRowErrorsCount() == 0) {
            mopo = new TEWebLCTDlagMOPO();
            int dlagID = Integer.parseInt(rowparam.getParam("dlagID").getValue());
            String dlagName = rowparam.getParam("aggregationName").getValue();
            int rvtMode = Integer.parseInt(rowparam.getParam("revertiveMode").getValue());
            int mainSlot = Integer.parseInt(rowparam.getParam("mainBoardSlot").getValue());
            int mainPort = Integer.parseInt(rowparam.getParam("mainPortID").getValue());
            int slaveSlot = Integer.parseInt(rowparam.getParam("slaveBoardSlot").getValue());
            int slavePort = Integer.parseInt(rowparam.getParam("slavePortID").getValue());
            int mainPortPriority = Integer.parseInt(rowparam.getParam("mainPortPriority").getValue());
            int slavePortPriority = Integer.parseInt(rowparam.getParam("slavePortPriority").getValue());
            int sysPriority = Integer.parseInt(rowparam.getParam("sysPriority").getValue());
            mopo.setDlagid(dlagID);
            mopo.setDlagname(dlagName);
            mopo.setSlvboard(slaveSlot);
            mopo.setSlvport(slavePort);
            mopo.setMastboard(mainSlot);
            mopo.setMastport(mainPort);
            mopo.setRvtmode(rvtMode);
            mopo.setMastportpri(mainPortPriority);
            mopo.setSlaveportpri(slavePortPriority);
            mopo.setSyspri(sysPriority);
        }
        return mopo;
    }

    public static TECommonResult<List<TEWebLCTDlagMOPO>> queryDLAGMOPOFromDB(int neID, int dlagID) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        criteria.add(new TEDaoNameValuePair("Dlagid", String.valueOf(dlagID)));
        TECommonResult result = dlagMOMgr.getMOFromDB(neID, TEWebLCTDlagMOPO.class, criteria);
        return result;
    }

    public static TECommonResult<List<TEWebLCTDlagMOPO>> queryDLAGMOPOFromDB(int neID) {
        return dlagMOMgr.getMOFromDB(neID, TEWebLCTDlagMOPO.class);
    }

    public static TEErrInfoReturn clearDLAGMOPOTODB(int neID) {
        TECommonResult resultList = dlagMOMgr.getMOFromDB(neID, TEWebLCTDlagMOPO.class);
        TEErrInfoReturn errResult = null;
        if (resultList.getErrInfoRet().getResult() != 0) {
            errResult = resultList.getErrInfoRet();
        } else if (resultList.getReturnObject() != null && !((List)resultList.getReturnObject()).isEmpty()) {
            int len = ((List)resultList.getReturnObject()).size();
            for (int i = 0; i < len; ++i) {
                TEErrInfoReturn errTmp = dlagMOMgr.delMOFromDB(neID, ((List)resultList.getReturnObject()).get(i));
                if (errTmp.getResult() == 0) continue;
                errResult = errTmp;
                break;
            }
        }
        if (errResult == null) {
            errResult = new TEErrInfoReturn();
            errResult.setResult(0);
        }
        return errResult;
    }

    public static TEErrInfoReturn createDLAGMOPOTODB(int neID, TEWebLCTDlagMOPO mopo) {
        return dlagMOMgr.createMOToDB(neID, (Object)mopo);
    }

    public static TEErrInfoReturn updateDLAGMOPOTODB(int neID, TEWebLCTDlagMOPO mopo) {
        return dlagMOMgr.updateMOToDB(neID, (Object)mopo);
    }

    public static TEErrInfoReturn deleteDLAGMOPO(int neID, TEWebLCTDlagMOPO mopo) {
        return dlagMOMgr.delMOFromDB(neID, (Object)mopo);
    }

    public static int getNEDLAGToDB(TEDataCfgNEInfo pPara, boolean uploadFlag) {
        String firstFlag = uploadFlag ? "Upload" : "Sync";
        int neID = pPara.getNeID();
        int retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
        if (0 != retCode) {
            TEDLAGMoUtil.logError(neID, retCode, firstFlag + " DLAG fail!");
            return retCode;
        }
        SubFunc subFunc = TEBeanPluginUtil.createSubFunc((int)neID, (int)2143025);
        if (null == subFunc) {
            TEDLAGMoUtil.logError(neID, retCode, "subfunc is null");
            return 0;
        }
        Datainterface inputData = TEDLAGMoUtil.createQueryDLAGInputData(neID);
        Datainterface memeryData = new Datainterface();
        Datainterface allData = null;
        int errorCode = 0;
        try {
            allData = TEWNEMgrBussinessProcess.performWNEMgrBussinessProcess((int)neID, (SubFunc)subFunc, (Datainterface)inputData, (Datainterface)memeryData, null, null, (int)1);
        }
        catch (Exception e) {
            TEDLAGMoUtil.logError(neID, retCode, "performWNEMgrBussinessProcess fail!");
        }
        if (allData != null) {
            errorCode = Integer.parseInt(allData.getErrorMessage().getErrorcode());
        }
        return errorCode;
    }

    private static void logError(int neID, int retCode, String errorInfo) {
        String tipStr = errorInfo;
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        E2ELOGGER.error(tipStr);
    }

    protected static Datainterface createQueryDLAGInputData(int neID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("report", "notReport");
        rowparams.addParam(param);
        param = new Param("dlagID", "0");
        rowparams.addParam(param);
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return inputData;
    }
}

