/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.dlag;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ngwdm.dlag.TEDLAGUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryDLAGInfo
extends TECommonWriteLogBean {
    private TEConfigurationDataMgr configMgr = TEConfigurationDataMgr.getInstance();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        Operation operation = null;
        String subrack = "";
        int slotid = 0;
        int m = operationList.size();
        for (int i = 0; i < m; ++i) {
            operation = (Operation)operationList.get(i);
            if (null == operation) continue;
            for (Output output : operation.getOutput()) {
                Part slotHerePart;
                Part slaveboardPart;
                Part mainboardPart;
                if (!output.getFault(0).getCode().equals("0")) continue;
                if (output.getPart("deviceidHere") != null) {
                    output.setPartValue("deviceidHere", TEDLAGUtil.getMACforFormat(output.getPartValue("deviceidHere")));
                }
                if (output.getPart("deviceidThere") != null) {
                    output.setPartValue("deviceidThere", TEDLAGUtil.getMACforFormat(output.getPartValue("deviceidThere")));
                }
                if ((mainboardPart = output.getPart("mainBoard")) != null) {
                    Part mainboardNamePart = new Part();
                    mainboardNamePart.setName("mainBoardName");
                    mainboardNamePart.setValue(TEConfigurationDataMgr.getInstance().getBoard(neid, Integer.valueOf(mainboardPart.getValue()).intValue()).getBoardName());
                    output.addPart(mainboardNamePart);
                }
                if ((slaveboardPart = output.getPart("slaveBoard")) != null) {
                    Part slaveboardNamePart = new Part();
                    slaveboardNamePart.setName("slaveBoardName");
                    slaveboardNamePart.setValue(TEConfigurationDataMgr.getInstance().getBoard(neid, Integer.valueOf(slaveboardPart.getValue()).intValue()).getBoardName());
                    output.addPart(slaveboardNamePart);
                }
                if ((slotHerePart = output.getPart("slotHere")) == null) continue;
                slotid = Integer.parseInt(slotHerePart.getValue());
                subrack = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid);
                String boardName = TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotid) + "-" + this.configMgr.getBoard(neid, slotid).getBoardName();
                if (!subrack.equals("")) {
                    boardName = subrack + "-" + boardName;
                }
                Part slotHereNamePart = new Part();
                slotHereNamePart.setName("slotHereName");
                slotHereNamePart.setValue(boardName);
                output.addPart(slotHereNamePart);
            }
        }
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
    }
}

