/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.dlag;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ngwdm.dlag.TEDLAGUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEQueryDLAG
extends TENEExplorerBean {
    private static final String NSCMD_ETHN_GET_DLAGWORKPORT = "NSCMD_ETHN_GET_DLAGWORKPORT";
    private static final String NSCMD_ETHN_GET_DLAGSYSPRI = "NSCMD_ETHN_GET_DLAGSYSPRI";
    private static final String NSCMD_ETHN_GET_DLAGPORTPRI = "NSCMD_ETHN_GET_DLAGPORTPRI";
    private static final String NSCMD_ETHN_GET_DLAGNAME = "NSCMD_ETHN_GET_DLAGNAME";
    private static final String NSCMD_ETHN_GET_DLAGRVTMODE = "NSCMD_ETHN_GET_DLAGRVTMODE";
    private static final String OPERATION_SUCCESS = "0";
    private static final int QUERY_RESULT_IS_NULL = 38662;
    private ArrayList operList = new ArrayList();
    private ArrayList errorList = new ArrayList();
    private Map dlagAttriMap = new HashMap();
    private Map reportDataMap = new HashMap();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        if (inputData.getBussinessParams().getRowParams(0).getParam("report").getValue().equals("report")) {
            return this.getReportData();
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        Operation operation = null;
        Output output = null;
        Operation oper = (Operation)operationList.get(0);
        int len = oper.getOutputCount();
        for (int i = 0; i < len; ++i) {
            output = oper.getOutput(i);
            if (!OPERATION_SUCCESS.equals(output.getFault(0).getCode())) continue;
            String aggNo = output.getPartValue("dlagID");
            operation = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_ETHN_GET_DLAGWORKPORT);
            operation.getInput().setPartValue("dlagID", aggNo);
            this.operList.add(operation);
            operation = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_ETHN_GET_DLAGPORTPRI);
            operation.getInput().setPartValue("dlagID", aggNo);
            this.operList.add(operation);
            operation = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_ETHN_GET_DLAGSYSPRI);
            operation.getInput().setPartValue("dlagID", aggNo);
            this.operList.add(operation);
            operation = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_ETHN_GET_DLAGNAME);
            operation.getInput().setPartValue("dlagID", aggNo);
            this.operList.add(operation);
            operation = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_ETHN_GET_DLAGRVTMODE);
            operation.getInput().setPartValue("dlagID", aggNo);
            this.operList.add(operation);
        }
        if (this.operList.size() > 0) {
            this.queryDLAGAttri();
        }
        this.handleOutputData(filterErrorCodeList);
    }

    private void handleOutputData(ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)this.neid, (SubFunc)this.subfunc, (ArrayList)this.operationList, (ArrayList)filterErrorCodeList);
        int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        if (0 == errorCode || 1 == errorCode) {
            RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
            String mainBoard = "";
            String mainPort = "";
            String slaveBoard = "";
            String slavePort = "";
            String subrack = "";
            for (RowParams rowParams : rowParamses) {
                Integer aggNo = Integer.valueOf(rowParams.getParam("dlagID").getValue());
                mainBoard = rowParams.getParam("mainBoard").getValue();
                int mainslot = TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)Integer.parseInt(mainBoard));
                rowParams.addParam(new Param("mainBoardSlot", mainBoard));
                slaveBoard = rowParams.getParam("slaveBoard").getValue();
                int slaveslot = TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)Integer.parseInt(slaveBoard));
                rowParams.addParam(new Param("slaveBoardSlot", slaveBoard));
                subrack = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)Integer.parseInt(mainBoard));
                if (!subrack.equals("")) {
                    rowParams.getParam("mainBoard").setValue(subrack + "-" + mainslot + "-" + TEDLAGUtil.getBoardName(this.neid, mainBoard));
                    rowParams.getParam("slaveBoard").setValue(subrack + "-" + slaveslot + "-" + TEDLAGUtil.getBoardName(this.neid, slaveBoard));
                } else {
                    rowParams.getParam("mainBoard").setValue(mainslot + "-" + TEDLAGUtil.getBoardName(this.neid, mainBoard));
                    rowParams.getParam("slaveBoard").setValue(slaveslot + "-" + TEDLAGUtil.getBoardName(this.neid, slaveBoard));
                }
                mainPort = rowParams.getParam("mainPort").getValue();
                rowParams.addParam(new Param("mainPortID", mainPort));
                rowParams.getParam("mainPort").setValue(TEDLAGUtil.getPortName(mainPort));
                slavePort = rowParams.getParam("slavePort").getValue();
                rowParams.addParam(new Param("slavePortID", slavePort));
                rowParams.getParam("slavePort").setValue(TEDLAGUtil.getPortName(slavePort));
                if (!this.dlagAttriMap.containsKey(aggNo)) continue;
                DlagAttri temp = (DlagAttri)this.dlagAttriMap.get(aggNo);
                String workingBoard = temp.workingBoard;
                if (!("".equals(workingBoard) || "-".equals(workingBoard) || OPERATION_SUCCESS.equals(workingBoard))) {
                    if (TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)Integer.parseInt(workingBoard)) == 0) {
                        rowParams.getParam("workingBoard").setValue("/");
                    } else {
                        rowParams.getParam("workingBoard").setValue(workingBoard + "-" + TEDLAGUtil.getBoardName(this.neid, workingBoard));
                    }
                } else {
                    rowParams.getParam("workingBoard").setValue("/");
                }
                String workingPort = temp.workingPort;
                if (!("".equals(workingPort) || "-".equals(workingPort) || OPERATION_SUCCESS.equals(workingPort))) {
                    rowParams.getParam("workingPort").setValue(TEDLAGUtil.getPortName(workingPort));
                } else {
                    rowParams.getParam("workingPort").setValue("/");
                }
                rowParams.getParam("mainPortPriority").setValue(temp.mainPortPriority);
                rowParams.getParam("slavePortPriority").setValue(temp.slavePortPriority);
                rowParams.getParam("aggregationName").setValue(temp.aggregationName);
                rowParams.getParam("sysPriority").setValue(temp.sysPriority);
                rowParams.getParam("revertiveMode").setValue(temp.revertiveMode);
                rowParams.getParam("partakeType").setValue(temp.partakeType);
            }
        }
        if (this.errorList.size() > 0) {
            RowParams rowparams = null;
            if (this.outputData.getErrorMessage().getErrorcode().equals(OPERATION_SUCCESS)) {
                rowparams = new RowParams();
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)1));
            } else {
                BussinessParams bussinessParams = this.outputData.getBussinessParams();
                rowparams = bussinessParams.getRowParams(bussinessParams.getRowParamsCount() - 1);
            }
            int size = this.errorList.size();
            for (int i = 0; i < size; ++i) {
                rowparams.addRowErrors((RowErrors)this.errorList.get(i));
            }
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
    }

    private void queryDLAGAttri() {
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, (List)this.operList, this.getTimeOut());
        if (null != result && 0 == result.retCode) {
            Operation operation = null;
            Output output = null;
            int size = this.operList.size();
            for (int i = 0; i < size; ++i) {
                operation = (Operation)this.operList.get(i);
                output = operation.getOutput(0);
                if (!output.getFault(0).getCode().equals(String.valueOf(0))) continue;
                Integer aggNo = Integer.valueOf(output.getPartValue("dlagID"));
                DlagAttri temp = null;
                if (this.dlagAttriMap.containsKey(aggNo)) {
                    temp = (DlagAttri)this.dlagAttriMap.get(aggNo);
                } else {
                    temp = new DlagAttri(aggNo);
                    this.dlagAttriMap.put(aggNo, temp);
                }
                if (operation.getName().equalsIgnoreCase(NSCMD_ETHN_GET_DLAGWORKPORT)) {
                    temp.workingBoard = output.getPartValue("workingBoard");
                    temp.workingPort = output.getPartValue("workingPort");
                    continue;
                }
                if (operation.getName().equalsIgnoreCase(NSCMD_ETHN_GET_DLAGPORTPRI)) {
                    temp.mainPortPriority = output.getPartValue("mainPortPriority");
                    temp.slavePortPriority = output.getPartValue("slavePortPriority");
                    continue;
                }
                if (operation.getName().equalsIgnoreCase(NSCMD_ETHN_GET_DLAGSYSPRI)) {
                    temp.sysPriority = output.getPartValue("sysPriority");
                    continue;
                }
                if (operation.getName().equalsIgnoreCase(NSCMD_ETHN_GET_DLAGNAME)) {
                    temp.aggregationName = output.getPartValue("aggregationName").trim();
                    continue;
                }
                if (!operation.getName().equalsIgnoreCase(NSCMD_ETHN_GET_DLAGRVTMODE)) continue;
                temp.revertiveMode = output.getPartValue("revertiveMode");
            }
            this.errorList = TEDataConverter.joinOperation((int)this.neid, (SubFunc)this.subfunc, (ArrayList)this.operList, null);
        }
    }

    private Datainterface getReportData() {
        TEConfigurationDataMgr instance = TEConfigurationDataMgr.getInstance();
        String neName = instance.getNE(this.neid).getNEName();
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        Collection values = this.reportDataMap.values();
        Iterator it = values.iterator();
        RowParams rowparams = null;
        Param param = null;
        if (it.hasNext()) {
            Operation oper = (Operation)it.next();
            Output output = oper.getOutput(0);
            rowparams = new RowParams();
            param = new Param("neName", "");
            param.setValue(neName);
            rowparams.addParam(param);
            param = new Param("dlagID", "");
            param.setValue(output.getPart("dlagID").getValue());
            rowparams.addParam(param);
            String mainBoard = output.getPart("mainBoard").getValue();
            param = new Param("mainBoard", "");
            param.setValue(mainBoard);
            rowparams.addParam(param);
            param = new Param("mainBoardName", "");
            param.setValue(instance.getBoard(this.neid, Integer.parseInt(mainBoard)).getBoardName());
            rowparams.addParam(param);
            param = new Param("mainPort", "");
            param.setValue(output.getPart("mainPort").getValue());
            rowparams.addParam(param);
            String slaveBoard = output.getPart("slaveBoard").getValue();
            param = new Param("slaveBoard", "");
            param.setValue(slaveBoard);
            rowparams.addParam(param);
            param = new Param("mainBoardName", "");
            param.setValue(instance.getBoard(this.neid, Integer.parseInt(slaveBoard)).getBoardName());
            rowparams.addParam(param);
            param = new Param("slavePort", "");
            param.setValue(output.getPart("slavePort").getValue());
            rowparams.addParam(param);
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        return outputData;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(new Integer(38662));
        return errorList;
    }

    class ReportHandler
    implements NoticeHandler {
        ReportHandler() {
        }

        public void handleNotice(int cmdKey, int neID, Operation oper) {
            Output outPut = oper.getOutput(0);
            Integer aggNO = Integer.valueOf(outPut.getPart("dlagID").getValue());
            TEQueryDLAG.this.reportDataMap.put(aggNO, oper);
        }
    }

    private class DlagAttri {
        String workingBoard = "-";
        String workingPort = "-";
        String sysPriority = "-";
        String mainPortPriority = "-";
        String slavePortPriority = "-";
        String aggregationName = "";
        String revertiveMode = "-";
        String partakeType = "1";

        public DlagAttri(Integer aggNO) {
        }
    }
}

