/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.dlag;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEDLAGBoardMgr
extends TENEExplorerBean {
    private static final String NSCMD_ETHN_GET_VLANSWITCHLINK = "NSCMD_ETHN_GET_VLANSWITCHLINK";
    private static final String NSCMD_ETHN_GET_QINQLINK = "NSCMD_ETHN_GET_QINQLINK";
    private static final String NSCMD_ETHN_GET_LINKAGG = "NSCMD_ETHN_GET_LINKAGG";
    private static final String NSCMD_ETHN_GET_DLAG = "NSCMD_ETHN_GET_DLAG";
    private static final String NSCMD_ETHN_GET_LINK = "NSCMD_ETHN_GET_LINK";
    private static final String NSCMD_ETHN_GET_PORTCVLANSVLANVBLINK = "NSCMD_ETHN_GET_PORTCVLANSVLANVBLINK";
    private static final String NSCMD_ETHN_GET_PORTSVLANVBLINK = "NSCMD_ETHN_GET_PORTSVLANVBLINK";
    private static final String FILEPATH = "nemgr" + File.separator + "ngwdm" + File.separator + "conf" + File.separator + "dlinkaggregation" + File.separator + "boardsupportdlag.xml";
    private static List boardTypeSupportDlagList;
    private List boardSupportDalgList = new ArrayList();
    private HashMap slotPortsMap = new HashMap();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.outputData = new Datainterface();
        this.boardSupportDalgList = this.getBoardList();
        if (this.boardSupportDalgList.size() == 0) {
            TELogFactory.getNormalLogger().error("There is no board support dlag!");
            return this.outputData;
        }
        this.filterUsedPorts();
        this.handleOutputData();
        return this.outputData;
    }

    private void handleOutputData() {
        this.outputData.setBussinessParams(new BussinessParams());
        String neName = TEConfigurationDataMgr.getInstance().getNE(this.neid).getNEName();
        ArrayList slotIDList = new ArrayList(this.slotPortsMap.size());
        Set slotIDSet = this.slotPortsMap.keySet();
        Iterator iter = slotIDSet.iterator();
        while (iter.hasNext()) {
            slotIDList.add(iter.next());
        }
        Collections.sort(slotIDList);
        RowParams rowParams = null;
        Param param = null;
        int size = slotIDList.size();
        for (int i = 0; i < size; ++i) {
            Resource temp = (Resource)this.slotPortsMap.get(slotIDList.get(i));
            rowParams = new RowParams();
            rowParams.addParam(new Param("neName", neName));
            rowParams.addParam(new Param("slotid", String.valueOf(temp.slotid)));
            rowParams.addParam(new Param("boardType", temp.boardType));
            rowParams.addParam(new Param("boardName", temp.boardName));
            String subrack = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)temp.slotid);
            if (subrack != null && !subrack.equals("")) {
                rowParams.addParam(new Param("subrack", subrack));
            }
            param = new Param("macPort", "");
            int len = temp.macPortList.size();
            for (int j = 0; j < len; ++j) {
                if (32768 <= Integer.valueOf(String.valueOf(temp.macPortList.get(j)))) continue;
                Option option = new Option(String.valueOf(temp.macPortList.get(j)));
                param.addOption(option);
            }
            rowParams.addParam(param);
            rowParams.addParam(new Param("hasService", String.valueOf(temp.hasService)));
            rowParams.addParam(new Param("isFromboard", String.valueOf(temp.isFromboard)));
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
    }

    private void filterUsedPorts() {
        this.operationList = this.getOperationList();
        int result = this.sendMessage(this.neid);
        if (result == 0) {
            this.handleOperations();
        } else {
            TELogFactory.getNormalLogger().error("Send operation list failed! --Dlag");
        }
    }

    private void handleOperations() {
        Operation operation = null;
        Output output = null;
        Resource temp = null;
        int size = this.operationList.size();
        for (int i = 0; i < size; ++i) {
            int k;
            int t;
            Integer mainPort;
            Integer slotid;
            int j;
            int n;
            operation = (Operation)this.operationList.get(i);
            if (operation.getName().equalsIgnoreCase(NSCMD_ETHN_GET_LINKAGG)) {
                n = operation.getOutputCount();
                for (j = 0; j < n; ++j) {
                    output = operation.getOutput(j);
                    if (!output.getFault(0).getCode().equals("0")) continue;
                    slotid = Integer.valueOf(output.getPart("slotid").getValue());
                    temp = (Resource)this.slotPortsMap.get(slotid);
                    mainPort = Integer.valueOf(output.getPartValue("mainPort"));
                    if (mainPort >= 32768) continue;
                    temp.macPortList.remove(mainPort);
                    int branchPortNum = Integer.parseInt(output.getPartValue("branchPortNum"));
                    if (branchPortNum > 0) {
                        byte[] bValue = output.getPartValue("branchPort").getBytes();
                        int nCount = 4;
                        int nIndex = 0;
                        if (bValue.length / branchPortNum == 6) {
                            nIndex = 2;
                            nCount = 6;
                        }
                        int nPos = 0;
                        int nParaSize = bValue.length;
                        while (nPos + nCount <= nParaSize) {
                            byte[] bTmp = new byte[4];
                            System.arraycopy(bValue, nPos + nIndex, bTmp, 0, 4);
                            temp.macPortList.remove(new Integer(IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0)));
                            nPos += nCount;
                        }
                    }
                    temp.hasService = true;
                }
                continue;
            }
            if (operation.getName().equalsIgnoreCase(NSCMD_ETHN_GET_VLANSWITCHLINK) || operation.getName().equals(NSCMD_ETHN_GET_QINQLINK)) {
                t = operation.getOutputCount();
                for (k = 0; k < t; ++k) {
                    output = operation.getOutput(k);
                    if (!output.getFault(0).getCode().equals("0")) continue;
                    slotid = Integer.valueOf(output.getPart("slotID").getValue());
                    temp = (Resource)this.slotPortsMap.get(slotid);
                    temp.hasService = true;
                }
                continue;
            }
            if (operation.getName().equalsIgnoreCase(NSCMD_ETHN_GET_LINK) || operation.getName().equalsIgnoreCase(NSCMD_ETHN_GET_PORTCVLANSVLANVBLINK) || operation.getName().equalsIgnoreCase(NSCMD_ETHN_GET_PORTSVLANVBLINK)) {
                t = operation.getOutputCount();
                for (k = 0; k < t; ++k) {
                    output = operation.getOutput(k);
                    if (!output.getFault(0).getCode().equals("0")) continue;
                    slotid = Integer.valueOf(output.getPart("slotid").getValue());
                    temp = (Resource)this.slotPortsMap.get(slotid);
                    temp.hasService = true;
                }
                continue;
            }
            if (!operation.getName().equalsIgnoreCase(NSCMD_ETHN_GET_DLAG)) continue;
            n = operation.getOutputCount();
            for (j = 0; j < n; ++j) {
                output = operation.getOutput(j);
                if (!output.getFault(0).getCode().equals("0")) continue;
                Integer mainSlotid = Integer.valueOf(output.getPart("mainBoard").getValue());
                mainPort = Integer.valueOf(output.getPart("mainPort").getValue());
                temp = (Resource)this.slotPortsMap.get(mainSlotid);
                temp.macPortList.remove(mainPort);
                Integer branchSlotid = Integer.valueOf(output.getPart("slaveBoard").getValue());
                Integer branchPort = Integer.valueOf(output.getPart("slavePort").getValue());
                temp = (Resource)this.slotPortsMap.get(branchSlotid);
                temp.macPortList.remove(branchPort);
                temp.isFromboard = true;
                temp.hasService = false;
            }
        }
    }

    private ArrayList getOperationList() {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        try {
            Operation operation = null;
            TEBoard board = null;
            Input input = null;
            int size = this.boardSupportDalgList.size();
            for (int i = 0; i < size; ++i) {
                board = (TEBoard)this.boardSupportDalgList.get(i);
                String slotID = String.valueOf(board.getSlotID());
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_GET_VLANSWITCHLINK);
                input = operation.getInput();
                input.getPart("slotID").setValue(slotID);
                input.getPart("linkID").setValue(String.valueOf(0));
                operationList.add(operation);
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_GET_QINQLINK);
                input = operation.getInput();
                input.getPart("slotID").setValue(slotID);
                input.getPart("linkID").setValue(String.valueOf(0));
                operationList.add(operation);
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_GET_LINKAGG);
                input = operation.getInput();
                input.getPart("slotid").setValue(slotID);
                input.getPart("aggregationNO").setValue(String.valueOf(0));
                operationList.add(operation);
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_GET_LINK);
                input = operation.getInput();
                input.getPart("slotid").setValue(slotID);
                input.getPart("linkid").setValue(String.valueOf(0));
                operationList.add(operation);
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_GET_PORTCVLANSVLANVBLINK);
                input = operation.getInput();
                input.getPart("slotid").setValue(slotID);
                input.getPart("linkid").setValue(String.valueOf(0));
                operationList.add(operation);
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_GET_PORTSVLANVBLINK);
                input = operation.getInput();
                input.getPart("slotid").setValue(slotID);
                input.getPart("linkid").setValue(String.valueOf(0));
                operationList.add(operation);
            }
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_GET_DLAG);
            input = operation.getInput();
            input.getPart("dlagID").setValue(String.valueOf(0));
            operationList.add(operation);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEDLAGBoardMgr.getOperationList() fail!", (Throwable)e);
        }
        return operationList;
    }

    private List getBoardList() {
        if (null == boardTypeSupportDlagList) {
            this.initBoardTypeSupportDlagList();
        }
        ArrayList ethBoardList = new ArrayList();
        int jSize = boardTypeSupportDlagList.size();
        for (int j = 0; j < jSize; ++j) {
            ethBoardList.addAll(TEConfigurationDataMgr.getInstance().getBoardList(this.neid, ((Integer)boardTypeSupportDlagList.get(j)).intValue()));
        }
        for (int i = ethBoardList.size() - 1; i >= 0; --i) {
            TEBoard board = (TEBoard)ethBoardList.get(i);
            Integer slotid = new Integer(board.getSlotID());
            Resource temp = new Resource(board);
            this.slotPortsMap.put(slotid, temp);
        }
        return ethBoardList;
    }

    private void initBoardTypeSupportDlagList() {
        boardTypeSupportDlagList = new ArrayList();
        Document doc = TEParseXMLFile.parseFile((String)(TEResourceManager.getPath() + FILEPATH));
        NodeList options = doc.getElementsByTagName("option");
        int size = options.getLength();
        for (int i = 0; i < size; ++i) {
            Element element = (Element)options.item(i);
            Integer boardTypeSupportDlag = Integer.valueOf(element.getAttribute("value"));
            boardTypeSupportDlagList.add(boardTypeSupportDlag);
        }
        boardTypeSupportDlagList.addAll(TESpecialAttrMgr.getInstance().getSupportCPList(this.neid, "TE_FUNC_CFG_ETH_DLAG", "OTN_ATTR_SUPPORT_LAG"));
    }

    private class Resource {
        int slotid;
        String boardName;
        String boardType;
        List macPortList = new ArrayList();
        boolean hasService = false;
        boolean isFromboard = false;

        public Resource(TEBoard board) {
            this.slotid = board.getSlotID();
            this.boardName = board.getBoardName();
            this.boardType = String.valueOf(board.getBoardType());
            TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
            ArrayList portList = mgr.getETHMACPort(this.slotid, board.getBoardType());
            HashSet set = new HashSet();
            set.addAll(portList);
            this.macPortList.addAll(set);
            Collections.sort(this.macPortList);
        }
    }
}

