/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.dbps.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ngwdm.dbps.db.TEDBPSDbMgr;
import com.huawei.nglct.nemgr.ngwdm.dbps.db.TEDBPSVlanDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherDBPSMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherDBPSVlanGrpMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public class TEDBPSScriptHandler
implements TEScriptHandler {
    private static final Logger logger = TELogFactory.getNormalLogger();
    private static final int INT_DEFAULT_VALUE = -1;
    private static final String STR_DEFAULT_VALUE = "";

    public int doExport(int neID, int item) {
        int result = 0;
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return result;
        }
        return this.writeExportDataToScript(neID, item);
    }

    private int writeExportDataToScript(int neID, int item) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        List<TEEtherDBPSMOPO> dbpsObjRes = TEDBPSDbMgr.getAllEtherDBPSMOFromDB(neID, errRet);
        if (0 != errRet.getResult()) {
            return 1092743443;
        }
        if (dbpsObjRes.isEmpty()) {
            logger.info("dbps MO is null! neID->" + neID);
            return 0;
        }
        List<TEEtherDBPSVlanGrpMOPO> dbpsVlanObjRes = TEDBPSVlanDbMgr.getAllEtherDBPSVlanMOFromDB(neID, errRet);
        HashMap vlanMap = new HashMap(dbpsVlanObjRes.size());
        for (TEEtherDBPSVlanGrpMOPO vlanMo : dbpsVlanObjRes) {
            List<Object> valueRes = vlanMap.containsKey(vlanMo.getDbpsID()) ? (List)vlanMap.get(vlanMo.getDbpsID()) : new ArrayList<TEEtherDBPSVlanGrpMOPO>();
            valueRes.add(vlanMo);
            vlanMap.put(vlanMo.getDbpsID(), valueRes);
        }
        for (TEEtherDBPSMOPO dbpsMo : dbpsObjRes) {
            int dbpsID = dbpsMo.getDbpsID();
            List vlanMoRes = (List)vlanMap.get(dbpsID);
            if (vlanMoRes == null) {
                TEScriptCmd cmd = this.constructScriptCmd(dbpsMo, null, item);
                if (null == cmd) {
                    return 0;
                }
                TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
                continue;
            }
            for (TEEtherDBPSVlanGrpMOPO vlanObj : vlanMoRes) {
                TEScriptCmd cmd = this.constructScriptCmd(dbpsMo, vlanObj, item);
                if (null == cmd) {
                    return 0;
                }
                TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
            }
        }
        return 0;
    }

    public String assPortConvert(String hexStr) {
        StringBuilder sb = new StringBuilder();
        int iLength = hexStr.length();
        for (int i = 0; i < iLength; i += 4) {
            int t = Integer.parseInt(hexStr.substring(i, i + 4), 16);
            if (t == 65534) continue;
            sb.append(t).append("&");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    private TEScriptCmd constructScriptCmd(TEEtherDBPSMOPO dbpsObj, TEEtherDBPSVlanGrpMOPO vlanObj, int item) {
        String serviceTypeVal;
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.setCmdCode(item);
        int dbpsID = dbpsObj.getDbpsID();
        int mastBID = dbpsObj.getMastBID();
        int slvBID = dbpsObj.getSlvBID();
        int protocol = dbpsObj.getProtocol();
        int mastBRA = dbpsObj.getMastBRASPort();
        int slvBRA = dbpsObj.getSlvBRASPort();
        String mastCom = dbpsObj.getMastComported();
        String slvCom = dbpsObj.getSlvComported();
        String assPort = dbpsObj.getAssoPort();
        int serviceType = dbpsObj.getServiceType();
        String mastSerPort = dbpsObj.getWserport();
        String slvSerPort = dbpsObj.getPserport();
        String vrrpVlan = dbpsObj.getVrrpVLanList();
        if (null != vlanObj) {
            int vlanBegin = vlanObj.getVlanBegin();
            int vlanEnd = vlanObj.getVlanEnd();
            if (-1 != vlanBegin) {
                cmd.addPara("vlanbegin", vlanBegin, false, false);
            }
            if (-1 != vlanEnd) {
                cmd.addPara("vlanend", vlanEnd, false, false);
            }
        }
        if (-1 != dbpsID) {
            cmd.addPara("dbpsid", dbpsID, false, false);
        }
        if (-1 != mastBID) {
            cmd.addPara("mastbid", mastBID, false, false);
        }
        if (-1 != slvBID) {
            cmd.addPara("slvbid", slvBID, false, false);
        }
        if (-1 != mastBRA) {
            cmd.addPara("mastbrasport", mastBRA, false, false);
        }
        if (-1 != slvBRA) {
            cmd.addPara("slvbrasport", slvBRA, false, false);
        }
        if (!STR_DEFAULT_VALUE.equals(assPort)) {
            cmd.addPara("assoport", this.assPortConvert(assPort), false, false);
        }
        if (!STR_DEFAULT_VALUE.equals(mastCom)) {
            cmd.addPara("mastcomported", mastCom, false, false);
        }
        if (!STR_DEFAULT_VALUE.equals(slvCom)) {
            cmd.addPara("slvcomported", slvCom, false, false);
        }
        if (!STR_DEFAULT_VALUE.equals(mastSerPort)) {
            cmd.addPara("mastserportlist", this.assPortConvert(mastSerPort), false, false);
        }
        if (!STR_DEFAULT_VALUE.equals(slvSerPort)) {
            cmd.addPara("slvserportlist", this.assPortConvert(slvSerPort), false, false);
        }
        if (!STR_DEFAULT_VALUE.equals(vrrpVlan)) {
            cmd.addPara("vrrpvlanlist", vrrpVlan, false, false);
        }
        String protocolVal = STR_DEFAULT_VALUE;
        switch (protocol) {
            case 0: {
                protocolVal = "disable";
                break;
            }
            case 1: {
                protocolVal = "arp";
                break;
            }
            case 2: {
                protocolVal = "vrrp";
                break;
            }
            case 3: {
                protocolVal = "arpvrrp";
                break;
            }
            default: {
                protocolVal = "arp";
            }
        }
        cmd.addPara("protocol", protocolVal, false, false);
        switch (serviceType) {
            case 0: {
                serviceTypeVal = "sncp";
                break;
            }
            case 1: {
                serviceTypeVal = "erps";
                break;
            }
            default: {
                serviceTypeVal = STR_DEFAULT_VALUE;
            }
        }
        if (!STR_DEFAULT_VALUE.equals(serviceTypeVal)) {
            cmd.addPara("servicetype", serviceTypeVal, false, false);
        }
        return cmd;
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }
}

